/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.enilink.commons.iterator.Filter;
import net.enilink.commons.iterator.WrappedIterator;

public class FilterIterator<T>
extends WrappedIterator<T> {
    protected final Filter<? super T> f;
    protected T current;
    protected boolean canRemove;
    protected boolean hasCurrent;

    public FilterIterator(Filter<? super T> f, Iterator<? extends T> e) {
        super(e);
        this.f = f;
    }

    @Override
    public synchronized boolean hasNext() {
        while (!this.hasCurrent && super.hasNext()) {
            this.current = super.next();
            this.hasCurrent = this.accept(this.current);
        }
        this.canRemove = false;
        return this.hasCurrent;
    }

    protected boolean accept(T x) {
        return this.f.accept(x);
    }

    @Override
    public synchronized void remove() {
        if (!this.canRemove) {
            throw new IllegalStateException("FilterIterators do not permit calls to hasNext between calls to next and remove.");
        }
        super.remove();
    }

    @Override
    public synchronized T next() {
        if (this.hasCurrent || this.hasNext()) {
            this.canRemove = true;
            this.hasCurrent = false;
            return this.current;
        }
        throw new NoSuchElementException();
    }
}

