/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.enilink.commons.iterator.Filter;
import net.enilink.commons.iterator.FilterDropIterator;
import net.enilink.commons.iterator.FilterKeepIterator;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.IMap;
import net.enilink.commons.iterator.MappedIterator;

public class NiceIterator<T>
implements IExtendedIterator<T> {
    private static final NiceIterator<?> emptyInstance = new NiceIterator();

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    protected void ensureHasNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public T next() {
        return this.noElements("empty NiceIterator");
    }

    protected T noElements(String message) {
        throw new NoSuchElementException(message);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported for this iterator");
    }

    public static <T> IExtendedIterator<T> andThen(final Iterator<? extends T> a, Iterator<? extends T> b) {
        final ArrayList<Iterator<? extends T>> L = new ArrayList<Iterator<? extends T>>(2);
        L.add(b);
        return new NiceIterator<T>(){
            private int index = 0;
            private Iterator<? extends T> current = a;

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext() && this.index < L.size()) {
                    this.current = (Iterator)L.get(this.index++);
                }
                return this.current.hasNext();
            }

            @Override
            public T next() {
                return this.hasNext() ? this.current.next() : this.noElements("concatenation");
            }

            @Override
            public void close() {
                1.close(this.current);
                for (int i = this.index; i < L.size(); ++i) {
                    1.close((Iterator)L.get(i));
                }
            }

            @Override
            public void remove() {
                this.current.remove();
            }

            @Override
            public IExtendedIterator<T> andThen(Iterator<? extends T> other) {
                L.add(other);
                return this;
            }
        };
    }

    @Override
    public IExtendedIterator<T> andThen(Iterator<? extends T> other) {
        return NiceIterator.andThen(this, other);
    }

    @Override
    public IExtendedIterator<T> filterKeep(Filter<? super T> f) {
        return new FilterKeepIterator<T>(f, this);
    }

    @Override
    public IExtendedIterator<T> filterDrop(Filter<? super T> f) {
        return new FilterDropIterator<T>(f, this);
    }

    @Override
    public <B> IExtendedIterator<B> mapWith(IMap<? super T, ? extends B> map) {
        return new MappedIterator<T, B>(map, this);
    }

    public static void close(Iterator<?> it) {
        if (it instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)it)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> IExtendedIterator<T> emptyIterator() {
        return emptyInstance;
    }

    @Override
    public List<T> toList() {
        return NiceIterator.asList(this);
    }

    @Override
    public Set<T> toSet() {
        return NiceIterator.asSet(this);
    }

    public static <T> Set<T> asSet(IExtendedIterator<? extends T> it) {
        HashSet result = new HashSet();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> List<T> asList(Iterator<? extends T> it) {
        ArrayList<T> result = new ArrayList<T>();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

