/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.iterator;

import java.util.Enumeration;
import java.util.Iterator;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.NiceIterator;

public class WrappedIterator<T>
extends NiceIterator<T> {
    protected boolean removeDenied;
    protected final Iterator<? extends T> base;

    public static <T> IExtendedIterator<T> create(Iterator<T> it) {
        return it instanceof IExtendedIterator ? (IExtendedIterator)it : new WrappedIterator<T>(it, false);
    }

    public static <T> IExtendedIterator<T> create(Enumeration<T> e) {
        return new WrappedIterator(new EnumerationIterator(e), false);
    }

    public static <T> WrappedIterator<T> createNoRemove(Iterator<T> it) {
        return new WrappedIterator<T>(it, true);
    }

    protected WrappedIterator(Iterator<? extends T> base) {
        this(base, false);
    }

    protected WrappedIterator(Iterator<? extends T> base, boolean removeDenied) {
        this.base = base;
        this.removeDenied = removeDenied;
    }

    @Override
    public boolean hasNext() {
        return this.base.hasNext();
    }

    @Override
    public T next() {
        return this.base.next();
    }

    @Override
    public void remove() {
        if (this.removeDenied) {
            throw new UnsupportedOperationException();
        }
        this.base.remove();
    }

    @Override
    public void close() {
        WrappedIterator.close(this.base);
    }

    public static void close(Iterator<?> it) {
        NiceIterator.close(it);
    }

    private static class EnumerationIterator<E>
    implements Iterator<E> {
        Enumeration<E> e;

        private EnumerationIterator(Enumeration<E> e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public E next() {
            return this.e.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Underlying enumeration does not support removal of elements");
        }
    }
}

