/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import net.enilink.komma.common.AbstractKommaPlugin;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import org.eclipse.core.runtime.FileLocator;

public final class CommonPlugin
extends AbstractKommaPlugin {
    public static final String PLUGIN_ID = "net.enilink.komma.common";
    public static final CommonPlugin INSTANCE = new CommonPlugin();
    private static Implementation plugin;
    private static final Method COLLATOR_GET_INSTANCE_METHOD;

    private CommonPlugin() {
        super(new IResourceLocator[0]);
    }

    @Override
    public IResourceLocator getBundleResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static URI asLocalURI(URI uri) {
        return plugin == null ? uri : Implementation.asLocalURI(uri);
    }

    public static URI resolve(URI uri) {
        return plugin == null ? uri : Implementation.resolve(uri);
    }

    public Comparator<String> getComparator() {
        return this.getComparator(Locale.getDefault());
    }

    public Comparator<String> getComparator(Locale locale) {
        if (COLLATOR_GET_INSTANCE_METHOD != null) {
            try {
                return (Comparator)COLLATOR_GET_INSTANCE_METHOD.invoke(null, locale);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Collator.getInstance(locale);
    }

    static {
        Method collatorGetInstanceMethod = null;
        try {
            Class<?> collatorClass = CommonPlugin.class.getClassLoader().loadClass("com.ibm.icu.text.Collator");
            collatorGetInstanceMethod = collatorClass.getMethod("getInstance", Locale.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        COLLATOR_GET_INSTANCE_METHOD = collatorGetInstanceMethod;
    }

    public static class Implementation
    extends AbstractKommaPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        protected static URI asLocalURI(URI uri) {
            try {
                String fragment = uri.fragment();
                URL url = FileLocator.toFileURL((URL)new URL(uri.trimFragment().toString()));
                return Implementation.fix(url, fragment);
            }
            catch (IOException iOException) {
                return uri;
            }
        }

        protected static URI resolve(URI uri) {
            String fragment = uri.fragment();
            URI uriWithoutFragment = uri.trimFragment();
            String uriWithoutFragmentToString = uriWithoutFragment.toString();
            URL url = null;
            try {
                url = FileLocator.resolve((URL)new URL(uriWithoutFragmentToString));
            }
            catch (IOException exception1) {
                try {
                    uriWithoutFragmentToString = URIs.decode((String)uriWithoutFragmentToString);
                    url = FileLocator.resolve((URL)new URL(uriWithoutFragmentToString));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (url != null) {
                try {
                    return Implementation.fix(url, fragment);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return uri;
        }

        protected static URI fix(URL url, String fragment) throws IOException {
            URI result;
            URI uRI = result = "file".equalsIgnoreCase(url.getProtocol()) ? URIs.createFileURI((String)URIs.decode((String)url.getFile())) : URIs.createURI((String)url.toString());
            if (fragment != null) {
                result = result.appendFragment(fragment);
            }
            return result;
        }
    }
}

