/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import net.enilink.komma.common.CommonPlugin;
import net.enilink.komma.common.command.AbortExecutionException;
import net.enilink.komma.common.command.AbstractCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.ICommandStack;
import net.enilink.komma.common.command.ICommandStackListener;
import net.enilink.komma.common.util.WrappedException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BasicCommandStack
implements ICommandStack {
    protected List<ICommand> commandList = new ArrayList<ICommand>();
    protected int top = -1;
    protected ICommand mostRecentCommand;
    protected Collection<ICommandStackListener> listeners = new ArrayList<ICommandStackListener>();
    protected int saveIndex = -1;

    @Override
    public IStatus execute(ICommand command, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.CANCEL_STATUS;
        if (command != null) {
            if (command.canExecute()) {
                try {
                    status = command.execute(monitor, info);
                    ListIterator<ICommand> commands = this.commandList.listIterator(this.top + 1);
                    while (commands.hasNext()) {
                        ICommand otherCommand = (ICommand)commands.next();
                        otherCommand.dispose();
                        commands.remove();
                    }
                    this.mostRecentCommand = command;
                    this.commandList.add(command);
                    ++this.top;
                    if (this.saveIndex >= this.top) {
                        this.saveIndex = -2;
                    }
                    this.notifyListeners();
                }
                catch (AbortExecutionException exception) {
                    command.dispose();
                }
                catch (RuntimeException exception) {
                    this.handleError(exception);
                    this.mostRecentCommand = null;
                    command.dispose();
                    this.notifyListeners();
                }
            } else {
                command.dispose();
            }
        }
        return status;
    }

    @Override
    public boolean canUndo() {
        return this.top != -1 && this.commandList.get(this.top).canUndo();
    }

    @Override
    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.CANCEL_STATUS;
        if (this.canUndo()) {
            ICommand command = this.commandList.get(this.top--);
            try {
                status = command.undo(monitor, info);
                this.mostRecentCommand = command;
            }
            catch (RuntimeException exception) {
                this.handleError(exception);
                this.mostRecentCommand = null;
                this.flush();
            }
            this.notifyListeners();
        }
        return status;
    }

    @Override
    public boolean canRedo() {
        return this.top < this.commandList.size() - 1;
    }

    @Override
    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.CANCEL_STATUS;
        if (this.canRedo()) {
            ICommand command = this.commandList.get(++this.top);
            try {
                command.redo(monitor, info);
                this.mostRecentCommand = command;
            }
            catch (RuntimeException exception) {
                this.handleError(exception);
                this.mostRecentCommand = null;
                ListIterator<ICommand> commands = this.commandList.listIterator(this.top--);
                while (commands.hasNext()) {
                    ICommand otherCommand = (ICommand)commands.next();
                    otherCommand.dispose();
                    commands.remove();
                }
            }
            this.notifyListeners();
        }
        return status;
    }

    @Override
    public void flush() {
        ListIterator<ICommand> commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            ICommand command = (ICommand)commands.next();
            command.dispose();
            commands.remove();
        }
        this.commandList.clear();
        this.top = -1;
        this.saveIndex = -1;
        this.notifyListeners();
        this.mostRecentCommand = null;
    }

    @Override
    public ICommand getUndoCommand() {
        return this.top == -1 || this.top == this.commandList.size() ? null : this.commandList.get(this.top);
    }

    @Override
    public ICommand getRedoCommand() {
        return this.top + 1 >= this.commandList.size() ? null : this.commandList.get(this.top + 1);
    }

    @Override
    public ICommand getMostRecentCommand() {
        return this.mostRecentCommand;
    }

    @Override
    public void addCommandStackListener(ICommandStackListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeCommandStackListener(ICommandStackListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners() {
        for (ICommandStackListener commandStackListener : this.listeners) {
            commandStackListener.commandStackChanged(new EventObject(this));
        }
    }

    protected void handleError(Exception exception) {
        CommonPlugin.INSTANCE.log(new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), exception).fillInStackTrace());
    }

    public void saveIsDone() {
        this.saveIndex = this.top;
    }

    public boolean isSaveNeeded() {
        if (this.saveIndex < -1) {
            return true;
        }
        if (this.top > this.saveIndex) {
            for (int i = this.top; i > this.saveIndex; --i) {
                if (this.commandList.get(i) instanceof AbstractCommand.INonDirtying) continue;
                return true;
            }
        } else {
            for (int i = this.saveIndex; i > this.top; --i) {
                if (this.commandList.get(i) instanceof AbstractCommand.INonDirtying) continue;
                return true;
            }
        }
        return false;
    }
}

