/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common.command;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class CommandResult {
    private final Object returnValue;
    private final IStatus status;

    public static final CommandResult newCommandResult(IStatus status, Object result) {
        return new CommandResult(status, result);
    }

    public static final CommandResult newOKCommandResult() {
        return new CommandResult((IStatus)new Status(0, "net.enilink.komma.common", 0, "", null), null);
    }

    public static final CommandResult newOKCommandResult(Object result) {
        return new CommandResult((IStatus)new Status(0, "net.enilink.komma.common", 0, "", null), result);
    }

    public static final CommandResult newCancelledCommandResult() {
        return new CommandResult((IStatus)new Status(8, "net.enilink.komma.common", 6, "The operation has been cancelled.", null), null);
    }

    public static final CommandResult newErrorCommandResult(String errorMessage) {
        return new CommandResult((IStatus)new Status(4, "net.enilink.komma.common", 4, errorMessage, null), null);
    }

    public static final CommandResult newErrorCommandResult(Throwable throwable) {
        return new CommandResult((IStatus)new Status(4, "net.enilink.komma.common", 4, throwable.getLocalizedMessage(), throwable), null);
    }

    public static final CommandResult newWarningCommandResult(String warningMessage, Object result) {
        return new CommandResult((IStatus)new Status(2, "net.enilink.komma.common", 0, warningMessage, null), result);
    }

    public CommandResult(IStatus status) {
        this(status, null);
    }

    public CommandResult(IStatus status, Object returnValue) {
        assert (null != status) : "null status";
        this.status = status;
        this.returnValue = returnValue;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public Collection<?> getReturnValues() {
        Object returnValue = this.getReturnValue();
        if (returnValue instanceof Collection) {
            return (Collection)returnValue;
        }
        return Arrays.asList(returnValue);
    }
}

