/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common.notify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import net.enilink.komma.common.notify.FilterUtil;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.notify.INotificationBroadcaster;
import net.enilink.komma.common.notify.INotificationListener;
import net.enilink.komma.common.notify.INotifier;

public class NotificationSupport<T extends INotification>
implements INotificationBroadcaster<T>,
INotifier<T> {
    private CopyOnWriteArraySet<INotificationListener<T>> listeners = new CopyOnWriteArraySet();

    @Override
    public void fireNotifications(Collection<? extends T> notifications) {
        ArrayList cache = new ArrayList();
        for (INotificationListener<? extends T> iNotificationListener : this.listeners) {
            Collection<T> filtered = FilterUtil.select(notifications, iNotificationListener.getFilter(), cache);
            if (filtered.isEmpty()) continue;
            iNotificationListener.notifyChanged(filtered);
        }
    }

    @Override
    public void addListener(INotificationListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(INotificationListener<T> listener) {
        this.listeners.remove(listener);
    }
}

