/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.dm.change.DataChangeTracker;
import net.enilink.komma.dm.change.IDataChange;
import net.enilink.komma.dm.change.IDataChangeListener;
import net.enilink.komma.dm.change.IDataChangeTracker;
import net.enilink.komma.dm.change.IStatementChange;
import net.enilink.komma.em.internal.CachedEntity;
import net.enilink.komma.em.util.IClosable;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.rdf.RDF;

public class CacheModule
extends AbstractModule {
    private String cacheName;
    public static CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(30000L);

    public CacheModule(String cacheName) {
        this.cacheName = cacheName;
    }

    protected void configure() {
        Multibinder closableBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<IClosable>(){});
        closableBinder.addBinding().to(CacheClosable.class);
    }

    @Provides
    @Singleton
    Cache<Object, CachedEntity> provideCache(IDataChangeTracker changeTracker) {
        final Cache cache = builder.build();
        IDataChangeListener refreshListener = new IDataChangeListener(){

            boolean refresh(Object entity) {
                CachedEntity cached = (CachedEntity)cache.getIfPresent(entity);
                boolean refreshed = false;
                if (cached != null) {
                    for (Object contextKey : cached.contexts()) {
                        Object entityInCtx = cached.getSelf(contextKey);
                        if (!(entityInCtx instanceof IEntity)) continue;
                        ((IEntity)entityInCtx).refresh();
                        refreshed = true;
                    }
                }
                return refreshed;
            }

            public void dataChanged(List<IDataChange> changes) {
                for (IDataChange change : changes) {
                    CachedEntity cachedObject;
                    if (!(change instanceof IStatementChange)) continue;
                    IStatement stmt = ((IStatementChange)change).getStatement();
                    boolean subjectRefreshed = this.refresh(stmt.getSubject());
                    this.refresh(stmt.getObject());
                    if (stmt.getContext() != null && OWL.PROPERTY_IMPORTS.equals((Object)stmt.getPredicate())) {
                        cache.invalidateAll();
                        continue;
                    }
                    CachedEntity cachedSubject = (CachedEntity)cache.getIfPresent((Object)stmt.getSubject());
                    if (cachedSubject != null) {
                        cachedSubject.clearProperties();
                    }
                    if ((cachedObject = (CachedEntity)cache.getIfPresent(stmt.getObject())) != null) {
                        cachedObject.clearProperties();
                    }
                    if (!subjectRefreshed || !RDF.PROPERTY_TYPE.equals((Object)stmt.getPredicate())) continue;
                    cache.invalidate((Object)stmt.getSubject());
                }
            }
        };
        ((DataChangeTracker)changeTracker).addInternalChangeListener(refreshListener);
        return cache;
    }

    public static void stop() {
    }

    static class CacheClosable
    implements IClosable {
        @Inject
        Cache<Object, CachedEntity> cache;

        CacheClosable() {
        }

        @Override
        public void close() {
            if (this.cache != null) {
                this.cache.invalidateAll();
                this.cache = null;
            }
        }
    }
}

