/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Set;
import net.enilink.komma.core.IDialect;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IEntityManagerFactory;
import net.enilink.komma.core.IProvider;
import net.enilink.komma.core.IUnitOfWork;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.core.SparqlStandardDialect;
import net.enilink.komma.core.URI;
import net.enilink.komma.dm.IDataManagerFactory;
import net.enilink.komma.em.ManagerCompositionModule;
import net.enilink.komma.em.util.IClosable;

class EntityManagerFactory
implements IEntityManagerFactory {
    @Inject(optional=true)
    Set<IClosable> closables;
    @Inject(optional=true)
    IDataManagerFactory dmFactory;
    private IEntityManagerFactory parent = null;
    IProvider<Locale> locale;
    Injector injector;
    Module managerModule;
    KommaModule module;
    private volatile boolean open = true;
    @Inject
    IUnitOfWork unitOfWork;
    volatile IEntityManager sharedManager;

    EntityManagerFactory(KommaModule module, IProvider<Locale> locale, Module managerModule) {
        this.module = module;
        this.locale = locale;
        this.managerModule = managerModule;
    }

    public synchronized void close() {
        if (this.open) {
            if (this.parent == null) {
                if (this.dmFactory != null) {
                    this.dmFactory.close();
                }
                if (this.closables != null) {
                    for (IClosable closable : this.closables) {
                        closable.close();
                    }
                    this.closables = null;
                }
            }
            this.open = false;
        }
    }

    private void ensureFactoryIsOpened() {
        if (!this.open) {
            throw new RuntimeException("EntityManagerFactory is closed!");
        }
    }

    public IEntityManager create() {
        this.ensureFactoryIsOpened();
        return (IEntityManager)this.getManagerInjector(new AbstractModule(){

            protected void configure() {
                this.bind(IEntityManager.class).to(Key.get(IEntityManager.class, (Annotation)Names.named((String)"unmanaged"))).in(Singleton.class);
            }
        }).getInstance(IEntityManager.class);
    }

    public IEntityManager create(final IEntityManager scope) {
        this.ensureFactoryIsOpened();
        return (IEntityManager)this.getManagerInjector(new AbstractModule(){

            protected void configure() {
                this.bind(IEntityManager.class).toInstance((Object)scope);
            }
        }).getInstance(Key.get(IEntityManager.class, (Annotation)Names.named((String)"unmanaged")));
    }

    public IEntityManagerFactory createChildFactory(KommaModule ... modules) {
        return this.createChildFactory((IProvider<Locale>)null, modules);
    }

    public IEntityManagerFactory createChildFactory(IProvider<Locale> locale, KommaModule ... modules) {
        KommaModule childModule = new KommaModule(this.module.getClassLoader());
        childModule.includeModule(this.module);
        for (KommaModule include : modules) {
            childModule.includeModule(include);
            for (URI writable : include.getWritableGraphs()) {
                childModule.addWritableGraph(writable);
            }
        }
        EntityManagerFactory childFactory = new EntityManagerFactory(childModule, locale == null ? this.locale : locale, this.managerModule);
        childFactory.parent = this;
        this.injector.injectMembers((Object)childFactory);
        return childFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntityManager get() {
        if (this.sharedManager == null) {
            EntityManagerFactory entityManagerFactory = this;
            synchronized (entityManagerFactory) {
                if (this.sharedManager == null) {
                    this.sharedManager = (IEntityManager)this.getManagerInjector(new AbstractModule(){

                        protected void configure() {
                            IEntityManager manager = EntityManagerFactory.this.create();
                            this.bind(IEntityManager.class).toInstance((Object)manager);
                        }
                    }).getInstance(IEntityManager.class);
                }
            }
        }
        return this.sharedManager;
    }

    public IDialect getDialect() {
        if (this.dmFactory != null) {
            return this.dmFactory.getDialect();
        }
        return new SparqlStandardDialect();
    }

    public IEntityManagerFactory getParent() {
        return this.parent;
    }

    protected synchronized Injector getManagerInjector(AbstractModule customModule) {
        return this.injector.createChildInjector(new Module[]{customModule, new ManagerCompositionModule(this.module), new AbstractModule(){

            protected void configure() {
                this.bind(IEntityManagerFactory.class).annotatedWith((Annotation)Names.named((String)"currentFactory")).toInstance((Object)EntityManagerFactory.this);
                this.bind((TypeLiteral)new TypeLiteral<Set<URI>>(){}).annotatedWith((Annotation)Names.named((String)"readContexts")).toInstance((Object)EntityManagerFactory.this.module.getReadableGraphs());
                this.bind((TypeLiteral)new TypeLiteral<Set<URI>>(){}).annotatedWith((Annotation)Names.named((String)"modifyContexts")).toInstance((Object)EntityManagerFactory.this.module.getWritableGraphs());
                this.bind(Locale.class).toProvider((Provider)new Provider<Locale>(){

                    public Locale get() {
                        return EntityManagerFactory.this.locale == null ? Locale.getDefault() : (Locale)EntityManagerFactory.this.locale.get();
                    }
                });
            }
        }, this.managerModule});
    }

    public KommaModule getModule() {
        return this.module;
    }

    public IUnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public boolean isOpen() {
        return this.open;
    }

    @Inject
    public void setInjector(Injector injector) {
        if (this.injector == null) {
            this.injector = injector;
        }
    }
}

