/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.util.Locale;
import net.enilink.komma.core.IEntityDecorator;
import net.enilink.komma.core.IEntityManagerFactory;
import net.enilink.komma.core.IProvider;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.dm.change.DataChangeTracker;
import net.enilink.komma.dm.change.IDataChangeSupport;
import net.enilink.komma.dm.change.IDataChangeTracker;
import net.enilink.komma.em.EntityManagerFactory;
import net.enilink.komma.em.EntityVarModule;

public class EntityManagerFactoryModule
extends AbstractModule {
    IProvider<Locale> locale;
    Module managerModule;
    KommaModule module;

    public EntityManagerFactoryModule(KommaModule module, IProvider<Locale> locale) {
        this(module, locale, null);
    }

    public EntityManagerFactoryModule(KommaModule module, IProvider<Locale> locale, Module managerModule) {
        this.module = module;
        this.locale = locale;
        this.managerModule = managerModule;
    }

    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), IEntityDecorator.class);
        this.bind(DataChangeTracker.class).in(Singleton.class);
        this.bind(IDataChangeSupport.class).to(DataChangeTracker.class);
        this.bind(IDataChangeTracker.class).to(DataChangeTracker.class);
        this.install((Module)new EntityVarModule());
    }

    @Singleton
    @Provides
    IEntityManagerFactory provideFactory(Injector injector) {
        EntityManagerFactory factory = new EntityManagerFactory(this.module, this.locale, this.managerModule);
        injector.injectMembers((Object)factory);
        return factory;
    }
}

