/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.MembersInjector;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.EntityVar;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IReferenceable;

public class EntityVarModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Map<EntityVarKey, EntityVar<Object>>>(){}).toInstance(new ConcurrentHashMap());
        EntityVarTypeListener varTypeListener = new EntityVarTypeListener();
        this.requestInjection(varTypeListener);
        this.bindListener(Matchers.any(), varTypeListener);
    }

    class EntityVarTypeListener
    implements TypeListener {
        @Inject
        Injector injector;

        EntityVarTypeListener() {
        }

        public <T> void hear(TypeLiteral<T> typeLiteral, TypeEncounter<T> typeEncounter) {
            for (Class c = typeLiteral.getRawType(); c != Object.class; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    if (field.getType() != EntityVar.class) continue;
                    EntityVarMembersInjector membersInjector = new EntityVarMembersInjector(field);
                    this.injector.injectMembers(membersInjector);
                    typeEncounter.register(membersInjector);
                }
            }
        }
    }

    class EntityVarMembersInjector<T>
    implements MembersInjector<T> {
        @Inject
        private Map<EntityVarKey, EntityVar<Object>> varMap;
        private Field field;

        EntityVarMembersInjector(Field field) {
            this.field = field;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void injectMembers(T target) {
            Object referenceable = target;
            if (referenceable instanceof Behaviour) {
                referenceable = ((Behaviour)target).getBehaviourDelegate();
            }
            if (referenceable instanceof IReferenceable) {
                IReference reference = ((IReferenceable)referenceable).getReference();
                final EntityVarKey key = new EntityVarKey(this.field, reference);
                EntityVarImpl<Object> var = this.varMap.get(key);
                if (var == null) {
                    Class<?> clazz = this.field.getDeclaringClass();
                    synchronized (clazz) {
                        var = this.varMap.get(key);
                        if (var == null) {
                            var = new EntityVarImpl<Object>(){
                                boolean isValid = true;

                                @Override
                                public void remove() {
                                    super.remove();
                                    EntityVarMembersInjector.this.varMap.remove(key);
                                    this.isValid = false;
                                }

                                @Override
                                public void set(Object value) {
                                    if (!this.isValid && value != null) {
                                        EntityVarMembersInjector.this.varMap.put(key, this);
                                        this.isValid = true;
                                    }
                                    super.set(value);
                                }
                            };
                            this.varMap.put(key, (EntityVar<Object>)var);
                        }
                    }
                }
                try {
                    this.field.setAccessible(true);
                    this.field.set(target, var);
                }
                catch (Exception e) {
                    throw new ProvisionException("Error while injecting entity variable.", (Throwable)e);
                }
            }
            throw new ProvisionException("Unable to determine reference for target: " + target);
        }
    }

    static class EntityVarImpl<T>
    implements EntityVar<T> {
        private T value;

        EntityVarImpl() {
        }

        public T get() {
            return this.value;
        }

        public void remove() {
            this.value = null;
        }

        public void set(T value) {
            if (value == null) {
                this.remove();
            } else {
                this.value = value;
            }
        }
    }

    static class EntityVarKey {
        private Field field;
        private IReference reference;

        public EntityVarKey(Field field, IReference reference) {
            this.field = field;
            this.reference = reference;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityVarKey other = (EntityVarKey)obj;
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("(field = ");
            if (this.field == null) {
                sb.append((String)null);
            } else {
                sb.append(this.field.getDeclaringClass()).append("#").append(this.field.getName());
            }
            return sb.append(", reference = ").append(this.reference).append(")").toString();
        }
    }
}

