/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em;

import com.google.inject.Inject;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.IDataManagerFactory;
import net.enilink.komma.em.DelegatingDataManager;
import net.enilink.komma.em.util.UnitOfWork;

public class ThreadLocalDataManager
extends DelegatingDataManager {
    @Inject
    protected IDataManagerFactory dmFactory;
    @Inject
    protected UnitOfWork uow;
    private ThreadLocal<IDataManager> delegate = new ThreadLocal();

    @Override
    public void close() {
        IDataManager manager = this.delegate.get();
        if (manager != null) {
            manager.close();
            this.delegate.remove();
        }
    }

    protected IDataManager initialValue() {
        return (IDataManager)this.dmFactory.get();
    }

    @Override
    public IDataManager getDelegate() {
        IDataManager manager = this.delegate.get();
        if (manager == null || !manager.isOpen()) {
            if (!this.uow.isActive()) {
                throw new KommaException("No active unit of work found.");
            }
            manager = this.initialValue();
            this.uow.addCloseable((AutoCloseable)((Object)this));
            this.delegate.set(manager);
        }
        return manager;
    }

    @Override
    public boolean isOpen() {
        IDataManager manager = this.delegate.get();
        return manager != null ? manager.isOpen() : false;
    }
}

