/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.concepts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.UniqueExtendedIterator;
import net.enilink.commons.util.Pair;
import net.enilink.composition.properties.PropertySet;
import net.enilink.composition.properties.PropertySetFactory;
import net.enilink.composition.properties.traits.PropertySetOwner;
import net.enilink.composition.properties.util.UnmodifiablePropertySet;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IResultDescriptor;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.concepts.BehaviorBase;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.em.internal.behaviours.OrderedPropertySet;
import net.enilink.komma.em.results.ResultDescriptor;
import net.enilink.komma.em.util.KommaUtil;
import net.enilink.vocab.owl.FunctionalProperty;

public abstract class ResourceSupport
extends BehaviorBase
implements IResource,
Behaviour<IResource> {
    @Inject
    protected PropertySetFactory propertySetFactory;
    private static final String HAS_APPLICABLE_PROPERTY = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { {?property a owl:AnnotationProperty OPTIONAL {?property rdfs:domain ?domain . \t\tOPTIONAL {?resurce a ?class . ?class rdfs:subClassOf ?domain}} FILTER (!bound(?domain) || bound(?class))} UNION {?property rdfs:subPropertyOf rdf:type} UNION {?resource a ?class .{{?property rdfs:domain ?class} UNION{?class rdfs:subClassOf ?restriction . ?restriction owl:onProperty ?property}}}}";
    private static final String SELECT_APPLICABLE_CARDINALITY = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?min ?max WHERE { ?resource a ?class .?class rdfs:subClassOf ?restriction .?restriction owl:onProperty ?property .{OPTIONAL {?restriction owl:minCardinality ?min }OPTIONAL {?restriction owl:maxCardinality ?max }OPTIONAL {?restriction owl:cardinality ?min .?restriction owl:cardinality ?max .}} UNION {OPTIONAL {?restriction owl:minQualifiedCardinality ?min }OPTIONAL {?restriction owl:maxQualifiedCardinality ?max }OPTIONAL {?restriction owl:qualifiedCardinality ?min .?restriction owl:qualifiedCardinality ?max .}}} ORDER BY DESC(?min) ?max";
    private static final String SELECT_APPLICABLE_CHILD_PROPERTIES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?property WHERE { {?resource a ?class .?class rdfs:subClassOf+ [owl:onProperty ?property] .{ ?property rdfs:subPropertyOf+ komma:child } UNION { ?property rdfs:subPropertyOf+ komma:contains } .FILTER NOT EXISTS {    ?otherProperty rdfs:subPropertyOf ?property .    ?class rdfs:subClassOf [owl:onProperty ?otherProperty]\tFILTER (?property != ?otherProperty)} } UNION {    ?resource ?property ?someObject .    { ?property rdfs:subPropertyOf+ komma:child } UNION { ?property rdfs:subPropertyOf+ komma:contains } .    FILTER NOT EXISTS {        ?otherProperty rdfs:subPropertyOf ?property .        ?resource ?otherProperty ?someObject .        FILTER (?property != ?otherProperty)    }}} ORDER BY ?property";
    private static final String SELECT_APPLICABLE_PROPERTIES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?property WHERE { { ?property a owl:AnnotationProperty FILTER NOT EXISTS { ?property rdfs:domain ?domain }} UNION { ?property rdfs:subPropertyOf rdf:type } UNION { ?resource a ?class .{{ ?property rdfs:domain ?class } UNION{ ?class rdfs:subClassOf ?restriction . ?restriction owl:onProperty ?property }}}} ORDER BY ?property";
    private static final String SELECT_CONTAINER = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT ?container WHERE { ?container komma:contains ?obj . }";
    private static final String COUNT_PROPERTY_OBJECTS = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT (count(?obj) as ?count) WHERE { ?subj ?pred ?obj . }";
    private static final String SELECT_PROPERTY_OBJECTS = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT ?obj WHERE { ?subj ?pred ?obj . }";
    @Inject
    private Injector injector;
    private Map<IReference, PropertyInfo> properties;

    public static final IResultDescriptor<IClass> DIRECT_CLASSES_DESC() {
        return new ResultDescriptor(ResourceSupport.SELECT_DIRECT_CLASSES(false), "komma:directClasses", "class", "resource").bindResultType(IClass.class, new Class[0]);
    }

    public static final IResultDescriptor<IClass> DIRECT_NAMED_CLASSES_DESC() {
        return new ResultDescriptor(ResourceSupport.SELECT_DIRECT_CLASSES(true), "komma:directNamedClasses", "class", "resource").bindResultType(IClass.class, new Class[0]);
    }

    private static final String SELECT_CLASSES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT ?class WHERE {?resource a ?class" + (named ? " FILTER isIRI(?class)" : "") + "}";
    }

    private static final String SELECT_DIRECT_CLASSES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT ?class WHERE {?resource a ?class " + (named ? "FILTER (isIRI(?class)) " : "") + "FILTER NOT EXISTS {?resource a ?otherClass . ?otherClass rdfs:subClassOf ?class FILTER (" + (named ? "isIRI(?otherClass) && " : "") + "?otherClass != ?class)\t\tFILTER NOT EXISTS {?class rdfs:subClassOf ?otherClass}} FILTER NOT EXISTS {?resource a ?otherClass . FILTER (" + (named ? "isIRI(?otherClass) && " : "") + "(?class = owl:Thing || ?class = rdfs:Resource) && ?otherClass != ?class)}}";
    }

    @Override
    public void addProperty(IReference property, Object obj) {
        this.getEntityManager().add((Iterable)new Statement((IReference)this, property, obj));
    }

    private synchronized PropertyInfo ensurePropertyInfo(IReference property) {
        PropertyInfo propertyInfo;
        if (this.properties == null) {
            this.properties = new HashMap<IReference, PropertyInfo>();
        }
        if ((propertyInfo = this.properties.get(property)) == null) {
            propertyInfo = new PropertyInfo(property);
            this.properties.put(property, propertyInfo);
        }
        return propertyInfo;
    }

    @Override
    public Object get(IReference property) {
        PropertyInfo propertyInfo = this.ensurePropertyInfo(property);
        if (propertyInfo.isSingle()) {
            return propertyInfo.getPropertySet().getSingle();
        }
        return propertyInfo.getPropertySet().getAll();
    }

    @Override
    public Set<Object> getAsSet(IReference property) {
        return this.ensurePropertyInfo(property).getPropertySet().getAll();
    }

    @Override
    public Pair<Integer, Integer> getApplicableCardinality(IReference property) {
        IQuery query = this.getEntityManager().createQuery(SELECT_APPLICABLE_CARDINALITY);
        query.setParameter("resource", this.getBehaviourDelegate());
        query.setParameter("property", (Object)property);
        int min = 0;
        int max = Integer.MAX_VALUE;
        IExtendedIterator it = query.evaluate(IBindings.class, new Class[0]);
        while (it.hasNext()) {
            IBindings values = (IBindings)it.next();
            if (values.get("min") instanceof Number) {
                min = Math.max(min, ((Number)values.get("min")).intValue());
            }
            if (!(values.get("max") instanceof Number)) continue;
            max = Math.min(max, ((Number)values.get("max")).intValue());
        }
        if ((max = Math.max(min, max)) > 1 && this.getEntityManager().find(property) instanceof FunctionalProperty) {
            max = 1;
        }
        return new Pair((Object)min, (Object)max);
    }

    @Override
    public IExtendedIterator<IProperty> getApplicableChildProperties() {
        IQuery query = this.getEntityManager().createQuery(SELECT_APPLICABLE_CHILD_PROPERTIES);
        query.setParameter("resource", (Object)this);
        return query.evaluate(IProperty.class, new Class[0]);
    }

    @Override
    public int getCardinality(IReference property) {
        IQuery query = this.getEntityManager().createQuery(COUNT_PROPERTY_OBJECTS, true);
        query.setParameter("subj", (Object)this);
        query.setParameter("pred", (Object)property);
        Object count = query.getSingleResult();
        return count instanceof Number ? ((Number)count).intValue() : 0;
    }

    @Override
    public IExtendedIterator<IClass> getClasses() {
        return this.getClasses(false);
    }

    @Override
    public IExtendedIterator<IClass> getClasses(boolean includeInferred) {
        IQuery query = this.getEntityManager().createQuery(ResourceSupport.SELECT_CLASSES(false), includeInferred);
        query.setParameter("resource", this.getBehaviourDelegate());
        return query.evaluate(IClass.class, new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResource getContainer() {
        IQuery query = this.getEntityManager().createQuery(SELECT_CONTAINER);
        query.setParameter("obj", (Object)this);
        try (IExtendedIterator it = query.evaluate();){
            IResource iResource = it.hasNext() ? (IResource)it.next() : null;
            return iResource;
        }
    }

    @Override
    public IExtendedIterator<IClass> getDirectClasses() {
        return ((IQuery)this.getEntityManager().createQuery(ResourceSupport.DIRECT_CLASSES_DESC().toQueryString()).setParameter("resource", this.getBehaviourDelegate())).evaluate(IClass.class, new Class[0]);
    }

    @Override
    public IExtendedIterator<IClass> getDirectNamedClasses() {
        return ((IQuery)this.getEntityManager().createQuery(ResourceSupport.DIRECT_NAMED_CLASSES_DESC().toQueryString()).setParameter("resource", this.getBehaviourDelegate())).evaluate(IClass.class, new Class[0]);
    }

    @Override
    public IExtendedIterator<IClass> getNamedClasses() {
        IQuery query = this.getEntityManager().createQuery(ResourceSupport.SELECT_CLASSES(true));
        query.setParameter("resource", this.getBehaviourDelegate());
        return query.evaluate(IClass.class, new Class[0]);
    }

    private synchronized PropertyInfo getPropertyInfo(IReference property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    @Override
    public IExtendedIterator<IStatement> getPropertyStatements(IReference property, boolean includeInferred) {
        IExtendedIterator stmts = this.internalGetPropertyStmts(property, false, false, false);
        if (includeInferred) {
            stmts = UniqueExtendedIterator.create((Iterator)stmts.andThen(this.internalGetPropertyStmts(property, false, false, true)));
        }
        return stmts;
    }

    @Override
    public IExtendedIterator<IStatement> getInversePropertyStatements(IReference property, boolean filterSymmetric, boolean includeInferred) {
        IExtendedIterator stmts = this.internalGetPropertyStmts(property, true, filterSymmetric, false);
        if (includeInferred) {
            stmts = UniqueExtendedIterator.create((Iterator)stmts.andThen(this.internalGetPropertyStmts(property, true, filterSymmetric, true)));
        }
        return stmts;
    }

    @Override
    public IExtendedIterator<IStatement> getInversePropertyStatements(IReference property, boolean includeInferred) {
        return this.getInversePropertyStatements(property, false, includeInferred);
    }

    @Override
    public IExtendedIterator<IValue> getPropertyValues(IReference property, boolean includeInferred) {
        IQuery query = this.getEntityManager().createQuery(SELECT_PROPERTY_OBJECTS, includeInferred).bindResultType(IValue.class, new Class[0]);
        query.setParameter("subj", (Object)this);
        query.setParameter("pred", (Object)property);
        return query.evaluate();
    }

    @Override
    public IExtendedIterator<IProperty> getRelevantProperties() {
        IQuery query = this.getEntityManager().createQuery(SELECT_APPLICABLE_PROPERTIES);
        query.setParameter("resource", (Object)this);
        return query.evaluate(IProperty.class, new Class[0]);
    }

    @Override
    public Object getSingle(IReference property) {
        PropertyInfo propertyInfo = this.ensurePropertyInfo(property);
        return propertyInfo.getPropertySet().getSingle();
    }

    @Override
    public boolean hasApplicableProperty(IReference property) {
        IQuery query = this.getEntityManager().createQuery(HAS_APPLICABLE_PROPERTY);
        query.setParameter("resource", (Object)this);
        query.setParameter("property", (Object)property);
        return query.getBooleanResult();
    }

    @Override
    public boolean hasProperty(IReference property, Object obj, boolean includeInferred) {
        return ((IQuery)((IQuery)((IQuery)this.getEntityManager().createQuery("ASK { ?s ?p ?o }", includeInferred).setParameter("s", (Object)this)).setParameter("p", (Object)property)).setParameter("o", obj)).getBooleanResult();
    }

    protected IExtendedIterator<IStatement> internalGetPropertyStmts(IReference propertyRef, boolean inverse, boolean filterSymmetric, final boolean includeInferred) {
        final IEntity property = propertyRef instanceof IEntity || propertyRef == null ? (IEntity)propertyRef : this.getEntityManager().find(propertyRef);
        StringBuilder sb = new StringBuilder("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ");
        sb.append("SELECT ");
        if (property == null) {
            sb.append("?pred ");
        }
        String targetVar = inverse ? "?subj" : "?obj";
        sb.append(targetVar);
        sb.append(" WHERE { ?subj ?pred ?obj . ");
        if (filterSymmetric) {
            sb.append("FILTER (?subj != ?obj)");
        }
        sb.append(" }");
        IQuery query = this.getEntityManager().createQuery(sb.toString(), includeInferred);
        query.setParameter("pred", (Object)property);
        if (!inverse) {
            query.setParameter("subj", (Object)this);
            query.bindResultType("obj", new Class[]{IValue.class});
            return new ConvertingIterator<Object, IStatement>((Iterator)query.evaluate()){

                protected IStatement convert(Object value) {
                    if (value instanceof IBindings) {
                        IBindings values = (IBindings)value;
                        return new Statement((IReference)ResourceSupport.this.getBehaviourDelegate(), (IReference)(property != null ? property : (IReference)values.get("pred")), values.get("obj"), includeInferred);
                    }
                    return new Statement((IReference)ResourceSupport.this.getBehaviourDelegate(), (IReference)property, value, includeInferred);
                }
            };
        }
        query.setParameter("obj", (Object)this);
        query.bindResultType("subj", new Class[]{IValue.class});
        return new ConvertingIterator<Object, IStatement>((Iterator)query.evaluate()){

            protected IStatement convert(Object value) {
                if (value instanceof IBindings) {
                    IBindings values = (IBindings)value;
                    return new Statement((IReference)values.get("subj"), (IReference)(property != null ? property : (IReference)values.get("pred")), ResourceSupport.this.getBehaviourDelegate(), includeInferred);
                }
                return new Statement((IReference)value, (IReference)property, ResourceSupport.this.getBehaviourDelegate(), includeInferred);
            }
        };
    }

    @Override
    public boolean isOntLanguageTerm() {
        URI uri = this.getURI();
        return uri != null && KommaUtil.isW3cNamespace(uri.namespace());
    }

    @Override
    public boolean isPropertySet(IReference property, boolean includeInferred) {
        return this.hasProperty(property, null, includeInferred);
    }

    @Override
    public void refresh(IReference property) {
        PropertyInfo propertyInfo = this.getPropertyInfo(property);
        if (propertyInfo != null) {
            propertyInfo.getPropertySet().refresh();
        }
    }

    @Override
    public void removeProperty(IReference property) {
        this.getEntityManager().remove((Iterable)new Statement((IReference)this, property, null));
    }

    @Override
    public void removeProperty(IReference property, Object value) {
        this.getEntityManager().remove((Iterable)new Statement((IReference)this, property, value));
    }

    @Override
    public void set(IReference property, Object value) {
        PropertyInfo propertyInfo = this.ensurePropertyInfo(property);
        if (value == null) {
            propertyInfo.getPropertySet().getAll().clear();
        } else if (value instanceof Collection && !propertyInfo.isSingle()) {
            if (value instanceof Set) {
                propertyInfo.getPropertySet().setAll((Set)value);
            } else {
                propertyInfo.getPropertySet().setAll(new HashSet((Collection)value));
            }
        } else {
            propertyInfo.getPropertySet().setSingle(value);
        }
    }

    public void refresh() {
        this.properties = null;
    }

    class PropertyInfo {
        private IReference property;
        private PropertySet<Object> propertySet;
        private Boolean single;

        PropertyInfo(IReference property) {
            this.property = ResourceSupport.this.getEntityManager().find(property);
        }

        PropertySet<Object> getPropertySet() {
            if (this.propertySet != null) {
                return this.propertySet;
            }
            if (this.property instanceof IProperty && ((IProperty)this.property).isOrderedContainment()) {
                this.propertySet = new OrderedPropertySet((IReference)ResourceSupport.this.getBehaviourDelegate(), this.property);
                ResourceSupport.this.injector.injectMembers(this.propertySet);
            } else {
                Object self = ResourceSupport.this.getBehaviourDelegate();
                if (self instanceof PropertySetOwner) {
                    this.propertySet = ((PropertySetOwner)self).getPropertySet(this.property.getURI().toString());
                }
                if (this.propertySet == null) {
                    this.propertySet = ResourceSupport.this.propertySetFactory.createPropertySet(self, this.property.getURI().toString(), null, new Annotation[0]);
                }
                if (this.propertySet instanceof UnmodifiablePropertySet) {
                    this.propertySet = ((UnmodifiablePropertySet)this.propertySet).getDelegate();
                }
            }
            return this.propertySet;
        }

        boolean isSingle() {
            if (this.single == null) {
                this.single = this.property instanceof FunctionalProperty;
                if (!this.single.booleanValue()) {
                    Pair<Integer, Integer> cardinality = ResourceSupport.this.getApplicableCardinality(this.property);
                    this.single = (Integer)cardinality.getSecond() <= 1;
                }
            }
            return this.single;
        }
    }
}

