/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal;

import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.commons.iterator.Filter;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.composition.ClassResolver;
import net.enilink.composition.cache.annotations.Cacheable;
import net.enilink.composition.mappers.RoleMapper;
import net.enilink.composition.properties.PropertySet;
import net.enilink.composition.properties.komma.ConversionUtil;
import net.enilink.composition.properties.traits.Mergeable;
import net.enilink.composition.properties.traits.PropertySetOwner;
import net.enilink.composition.properties.traits.Refreshable;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IEntityManagerFactory;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.INamespace;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IReferenceable;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IStatementPattern;
import net.enilink.komma.core.ITransaction;
import net.enilink.komma.core.IUpdate;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.InferencingCapability;
import net.enilink.komma.core.Initializable;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Literal;
import net.enilink.komma.core.LockModeType;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.StatementPattern;
import net.enilink.komma.core.TransactionRequiredException;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.IDataManagerUpdate;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.em.internal.IEntityManagerInternal;
import net.enilink.komma.em.internal.ResourceManager;
import net.enilink.komma.em.internal.TypeManager;
import net.enilink.komma.em.internal.behaviours.IEntityManagerAware;
import net.enilink.komma.em.internal.query.Query;
import net.enilink.komma.em.internal.query.Update;
import net.enilink.komma.em.util.RESULTS;
import net.enilink.komma.literals.LiteralConverter;
import net.enilink.vocab.rdf.RDF;
import net.enilink.vocab.xmlschema.XMLSCHEMA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityManager
implements IEntityManager,
IEntityManagerInternal {
    protected static Logger log = LoggerFactory.getLogger(AbstractEntityManager.class);
    private static final URI RESULT_NODE = RESULTS.TYPE_RESULT;
    private ClassResolver<URI> classResolver;
    protected IDataManager dm;
    @Inject
    protected IEntityManagerFactory factory;
    @Inject
    protected Injector injector;
    @Inject
    private LiteralConverter literalConverter;
    @Inject
    private Provider<Locale> locale;
    private RoleMapper<URI> mapper;
    private Map<Object, IReference> merged = new MapMaker().weakKeys().makeMap();
    private volatile ResourceManager resourceManager;
    private volatile TypeManager typeManager;
    private volatile Map<URI, String> uriToPrefix = new ConcurrentHashMap<URI, String>();
    private volatile Map<String, URI> prefixToUri = new ConcurrentHashMap<String, URI>();
    private static final URI[] NO_CONTEXTS = new URI[0];
    private URI[] readContexts = NO_CONTEXTS;
    private URI[] modifyContexts = NO_CONTEXTS;
    protected Map<String, Object> properties;

    public void add(Iterable<? extends IStatement> statements) {
        this.add(statements, false);
    }

    public void add(Iterable<? extends IStatement> statements, boolean ignoreImports) {
        this.dm.add((Iterable)new ConvertingIterator<IStatement, IStatement>(statements.iterator()){

            protected IStatement convert(IStatement stmt) {
                if (!(stmt.getSubject() instanceof Behaviour) && !(stmt.getPredicate() instanceof Behaviour) && stmt.getObject() instanceof IValue) {
                    return stmt;
                }
                return new Statement(AbstractEntityManager.this.getReference(stmt.getSubject()), AbstractEntityManager.this.getReference(stmt.getPredicate()), (Object)AbstractEntityManager.this.toValue(stmt.getObject()), stmt.getContext(), stmt.isInferred());
            }
        }, (IReference[])(ignoreImports ? this.modifyContexts : this.readContexts), (IReference[])this.modifyContexts);
    }

    private <C extends Collection<URI>> C addConcept(IReference resource, Class<?> role, C set) {
        URI type = (URI)this.mapper.findType(role);
        if (type == null) {
            throw new KommaException("Concept is anonymous or is not registered: " + role.getSimpleName());
        }
        this.getTypeManager().addType(resource, type);
        set.add((URI)type);
        return set;
    }

    private void appendFilter(Class<?> concept, StringBuilder query) {
        HashSet types = new HashSet();
        this.mapper.findSubTypes(concept, types);
        Iterator iter = types.iterator();
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                query.append("{ ?subj a <");
                query.append(iter.next()).append(">}\n");
                if (!iter.hasNext()) continue;
                query.append(" UNION ");
            }
        } else {
            throw new KommaException("Concept not registered: " + concept.getSimpleName());
        }
    }

    private boolean assertConceptsRecorded(IEntity bean, Class<?> ... concepts) {
        for (Class<?> concept : concepts) {
            assert (!concept.isInterface() || concept.isAssignableFrom(bean.getClass())) : "Concept has not been recorded: " + concept.getSimpleName();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IReference assignReference(Object bean) {
        Map<Object, IReference> map = this.merged;
        synchronized (map) {
            if (this.merged.containsKey(bean)) {
                return this.merged.get(bean);
            }
            IReference reference = this.getReference(bean);
            if (reference == null) {
                reference = this.getResourceManager().createResource(null);
            }
            this.merged.put(bean, reference);
            return reference;
        }
    }

    public void clear() {
        this.dm.remove((Iterable)new Statement(null, null, null), (IReference[])this.modifyContexts);
    }

    public void clearNamespaces() {
        this.uriToPrefix = null;
        this.dm.clearNamespaces();
    }

    public void close() {
        if (this.dm != null) {
            this.dm.close();
        }
        this.dm = null;
    }

    public void close(Iterator<?> iter) {
        if (iter instanceof Closeable) {
            try {
                ((Closeable)((Object)iter)).close();
            }
            catch (IOException e) {
                throw new KommaException((Throwable)e);
            }
        }
    }

    private <T> Class<?>[] combine(Class<T> concept, Class<?> ... concepts) {
        Class[] roles;
        if (concepts == null || concepts.length == 0) {
            roles = new Class[]{concept};
        } else {
            roles = new Class[concepts.length + 1];
            roles[0] = concept;
            System.arraycopy(concepts, 0, roles, 1, concepts.length);
        }
        return roles;
    }

    public boolean contains(Object entity) {
        Behaviour behaviour;
        Object delegate;
        if (entity instanceof IEntity) {
            return this.equals(((IEntity)entity).getEntityManager());
        }
        if (entity instanceof Behaviour && (delegate = (behaviour = (Behaviour)entity).getBehaviourDelegate()) instanceof IEntity) {
            return this.equals(((IEntity)delegate).getEntityManager());
        }
        return false;
    }

    public <T> T create(Class<T> concept, Class<?> ... concepts) {
        return this.createNamed((URI)null, concept, concepts);
    }

    public IEntity create(IReference ... concepts) {
        return this.createNamed(null, concepts);
    }

    public IEntity createBean(IReference resource, Collection<URI> entityTypes, Collection<Class<?>> concepts, boolean restrictTypes, boolean initialize, IGraph graph) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource argument must not be null.");
        }
        Collection<Object> collection = entityTypes = entityTypes != null ? new HashSet<URI>(entityTypes) : new HashSet();
        if (!restrictTypes) {
            boolean retrieveTypes = true;
            if (graph != null) {
                for (IReference type : graph.filter(resource, (IReference)RDF.PROPERTY_TYPE, null, new IReference[0]).objects()) {
                    URI typeUri = type.getURI();
                    if (typeUri == null) continue;
                    entityTypes.add(typeUri);
                    retrieveTypes = false;
                }
            }
            if (retrieveTypes) {
                entityTypes.addAll(this.getTypeManager().getTypes(resource));
            }
        }
        if (concepts != null && !concepts.isEmpty()) {
            for (Class<?> concept : concepts) {
                IReference type;
                if (IValue.class == concept || IReference.class == concept || IEntity.class == concept || Object.class == concept) continue;
                type = (URI)this.mapper.findType(concept);
                if (type != null) {
                    entityTypes.add((URI)type);
                    continue;
                }
                log.warn("Unknown rdf type for concept class: " + concept);
            }
        }
        IEntity bean = this.createBeanForClass(resource, this.classResolver.resolveComposite(entityTypes));
        if (initialize) {
            if (bean instanceof Initializable) {
                ((Initializable)bean).init(graph);
            }
            if (graph != null) {
                this.initializeBean(bean, graph);
            }
        }
        return bean;
    }

    protected IEntity createBeanForClass(IReference resource, Class<?> type) {
        try {
            Object obj = type.newInstance();
            this.injector.injectMembers(obj);
            assert (obj instanceof IEntityManagerAware) : "core roles are not registered, check your deployed classpath";
            IEntityManagerAware bean = (IEntityManagerAware)obj;
            bean.initReference(this.getReference(resource));
            return (IEntity)bean;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    public ILiteral createLiteral(Object value, URI datatype) {
        return this.literalConverter.createLiteral(value, datatype);
    }

    public ILiteral createLiteral(String label, URI datatype, String language) {
        if (language != null) {
            return new Literal(label, language);
        }
        return this.createLiteral(label, datatype);
    }

    public <T> T createNamed(URI uri, Class<T> concept, Class<?> ... concepts) {
        IReference resource = this.getResourceManager().createResource(uri);
        HashSet<URI> types = new HashSet<URI>();
        boolean isActive = false;
        try {
            isActive = this.getTransaction().isActive();
            if (!isActive) {
                this.getTransaction().begin();
            }
            this.addConcept(resource, concept, types);
            for (Class<?> c : concepts) {
                this.addConcept(resource, c, types);
            }
            if (!isActive) {
                this.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (!isActive && this.getTransaction().isActive()) {
                this.getTransaction().rollback();
            }
            if (e instanceof KommaException) {
                throw (KommaException)((Object)e);
            }
            throw new KommaException((Throwable)e);
        }
        Class<?>[] allConcepts = this.combine(concept, concepts);
        IEntity bean = this.createBean(resource, types, Arrays.asList(allConcepts), true, false, null);
        assert (this.assertConceptsRecorded(bean, allConcepts));
        return (T)bean;
    }

    public IEntity createNamed(URI uri, IReference ... concepts) {
        IReference resource = this.getResourceManager().createResource(uri);
        try {
            boolean active = this.dm.getTransaction().isActive();
            if (!active) {
                this.dm.getTransaction().begin();
            }
            for (IReference concept : concepts) {
                this.dm.add((Iterable)new Statement(resource, (IReference)RDF.PROPERTY_TYPE, (Object)concept), (IReference[])this.modifyContexts);
            }
            if (!active) {
                this.dm.getTransaction().commit();
            }
        }
        catch (KommaException e) {
            if (this.dm.getTransaction().isActive()) {
                this.dm.getTransaction().rollback();
            }
            throw new KommaException((Throwable)e);
        }
        ArrayList<URI> types = null;
        if (concepts.length > 0) {
            types = new ArrayList<URI>();
            for (IReference concept : concepts) {
                if (concept.getURI() == null) continue;
                types.add(concept.getURI());
            }
        }
        return this.createBean(resource, types, null, true, false, null);
    }

    public IQuery<?> createQuery(String query) {
        return this.createQuery(query, null, true);
    }

    public IQuery<?> createQuery(String query, String baseURI) {
        return this.createQuery(query, baseURI, true);
    }

    public IQuery<?> createQuery(String query, boolean includeInferred) {
        return this.createQuery(query, null, includeInferred);
    }

    public IQuery<?> createQuery(String query, String baseURI, boolean includeInferred) {
        log.debug("Query: {}", (Object)query);
        Query result = new Query(this, this.dm.createQuery(query, baseURI, includeInferred, (IReference[])this.readContexts));
        this.injector.injectMembers(result);
        if (this.properties != null) {
            for (String propertyName : result.getSupportedProperties()) {
                Object value = this.properties.get(propertyName);
                if (value == null) continue;
                result.setProperty(propertyName, value);
            }
        }
        return result;
    }

    public IReference createReference() {
        return this.dm.blankNode();
    }

    public IReference createReference(String id) {
        return this.dm.blankNode(id);
    }

    public IUpdate createUpdate(String update, String baseURI, boolean includeInferred) {
        log.debug("Update: {}", (Object)update);
        IDataManagerUpdate dmUpdate = this.dm.createUpdate(update, baseURI, includeInferred, (IReference[])this.readContexts, (IReference[])this.modifyContexts);
        this.injector.injectMembers((Object)dmUpdate);
        Update result = new Update(this, dmUpdate);
        this.injector.injectMembers((Object)result);
        return result;
    }

    public <T> T assignTypes(Object entity, Class<T> concept, Class<?> ... concepts) {
        ArrayList<URI> types;
        IReference resource;
        block6: {
            resource = this.getReference(entity);
            types = new ArrayList<URI>();
            boolean isActive = false;
            try {
                this.getTypes(entity.getClass(), types);
                isActive = this.getTransaction().isActive();
                if (!isActive) {
                    this.getTransaction().begin();
                }
                this.addConcept(resource, concept, types);
                for (Class<?> c : concepts) {
                    this.addConcept(resource, c, types);
                }
                if (!isActive) {
                    this.getTransaction().commit();
                }
            }
            catch (Exception e) {
                if (isActive || !this.getTransaction().isActive()) break block6;
                this.getTransaction().rollback();
            }
        }
        Class<?>[] allConcepts = this.combine(concept, concepts);
        IEntity bean = this.createBean(resource, types, null, false, true, null);
        assert (this.assertConceptsRecorded(bean, allConcepts));
        return (T)bean;
    }

    protected <T> IExtendedIterator<T> filterResultNode(Set<T> values) {
        return WrappedIterator.create(values.iterator()).filterDrop(new Filter<T>(){

            public boolean accept(T o) {
                return RESULT_NODE.equals(o);
            }
        });
    }

    public IEntity find(IReference reference) {
        return this.createBean(reference, null, null, false, true, null);
    }

    public <T> T find(IReference reference, Class<T> concept, Class<?> ... concepts) {
        Class<?>[] allConcepts = Arrays.copyOf(concepts, concepts.length + 1);
        allConcepts[allConcepts.length - 1] = concept;
        return (T)this.find(reference, Arrays.asList(allConcepts));
    }

    public IEntity find(IReference reference, Collection<Class<?>> concepts) {
        return this.createBean(reference, null, concepts, false, true, null);
    }

    public <T> IExtendedIterator<T> findAll(Class<T> concept) {
        StringBuilder querySb = new StringBuilder();
        querySb.append("SELECT DISTINCT ?subj WHERE {");
        this.appendFilter(concept, querySb);
        querySb.append("}");
        return this.createQuery(querySb.toString()).bindResultType(concept, new Class[0]).evaluate();
    }

    public <T> T findRestricted(IReference reference, Class<T> concept, Class<?> ... concepts) {
        return (T)this.findRestricted(reference, Arrays.asList(this.combine(concept, concepts)));
    }

    @Override
    public IReference findRestricted(IReference reference, Collection<Class<?>> concepts) {
        Class<?> concept;
        if (concepts.size() == 1 && (IValue.class.equals(concept = concepts.iterator().next()) || IReference.class.equals(concept))) {
            return reference;
        }
        return this.createBean(reference, null, concepts, true, true, null);
    }

    public IEntityManagerFactory getFactory() {
        return this.factory;
    }

    public InferencingCapability getInferencing() {
        return this.dm.getInferencing();
    }

    protected List<Object> getInstances(Iterator<?> values, Class<?> type, IGraph graph) {
        ArrayList<Object> instances = new ArrayList<Object>();
        while (values.hasNext()) {
            instances.add(this.toInstance(values.next(), type, graph));
        }
        return instances;
    }

    public Locale getLocale() {
        return (Locale)this.locale.get();
    }

    public LockModeType getLockMode(Object entity) {
        return null;
    }

    public URI getNamespace(String prefix) {
        if (this.prefixToUri.isEmpty()) {
            this.cacheNamespaces();
        }
        return this.prefixToUri.get(prefix);
    }

    public IExtendedIterator<INamespace> getNamespaces() {
        return this.dm.getNamespaces();
    }

    public String getPrefix(URI namespaceUri) {
        if (this.uriToPrefix.isEmpty()) {
            this.cacheNamespaces();
        }
        return this.uriToPrefix.get(namespaceUri);
    }

    protected void clearNamespaceCache() {
        this.uriToPrefix.clear();
        this.prefixToUri.clear();
    }

    protected void cacheNamespaces() {
        for (INamespace ns : this.getNamespaces()) {
            this.uriToPrefix.put(ns.getURI(), ns.getPrefix());
            this.prefixToUri.put(ns.getPrefix(), ns.getURI());
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
    }

    protected IReference getReference(Object bean) {
        if (bean instanceof IReferenceable) {
            return ((IReferenceable)bean).getReference();
        }
        if (bean instanceof IReference) {
            return (IReference)bean;
        }
        return null;
    }

    private IReference getReferenceOrFail(Object entity) {
        IReference reference = this.getReference(entity);
        if (reference == null) {
            throw new KommaException("Unknown Entity: " + entity);
        }
        return reference;
    }

    public ITransaction getTransaction() {
        return this.dm.getTransaction();
    }

    private <C extends Collection<URI>> C getTypes(Class<?> role, C set) {
        URI type = (URI)this.mapper.findType(role);
        if (type == null) {
            Class<?> superclass = role.getSuperclass();
            if (superclass != null) {
                this.getTypes(superclass, set);
            }
            Class<?>[] interfaces = role.getInterfaces();
            int n = interfaces.length;
            for (int i = 0; i < n; ++i) {
                this.getTypes(interfaces[i], set);
            }
        } else {
            set.add((URI)type);
        }
        return set;
    }

    public boolean hasMatch(IReference subject, IReference predicate, Object object) {
        return this.dm.hasMatch(subject, predicate, this.toValue(object), true, (IReference[])this.readContexts);
    }

    protected void initializeBean(IEntity bean, IGraph graph) {
        if (!graph.contains((IReference)bean, null, null, new IReference[0])) {
            return;
        }
        try {
            if (bean instanceof PropertySetOwner) {
                for (IReference predicate : new ArrayList(graph.filter((IReference)bean, null, null, new IReference[0]).predicates())) {
                    PropertySet propertySet;
                    if (!graph.contains((IReference)bean, predicate, null, new IReference[0]) || (propertySet = ((PropertySetOwner)bean).getPropertySet(predicate.toString())) == null) continue;
                    LinkedHashSet objects = new LinkedHashSet(graph.filter((IReference)bean, predicate, null, new IReference[0]).objects());
                    graph.remove((IReference)bean, predicate, null, new IReference[0]);
                    propertySet.init(this.getInstances((Iterator<?>)this.filterResultNode(objects), propertySet.getElementType(), graph));
                }
            }
            for (Method method : bean.getClass().getMethods()) {
                URI keyUri;
                Cacheable cacheable;
                if (method.getParameterTypes().length > 0 || !method.isAnnotationPresent(Cacheable.class) || (cacheable = method.getAnnotation(Cacheable.class)).key().isEmpty()) continue;
                Class<?> returnType = method.getReturnType();
                boolean isIterator = false;
                boolean isBoolean = false;
                AbstractCollection collection = null;
                if (Iterator.class.isAssignableFrom(returnType)) {
                    isIterator = true;
                    collection = new ArrayList();
                } else if (Set.class.isAssignableFrom(returnType)) {
                    collection = new HashSet();
                } else if (List.class.isAssignableFrom(returnType)) {
                    collection = new ArrayList();
                } else if (Collection.class.isAssignableFrom(returnType)) {
                    collection = new ArrayList();
                } else if (Boolean.class.equals(returnType) || Boolean.TYPE.equals(returnType)) {
                    isBoolean = true;
                }
                if (collection == null && !isBoolean || !graph.contains((IReference)bean, (IReference)(keyUri = URIs.createURI((String)cacheable.key())), null, new IReference[0])) continue;
                LinkedHashSet objects = new LinkedHashSet(graph.filter((IReference)bean, (IReference)keyUri, null, new IReference[0]).objects());
                graph.remove((IReference)bean, (IReference)keyUri, null, new IReference[0]);
                IExtendedIterator valuesIt = this.filterResultNode(objects);
                Object value = null;
                if (collection != null) {
                    ParameterizedType pt;
                    Type[] args;
                    Type t = method.getGenericReturnType();
                    Class valueType = null;
                    if (t instanceof ParameterizedType && (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length == 1 && args[0] instanceof Class) {
                        valueType = (Class)args[0];
                    }
                    collection.addAll(this.getInstances((Iterator<?>)valuesIt, valueType, graph));
                    value = isIterator ? collection.iterator() : collection;
                } else if (isBoolean) {
                    value = valuesIt.hasNext();
                }
                this.initializeCache(bean, cacheable.key(), value);
            }
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    protected void initializeCache(IEntity entity, Object property, Object value) {
    }

    private boolean isEntity(Class<?> type) {
        if (type == null) {
            return false;
        }
        for (Class<?> face : type.getInterfaces()) {
            if (this.mapper.findType(face) == null) continue;
            return true;
        }
        if (this.mapper.findType(type) != null) {
            return true;
        }
        return this.isEntity(type.getSuperclass());
    }

    public boolean isOpen() {
        return this.dm != null && this.dm.isOpen();
    }

    public void joinTransaction() {
        if (!this.isOpen()) {
            throw new TransactionRequiredException();
        }
    }

    public void lock(Object entity, LockModeType mode) {
        throw new UnsupportedOperationException("locking is not supported");
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.lock(entity, lockMode);
    }

    public IExtendedIterator<IStatement> match(IReference subject, IReference predicate, Object object) {
        return this.dm.match(subject, predicate, this.toValue(object), true, (IReference[])this.readContexts);
    }

    public IExtendedIterator<IStatement> matchAsserted(IReference subject, IReference predicate, IValue object) {
        return this.dm.match(subject, predicate, this.toValue(object), false, (IReference[])this.readContexts);
    }

    public boolean hasMatchAsserted(IReference subject, IReference predicate, Object object) {
        return this.dm.hasMatch(subject, predicate, this.toValue(object), false, (IReference[])this.readContexts);
    }

    public <T> T merge(T bean) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof Set) {
            Set old = (Set)bean;
            HashSet set = new HashSet(old.size());
            for (Object o : old) {
                set.add(this.merge(o));
            }
            return (T)set;
        }
        IReference resource = this.assignReference(bean);
        boolean isActive = this.getTransaction().isActive();
        if (!isActive) {
            this.getTransaction().begin();
        }
        try {
            IEntity result;
            Class<?> proxy = bean.getClass();
            Set<URI> types = new HashSet();
            if (bean instanceof IResource) {
                for (IReference iEntity : ((IResource)bean).getRdfTypes()) {
                    if (iEntity.getURI() == null) continue;
                    types.add(iEntity.getURI());
                }
            } else {
                types = this.getTypes(proxy, types);
                for (URI uRI : types) {
                    this.getTypeManager().addType(resource, uRI);
                }
            }
            if ((result = this.createBean(resource, types, null, false, true, null)) instanceof Mergeable) {
                ((Mergeable)result).merge(bean);
            }
            if (!isActive) {
                this.getTransaction().commit();
            }
            IEntity iEntity = result;
            return (T)iEntity;
        }
        catch (Throwable t) {
            throw new KommaException(t);
        }
        finally {
            if (!isActive && this.getTransaction().isActive()) {
                this.getTransaction().rollback();
            }
        }
    }

    public void refresh(Object entity) {
        if (entity instanceof Refreshable) {
            ((Refreshable)entity).refresh();
        }
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.refresh(entity);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity);
    }

    public void remove(Iterable<? extends IStatementPattern> statements) {
        this.dm.remove((Iterable)new ConvertingIterator<IStatementPattern, IStatementPattern>(statements.iterator()){

            protected IStatementPattern convert(IStatementPattern stmt) {
                if (!(stmt.getSubject() instanceof Behaviour) && !(stmt.getPredicate() instanceof Behaviour) && stmt.getObject() instanceof IValue) {
                    return stmt;
                }
                IReference s = AbstractEntityManager.this.getReference(stmt.getSubject());
                IReference p = AbstractEntityManager.this.getReference(stmt.getPredicate());
                IValue o = AbstractEntityManager.this.toValue(stmt.getObject());
                return stmt instanceof IStatement ? new Statement(s, p, (Object)o, stmt.getContext(), ((IStatement)stmt).isInferred()) : new StatementPattern(s, p, (Object)o, stmt.getContext());
            }
        }, (IReference[])this.modifyContexts);
    }

    public void remove(Object entity) {
        if (entity instanceof IStatementPattern) {
            this.remove(Collections.singleton((IStatementPattern)entity));
        } else {
            IReference resource = this.getReferenceOrFail(entity);
            this.getResourceManager().removeResource(resource);
        }
    }

    private boolean canDelete(IReference deletedSubject, Object object, boolean anonymousOnly) {
        if (!(object instanceof IReference) || ((IReference)object).getURI() != null && anonymousOnly) {
            return false;
        }
        IExtendedIterator<IStatement> refs = this.matchAsserted(null, null, (IValue)((IReference)object));
        boolean canDelete = true;
        for (IStatement refStmt : refs) {
            if (refStmt.getSubject().equals(deletedSubject)) continue;
            canDelete = false;
            break;
        }
        refs.close();
        return canDelete;
    }

    public void removeRecursive(Object entity, boolean anonymousOnly) {
        IReference resource = null;
        if (entity instanceof IStatement) {
            IStatement stmt = (IStatement)entity;
            this.remove(Collections.singleton(stmt));
            resource = this.getReference(stmt.getObject());
        } else {
            resource = this.getReferenceOrFail(entity);
        }
        if (resource != null) {
            HashSet<IReference> seen = new HashSet<IReference>();
            LinkedList<IReference> nodes = new LinkedList<IReference>();
            nodes.add(resource);
            while (!nodes.isEmpty()) {
                IReference node = (IReference)nodes.remove();
                if (!seen.add(node)) continue;
                for (IStatement stmt : this.matchAsserted(node, null, null)) {
                    Object o = stmt.getObject();
                    if (!this.canDelete(node, o, anonymousOnly)) continue;
                    nodes.add((IReference)o);
                }
                this.remove(node);
            }
        }
    }

    public void removeTypes(Object entity, Class<?> ... concepts) {
        block5: {
            IReference resource = this.getReferenceOrFail(entity);
            boolean isActive = false;
            try {
                isActive = this.getTransaction().isActive();
                if (!isActive) {
                    this.getTransaction().begin();
                }
                for (Class<?> c : concepts) {
                    URI type = (URI)this.mapper.findType(c);
                    if (type == null) continue;
                    this.getTypeManager().removeType(resource, type);
                }
                if (!isActive) {
                    this.getTransaction().commit();
                }
            }
            catch (KommaException e) {
                if (isActive || !this.getTransaction().isActive()) break block5;
                this.getTransaction().rollback();
            }
        }
    }

    public void removeNamespace(String prefix) {
        this.dm.removeNamespace(prefix);
        this.clearNamespaceCache();
    }

    public <T> T rename(T bean, URI uri) {
        T renamed;
        IReference before = this.getReferenceOrFail(bean);
        IReference after = this.getResourceManager().createResource(uri);
        this.getResourceManager().renameResource(before, after);
        IEntity newBean = this.createBean(after, null, null, false, true, null);
        Object object = renamed = bean instanceof Behaviour ? ((Behaviour)bean).getBehaviourDelegate() : bean;
        if (renamed instanceof IEntityManagerAware) {
            ((IEntityManagerAware)renamed).initReference(((IReferenceable)newBean).getReference());
        }
        return (T)newBean;
    }

    @Inject
    protected void setClassResolver(ClassResolver<URI> classResolver) {
        this.classResolver = classResolver;
    }

    @Inject
    protected void setDataManager(IDataManager dm) {
        this.dm = dm;
    }

    protected ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager(this.dm, (IReference[])this.modifyContexts);
        }
        return this.resourceManager;
    }

    protected TypeManager getTypeManager() {
        if (this.typeManager == null) {
            this.typeManager = new TypeManager(this.dm, (IReference[])this.readContexts, (IReference[])this.modifyContexts);
        }
        return this.typeManager;
    }

    @Inject(optional=true)
    protected void setContexts(@Named(value="modifyContexts") Set<URI> modifyContexts, @Named(value="readContexts") Set<URI> readContexts) {
        this.modifyContexts = modifyContexts.toArray(new URI[modifyContexts.size()]);
        LinkedHashSet<URI> readAndModifyContexts = new LinkedHashSet<URI>(readContexts);
        readAndModifyContexts.retainAll(modifyContexts);
        readAndModifyContexts.addAll(readContexts);
        this.readContexts = readAndModifyContexts.toArray(new URI[readAndModifyContexts.size()]);
    }

    @Inject(optional=true)
    protected void setCurrentFactory(@Named(value="currentFactory") IEntityManagerFactory factory) {
        this.factory = factory;
    }

    public void setNamespace(String prefix, URI uri) {
        this.dm.setNamespace(prefix, uri);
        this.clearNamespaceCache();
    }

    protected Map<String, Object> ensureProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public void setProperty(String propertyName, Object value) {
        this.ensureProperties().put(propertyName, value);
    }

    @Inject(optional=true)
    protected void setProperties(@Named(value="net.enilink.komma.properties") Map<String, Object> properties) {
        this.ensureProperties().putAll(properties);
    }

    @Inject
    protected void setRoleMapper(RoleMapper<URI> mapper) {
        this.mapper = mapper;
    }

    public boolean supportsRole(Class<?> role) {
        return this.mapper.findType(role) != null;
    }

    public Collection<Class<?>> rolesForType(URI type) {
        return this.mapper.findRoles((Object)type, new HashSet());
    }

    public Object toInstance(IValue value) {
        return this.toInstance(value, null, null);
    }

    public Object toInstance(Object value, Class<?> type, IGraph graph) {
        Object instance;
        if (value instanceof IReference) {
            URI typeUri;
            Set<URI> types = null;
            if (type != null && (typeUri = (URI)this.mapper.findType(type)) != null) {
                types = Collections.singleton(typeUri);
            }
            IEntity bean = this.createBean((IReference)value, types, null, false, true, graph);
            if (log.isTraceEnabled() && !((IQuery)this.createQuery("ASK {?s ?p ?o}").setParameter("s", (Object)((IReference)value))).getBooleanResult()) {
                log.trace("Warning: Unknown entity: " + value);
            }
            return bean;
        }
        ILiteral literal = (ILiteral)value;
        if (type != null && IValue.class.isAssignableFrom(type)) {
            instance = this.createLiteral(literal.getLabel(), literal.getDatatype(), literal.getLanguage());
        } else {
            instance = this.literalConverter.createObject(literal);
            if (type != null) {
                if (instance == null) {
                    if (type.isPrimitive()) {
                        instance = ConversionUtil.convertValue(type, (Object)0, null);
                    }
                } else if (!type.isAssignableFrom(ConversionUtil.wrapperType(instance.getClass()))) {
                    instance = ConversionUtil.convertValue(type, (Object)instance, (Object)instance);
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue toValue(Object instance) {
        if (instance == null) {
            return null;
        }
        IReference reference = this.getReference(instance);
        if (reference != null) {
            return reference;
        }
        if (instance instanceof IValue) {
            return (IValue)instance;
        }
        Class<?> type = instance.getClass();
        if (this.literalConverter.isDatatype(type)) {
            return this.literalConverter.createLiteral(instance, null);
        }
        Map<Object, IReference> map = this.merged;
        synchronized (map) {
            if (this.merged.containsKey(instance)) {
                return (IValue)this.merged.get(instance);
            }
        }
        if (IEntity.class.isAssignableFrom(type) || this.isEntity(type)) {
            return this.toValue(this.merge(instance));
        }
        return this.literalConverter.createLiteral((Object)String.valueOf(instance), XMLSCHEMA.TYPE_STRING);
    }
}

