/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal;

import com.google.common.cache.Cache;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.enilink.composition.cache.IPropertyCache;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityDecorator;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.internal.CachedEntity;
import net.enilink.komma.em.internal.DecoratingEntityManager;
import net.enilink.komma.em.internal.Fqn;

public class CachingEntityManager
extends DecoratingEntityManager {
    @Inject
    Fqn contextKey;
    @Inject
    Cache<Object, CachedEntity> cache;
    @Inject
    IPropertyCache propertyCache;

    @Inject
    public CachingEntityManager(Set<IEntityDecorator> decorators) {
        super(decorators);
    }

    @Override
    public IEntity createBean(IReference resource, Collection<URI> types, Collection<Class<?>> concepts, boolean restrictTypes, boolean initialize, IGraph graph) {
        Object element;
        CachedEntity cached = (CachedEntity)this.cache.getIfPresent((Object)resource);
        Object object = element = cached != null ? cached.getSelf(this.contextKey) : null;
        if (element != null) {
            boolean hasValidTypes = true;
            if (concepts != null && !concepts.isEmpty()) {
                for (Class<?> concept : concepts) {
                    if (concept.isAssignableFrom(element.getClass())) continue;
                    hasValidTypes = false;
                    break;
                }
            }
            if (hasValidTypes) {
                if (graph != null) {
                    this.initializeBean((IEntity)element, graph);
                }
                return (IEntity)element;
            }
        }
        IEntity entity = super.createBean(resource, types, concepts, restrictTypes, initialize, graph);
        if (!restrictTypes && !this.getTransaction().isActive()) {
            try {
                CachedEntity cachedEntity = (CachedEntity)this.cache.get((Object)resource, CachedEntity.FACTORY);
                cachedEntity.setSelf(this.contextKey, entity);
            }
            catch (ExecutionException e) {
                log.error("Exception while caching entity.", (Throwable)e);
            }
        }
        return entity;
    }

    @Override
    protected void initializeCache(IEntity entity, Object property, Object value) {
        log.trace("init cache for {}/{}: {}", new Object[]{entity, property, value});
        this.propertyCache.put((Object)entity, property, new Object[0], value);
    }

    @Override
    public void refresh(Object entity) {
        super.refresh(entity);
        CachedEntity cachedEntity = (CachedEntity)this.cache.getIfPresent(entity);
        if (cachedEntity != null) {
            cachedEntity.clearProperties();
        }
    }
}

