/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityDecorator;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IReferenceable;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.internal.DecoratingEntityManager;

public class EagerCachingEntityManager
extends DecoratingEntityManager {
    @Inject
    private Map<IReference, Object> entityCache;

    @Inject
    public EagerCachingEntityManager(Set<IEntityDecorator> decorators) {
        super(decorators);
    }

    @Override
    protected IEntity createBeanForClass(IReference resource, Class<?> type) {
        Object bean = this.entityCache.get(resource);
        if (bean == null || !bean.getClass().equals(type)) {
            Object oldBean = bean;
            bean = super.createBeanForClass(resource, type);
            this.entityCache.put(resource, bean);
        }
        return (IEntity)bean;
    }

    @Override
    public <T> T rename(T bean, URI uri) {
        this.entityCache.remove(((IReferenceable)bean).getReference());
        T newBean = super.rename(bean, uri);
        this.entityCache.put(((IReferenceable)newBean).getReference(), bean);
        return newBean;
    }
}

