/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal;

import java.util.Arrays;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.dm.IDataManager;

public class ResourceManager {
    IDataManager dm;
    IReference[] contexts;

    public ResourceManager(IDataManager dm, IReference[] contexts) {
        this.dm = dm;
        this.contexts = contexts;
    }

    public IReference createResource(URI uri) {
        if (uri == null) {
            return this.dm.blankNode();
        }
        return uri;
    }

    public void removeResource(IReference resource) {
        boolean active = this.dm.getTransaction().isActive();
        try {
            if (!active) {
                this.dm.getTransaction().begin();
            }
            this.dm.remove(Arrays.asList(new Statement(resource, null, null), new Statement(null, null, (Object)resource)), this.contexts);
            if (!active) {
                this.dm.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (!active && this.dm.getTransaction().isActive()) {
                this.dm.getTransaction().rollback();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameResource(IReference before, IReference after) {
        boolean active = this.dm.getTransaction().isActive();
        try {
            IReference subj;
            Object obj;
            IStatement stmt;
            if (!active) {
                this.dm.getTransaction().begin();
            }
            try (IExtendedIterator stmts = this.dm.match(before, null, null, false, this.contexts);){
                while (stmts.hasNext()) {
                    stmt = (IStatement)stmts.next();
                    IReference pred = stmt.getPredicate();
                    obj = stmt.getObject();
                    this.dm.remove((Iterable)new Statement(before, pred, obj), this.contexts);
                    this.dm.add((Iterable)new Statement(after, pred, obj), this.contexts);
                }
            }
            stmts = this.dm.match(null, before, null, false, this.contexts);
            try {
                while (stmts.hasNext()) {
                    stmt = (IStatement)stmts.next();
                    subj = stmt.getSubject();
                    obj = stmt.getObject();
                    this.dm.remove((Iterable)new Statement(subj, before, obj), this.contexts);
                    this.dm.add((Iterable)new Statement(subj, after, obj), this.contexts);
                }
            }
            finally {
                stmts.close();
            }
            stmts = this.dm.match(null, null, (IValue)before, false, this.contexts);
            try {
                while (stmts.hasNext()) {
                    stmt = (IStatement)stmts.next();
                    subj = stmt.getSubject();
                    IReference pred = stmt.getPredicate();
                    this.dm.remove((Iterable)new Statement(subj, pred, (Object)before), this.contexts);
                    this.dm.add((Iterable)new Statement(subj, pred, (Object)after), this.contexts);
                }
            }
            finally {
                stmts.close();
            }
            if (!active) {
                this.dm.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (!active && this.dm.getTransaction().isActive()) {
                this.dm.getTransaction().rollback();
            }
            throw new KommaException((Throwable)e);
        }
    }
}

