/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.behaviours;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.util.IPartialOrderProvider;
import net.enilink.commons.util.LinearExtension;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.annotations.Precedes;
import net.enilink.composition.properties.traits.Mergeable;
import net.enilink.composition.properties.traits.Refreshable;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.Initializable;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.concepts.ResourceSupport;
import net.enilink.vocab.rdf.RDF;

@Iri(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#List")
@Precedes(value={ResourceSupport.class})
public abstract class RDFList
extends AbstractSequentialList<Object>
implements List<Object>,
Refreshable,
Mergeable,
Initializable,
IEntity,
Behaviour<IEntity> {
    private static final boolean INIT_CACHE_WITH_PROPERTY_PATH = !"false".equalsIgnoreCase(System.getProperty("net.enilink.usePropertyPaths"));
    private static final Item NIL_ITEM = new Item((IReference)RDF.NIL, null, null);
    private volatile int size = -1;
    private volatile List<Item> cache;

    void addStatement(IReference subj, URI pred, Object obj) {
        if (obj == null) {
            return;
        }
        this.getEntityManager().add((Iterable)new Statement(subj, (IReference)pred, obj));
    }

    private List<Item> getCache() {
        List<Object> localCache = this.cache;
        if (localCache == null && INIT_CACHE_WITH_PROPERTY_PATH) {
            final LinkedHashMap<Object, Item> items = new LinkedHashMap<Object, Item>();
            IExtendedIterator results = ((IQuery)((IQuery)((IQuery)((IQuery)this.getEntityManager().createQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT ?item ?first ?rest WHERE { { BIND (?self as ?item) } UNION { ?self rdf:rest+ ?item } . ?item rdf:first ?first . OPTIONAL { ?item rdf:rest ?rest } }").restrictResultType("first", new Class[]{IValue.class})).restrictResultType("item", new Class[]{IReference.class})).restrictResultType("rest", new Class[]{IReference.class})).setParameter("self", this.getBehaviourDelegate())).evaluate(Object[].class, new Class[0]);
            for (Object[] result : results) {
                IReference self = (IReference)result[0];
                items.put(self, new Item(self, (IValue)result[1], (IReference)result[2]));
            }
            if (!items.containsKey(RDF.NIL)) {
                items.put(RDF.NIL, NIL_ITEM);
            }
            localCache = items.size() <= 2 ? new ArrayList(items.values()) : new LinearExtension((IPartialOrderProvider)new IPartialOrderProvider<Item>(){

                public Collection<Item> getElements() {
                    return items.values();
                }

                public Collection<Item> getSuccessors(Item element) {
                    if (element.self.equals(RDF.NIL)) {
                        return Collections.emptyList();
                    }
                    if (element.rest != null) {
                        return Collections.singleton(items.get(element.rest));
                    }
                    return Collections.singleton(NIL_ITEM);
                }
            }).createLinearExtension();
        }
        this.cache = localCache;
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item getItem(IReference self) {
        if (self == null || RDF.NIL.equals((Object)self)) {
            return NIL_ITEM;
        }
        try (IExtendedIterator results = ((IQuery)((IQuery)((IQuery)this.getEntityManager().createQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT ?first ?rest WHERE { { ?item rdf:first ?first } OPTIONAL { ?item rdf:rest ?rest } }").restrictResultType("first", new Class[]{IValue.class})).restrictResultType("rest", new Class[]{IReference.class})).setParameter("item", (Object)self)).evaluate(Object[].class, new Class[0]);){
            if (results.hasNext()) {
                Object[] item = (Object[])results.next();
                Item item2 = new Item(self, (IValue)item[0], (IReference)item[1]);
                return item2;
            }
            Item item = new Item(self, null, null);
            return item;
        }
    }

    public void init(IGraph graph) {
        if (graph != null && this.cache == null) {
            IReference list = this.getReference();
            ArrayList<Item> items = new ArrayList<Item>();
            HashSet<IReference> seen = new HashSet<IReference>();
            while (list != null && seen.add(list) && !RDF.NIL.equals((Object)list)) {
                IReference rest = null;
                IValue first = null;
                for (IStatement stmt : graph.filter(list, null, null, new IReference[0])) {
                    if (RDF.PROPERTY_FIRST.equals((Object)stmt.getPredicate())) {
                        first = (IValue)stmt.getObject();
                        continue;
                    }
                    if (!RDF.PROPERTY_REST.equals((Object)stmt.getPredicate())) continue;
                    if (!(stmt.getObject() instanceof IReference)) break;
                    rest = (IReference)stmt.getObject();
                }
                if (first == null) continue;
                items.add(new Item(list, first, rest));
                list = rest;
            }
            items.add(NIL_ITEM);
            if (list == null || RDF.NIL.equals((Object)list)) {
                this.cache = items;
            }
        }
    }

    @Override
    public ListIterator<Object> listIterator(final int index) {
        final List<Item> cacheLocal = this.getCache();
        final boolean cached = cacheLocal != null;
        return new ListIterator<Object>(){
            Item next;
            Item item;
            private int nextIndex;
            private ArrayList<Item> items;
            {
                this.nextIndex = cached ? index : 0;
                ArrayList arrayList = this.items = cached ? new ArrayList(cacheLocal) : new ArrayList();
                if (cached) {
                    if (index - 1 >= 0) {
                        this.item = this.items.get(index - 1);
                    }
                } else {
                    for (int i = 0; i < index; ++i) {
                        this.next();
                    }
                }
            }

            @Override
            public void add(Object o) {
                boolean active = RDFList.this.getEntityManager().getTransaction().isActive();
                try {
                    if (!active) {
                        RDFList.this.getEntityManager().getTransaction().begin();
                    }
                    if (RDFList.this.getReference().equals(RDF.NIL)) {
                        throw new KommaException("cannot add a value to the nil list");
                    }
                    if (this.item == null) {
                        Item thisItem = RDFList.this.getItem((IReference)RDFList.this.getBehaviourDelegate());
                        if (thisItem.first == null) {
                            IValue oValue = RDFList.this.getEntityManager().toValue(o);
                            this.item = new Item((IReference)RDFList.this.getBehaviourDelegate(), oValue, (IReference)RDF.NIL);
                            RDFList.this.addStatement(this.item.self, RDF.PROPERTY_FIRST, oValue);
                            RDFList.this.addStatement(this.item.self, RDF.PROPERTY_REST, RDF.NIL);
                        } else {
                            IEntity newList = RDFList.this.getEntityManager().create(new IReference[0]);
                            RDFList.this.addStatement((IReference)newList, RDF.PROPERTY_FIRST, thisItem.first);
                            RDFList.this.addStatement((IReference)newList, RDF.PROPERTY_REST, thisItem.rest);
                            RDFList.this.removeStatements((IReference)RDFList.this.getBehaviourDelegate(), RDF.PROPERTY_FIRST, thisItem.first);
                            RDFList.this.removeStatements((IReference)RDFList.this.getBehaviourDelegate(), RDF.PROPERTY_REST, thisItem.rest);
                            RDFList.this.addStatement((IReference)RDFList.this.getBehaviourDelegate(), RDF.PROPERTY_FIRST, o);
                            RDFList.this.addStatement((IReference)RDFList.this.getBehaviourDelegate(), RDF.PROPERTY_REST, newList);
                        }
                    } else if (!this.item.self.equals(RDF.NIL)) {
                        IEntity newList = RDFList.this.getEntityManager().create(new IReference[0]);
                        RDFList.this.removeStatements(this.item.self, RDF.PROPERTY_REST, this.item.rest);
                        RDFList.this.addStatement(this.item.self, RDF.PROPERTY_REST, newList);
                        RDFList.this.addStatement((IReference)newList, RDF.PROPERTY_FIRST, o);
                        RDFList.this.addStatement((IReference)newList, RDF.PROPERTY_REST, this.item.rest);
                        this.item = new Item(this.item.self, RDFList.this.getEntityManager().toValue(o), (IReference)newList);
                    } else {
                        throw new NoSuchElementException();
                    }
                    if (!active) {
                        RDFList.this.getEntityManager().getTransaction().commit();
                    }
                    RDFList.this.refresh();
                }
                catch (KommaException e) {
                    if (!active) {
                        RDFList.this.getEntityManager().getTransaction().rollback();
                    }
                    throw e;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return this.next.first != null;
                }
                if (this.nextIndex < this.items.size()) {
                    this.next = this.items.get(this.nextIndex);
                } else if (!cached) {
                    this.next = this.item == null ? RDFList.this.getItem((IReference)RDFList.this.getBehaviourDelegate()) : RDFList.this.getItem(this.item.rest);
                    this.items.add(this.next);
                    if (this.next.first == null) {
                        RDFList.this.cache = new ArrayList<Item>(this.items);
                    }
                }
                return this.next != null && this.next.first != null;
            }

            @Override
            public boolean hasPrevious() {
                return this.nextIndex > 0;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    ++this.nextIndex;
                    this.item = this.next;
                    this.next = null;
                    return RDFList.this.getEntityManager().toInstance(this.item.first);
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.nextIndex;
            }

            @Override
            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                --this.nextIndex;
                this.item = this.items.get(this.nextIndex - 1);
                IValue first = this.item.first;
                if (first == null) {
                    throw new NoSuchElementException();
                }
                return RDFList.this.getEntityManager().toInstance(first);
            }

            @Override
            public int previousIndex() {
                return this.nextIndex - 2;
            }

            @Override
            public void remove() {
                if (this.item == null) {
                    throw new IllegalStateException("next() has not yet been called");
                }
                boolean active = RDFList.this.getEntityManager().getTransaction().isActive();
                try {
                    if (!active) {
                        RDFList.this.getEntityManager().getTransaction().begin();
                    }
                    if (this.nextIndex == 1) {
                        RDFList.this.removeStatements(this.item.self, RDF.PROPERTY_FIRST, this.item.first);
                        Item next = RDFList.this.getItem(this.item.rest);
                        if (next != null) {
                            RDFList.this.removeStatements(this.item.self, RDF.PROPERTY_REST, next.self);
                            if (next.first != null) {
                                RDFList.this.removeStatements(next.self, RDF.PROPERTY_FIRST, next.first);
                                RDFList.this.addStatement(this.item.self, RDF.PROPERTY_FIRST, next.first);
                            }
                            if (next.rest != null) {
                                RDFList.this.removeStatements(next.self, RDF.PROPERTY_REST, next.rest);
                                RDFList.this.addStatement(this.item.self, RDF.PROPERTY_REST, next.rest);
                            }
                        }
                        this.item = new Item(this.item.self, next != null ? next.first : null, next != null ? next.rest : null);
                    } else {
                        Item removedList = this.item;
                        Item prev = this.items.get(this.nextIndex - 2);
                        this.items.set(this.nextIndex - 2, new Item(prev.self, prev.first, prev.rest));
                        this.items.remove(this.nextIndex - 1);
                        RDFList.this.removeStatements(removedList.self, RDF.PROPERTY_FIRST, removedList.first);
                        RDFList.this.removeStatements(removedList.self, RDF.PROPERTY_REST, removedList.rest);
                        RDFList.this.removeStatements(prev.self, RDF.PROPERTY_REST, removedList.self);
                        RDFList.this.addStatement(prev.self, RDF.PROPERTY_REST, removedList.rest);
                        this.item = prev;
                    }
                    this.next = null;
                    this.hasNext();
                    this.item = null;
                    if (!active) {
                        RDFList.this.getEntityManager().getTransaction().commit();
                    }
                    RDFList.this.refresh();
                }
                catch (KommaException e) {
                    if (!active) {
                        RDFList.this.getEntityManager().getTransaction().rollback();
                    }
                    throw e;
                }
            }

            @Override
            public void set(Object o) {
                boolean active = RDFList.this.getEntityManager().getTransaction().isActive();
                try {
                    if (!active) {
                        RDFList.this.getEntityManager().getTransaction().begin();
                    }
                    if (((IEntity)RDFList.this.getBehaviourDelegate()).equals(RDF.NIL)) {
                        throw new NoSuchElementException();
                    }
                    if (this.item.self.equals(RDF.NIL)) {
                        throw new NoSuchElementException();
                    }
                    RDFList.this.removeStatements(this.item.self, RDF.PROPERTY_FIRST, this.item.first);
                    if (o != null) {
                        RDFList.this.addStatement(this.item.self, RDF.PROPERTY_FIRST, o);
                    }
                    if (!active) {
                        RDFList.this.getEntityManager().getTransaction().commit();
                    }
                    RDFList.this.refresh();
                }
                catch (KommaException e) {
                    if (!active) {
                        RDFList.this.getEntityManager().getTransaction().rollback();
                    }
                    throw e;
                }
            }
        };
    }

    public void merge(Object source) {
        if (source instanceof List) {
            this.clear();
            Iterator it = ((List)source).iterator();
            if (it.hasNext()) {
                IReference current = (IReference)this.getBehaviourDelegate();
                this.addStatement(current, RDF.PROPERTY_FIRST, it.next());
                while (it.hasNext()) {
                    IReference last = current;
                    current = this.getEntityManager().create(new IReference[0]);
                    this.addStatement(last, RDF.PROPERTY_REST, current);
                    this.addStatement(current, RDF.PROPERTY_FIRST, it.next());
                }
                this.addStatement(current, RDF.PROPERTY_REST, RDF.NIL);
            }
        }
    }

    public void refresh() {
        this.size = -1;
        this.cache = null;
    }

    void removeStatements(IReference subj, URI pred, Object obj) {
        this.getEntityManager().remove((Iterable)new Statement(subj, (IReference)pred, obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.size < 0) {
            RDFList rDFList = this;
            synchronized (rDFList) {
                if (this.size < 0) {
                    List<Item> items = this.getCache();
                    if (items != null) {
                        this.size = Math.max(0, items.size() - 1);
                    } else {
                        items = new ArrayList<Item>();
                        Item item = this.getItem((IReference)this.getBehaviourDelegate());
                        items.add(item);
                        int size = 0;
                        while (item != null && item.first != null && !item.self.equals(RDF.NIL)) {
                            item = this.getItem(item.rest);
                            items.add(item);
                            ++size;
                        }
                        this.cache = items;
                        this.size = size;
                    }
                }
            }
        }
        return this.size;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private static class Item {
        final IReference self;
        final IValue first;
        final IReference rest;

        Item(IReference self, IValue first, IReference rest) {
            this.self = self;
            this.first = first;
            this.rest = rest;
        }
    }
}

