/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.behaviours;

import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.annotations.Precedes;
import net.enilink.composition.properties.traits.Mergeable;
import net.enilink.composition.properties.traits.Refreshable;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.concepts.ResourceSupport;
import net.enilink.vocab.rdf.RDF;

@Iri(value="http://www.w3.org/2000/01/rdf-schema#Container")
@Precedes(value={ResourceSupport.class})
public abstract class RDFSContainer
extends AbstractList<Object>
implements List<Object>,
Refreshable,
Mergeable,
IEntity,
Behaviour<IEntity> {
    private static final int UNKNOWN = -1;
    private int _size = -1;

    @Override
    public void add(int index, Object obj) {
        boolean active = this.getEntityManager().getTransaction().isActive();
        try {
            if (!active) {
                this.getEntityManager().getTransaction().begin();
            }
            for (int i = this.size() - 1; i >= index; --i) {
                this.replace(i + 1, this.get(i));
            }
            this.replace(index, obj);
            if (this._size > -1) {
                ++this._size;
            }
            if (!active) {
                this.getEntityManager().getTransaction().commit();
            }
        }
        catch (KommaException e) {
            if (!active) {
                this.getEntityManager().getTransaction().rollback();
            }
            throw e;
        }
    }

    private void assign(int index, Object o) {
        URI pred = this.getMemberPredicate(index);
        this.getEntityManager().add((Iterable)new Statement((IReference)this.getBehaviourDelegate(), (IReference)pred, o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(int index) {
        URI pred = this.getMemberPredicate(index);
        try (IExtendedIterator<IValue> stmts = this.getStatements(pred);){
            if (stmts.hasNext()) {
                IValue next = (IValue)stmts.next();
                Object object = this.getEntityManager().toInstance(next);
                return object;
            }
            Object var4_5 = null;
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue getAndSet(int index, Object o) {
        URI pred = this.getMemberPredicate(index);
        try (IExtendedIterator<IValue> stmts = this.getStatements(pred);){
            IValue newValue = this.getEntityManager().toValue(o);
            IValue oldValue = null;
            while (stmts.hasNext()) {
                oldValue = (IValue)stmts.next();
                if (newValue != null && newValue.equals(oldValue)) continue;
                stmts.remove();
            }
            if (newValue != null && !newValue.equals(oldValue)) {
                this.getEntityManager().add((Iterable)new Statement((IReference)this.getBehaviourDelegate(), (IReference)pred, (Object)newValue));
            }
            IValue iValue = oldValue;
            return iValue;
        }
    }

    private URI getMemberPredicate(int index) {
        return RDF.NAMESPACE_URI.appendFragment("_" + (index + 1));
    }

    private int getSize() {
        try {
            HashSet<IReference> set = new HashSet<IReference>();
            try (IExtendedIterator result = this.getEntityManager().match((IReference)this.getBehaviourDelegate(), null, null);){
                while (result.hasNext()) {
                    set.add(((IStatement)result.next()).getPredicate());
                }
            }
            int index = 0;
            while (set.contains(this.getMemberPredicate(index))) {
                ++index;
            }
            return index;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    private IExtendedIterator<IValue> getStatements(URI pred) {
        return new ConvertingIterator<IStatement, IValue>((Iterator)this.getEntityManager().match((IReference)this.getBehaviourDelegate(), (IReference)pred, null)){
            IStatement currentStmt;

            protected IValue convert(IStatement stmt) {
                this.currentStmt = stmt;
                return (IValue)stmt.getObject();
            }

            public void remove() {
                if (this.currentStmt != null) {
                    RDFSContainer.this.getEntityManager().remove((Iterable)this.currentStmt);
                    this.currentStmt = null;
                }
            }
        };
    }

    public void merge(Object source) {
        if (source instanceof List) {
            boolean active = this.getEntityManager().getTransaction().isActive();
            try {
                if (!active) {
                    this.getEntityManager().getTransaction().begin();
                }
                List list = (List)source;
                int size = list.size();
                int n = size;
                for (int i = 0; i < n; ++i) {
                    this.assign(i, list.get(i));
                }
                if (this._size > -1 && this._size < size) {
                    this._size = size;
                }
                if (!active) {
                    this.getEntityManager().getTransaction().commit();
                }
            }
            catch (KommaException e) {
                if (!active) {
                    this.getEntityManager().getTransaction().rollback();
                }
                throw e;
            }
        }
    }

    public void refresh() {
        this._size = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(int index) {
        boolean active = this.getEntityManager().getTransaction().isActive();
        try {
            if (!active) {
                this.getEntityManager().getTransaction().begin();
            }
            Object obj = this.get(index);
            int size = this.size();
            for (int i = index; i < size - 1; ++i) {
                this.replace(i, this.get(i + 1));
            }
            URI pred = this.getMemberPredicate(size - 1);
            try (IExtendedIterator<IValue> stmts = this.getStatements(pred);){
                while (stmts.hasNext()) {
                    stmts.next();
                    stmts.remove();
                }
            }
            if (this._size > -1) {
                --this._size;
            }
            if (!active) {
                this.getEntityManager().getTransaction().commit();
            }
            return obj;
        }
        catch (KommaException e) {
            if (!active) {
                this.getEntityManager().getTransaction().rollback();
            }
            throw e;
        }
    }

    private void replace(int index, Object o) {
        URI pred = this.getMemberPredicate(index);
        boolean active = this.getEntityManager().getTransaction().isActive();
        try {
            if (!active) {
                this.getEntityManager().getTransaction().begin();
            }
            this.getEntityManager().remove((Iterable)new Statement((IReference)this.getBehaviourDelegate(), (IReference)pred, null));
            this.getEntityManager().add((Iterable)new Statement((IReference)this.getBehaviourDelegate(), (IReference)pred, o));
            if (!active) {
                this.getEntityManager().getTransaction().commit();
            }
        }
        catch (KommaException e) {
            if (!active) {
                this.getEntityManager().getTransaction().rollback();
            }
            throw e;
        }
    }

    @Override
    public Object set(int index, Object obj) {
        boolean active = this.getEntityManager().getTransaction().isActive();
        try {
            if (!active) {
                this.getEntityManager().getTransaction().begin();
            }
            IValue value = this.getAndSet(index, obj);
            Object old = this.getEntityManager().toInstance(value);
            if (!active) {
                this.getEntityManager().getTransaction().commit();
            }
            return old;
        }
        catch (KommaException e) {
            if (!active) {
                this.getEntityManager().getTransaction().rollback();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this._size < 0) {
            RDFSContainer rDFSContainer = this;
            synchronized (rDFSContainer) {
                if (this._size < 0) {
                    int index;
                    this._size = index = this.getSize();
                }
            }
        }
        return this._size;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

