/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.query;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.enilink.commons.iterator.NiceIterator;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.IGraphResult;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.ITupleResult;
import net.enilink.komma.core.LinkedHashGraph;
import net.enilink.komma.em.internal.IEntityManagerInternal;
import net.enilink.komma.em.internal.query.ResultInfo;
import net.enilink.komma.em.util.RESULTS;
import net.enilink.vocab.rdf.RDF;

public class ProjectedGraphIterator
extends NiceIterator<Object>
implements ITupleResult<Object> {
    private IEntityManagerInternal manager;
    private int maxResults;
    private int position;
    private Iterator<IReference> resourceIt;
    private IGraph resultGraph;
    private ResultInfo resultInfo;

    protected static IGraph asGraph(IGraphResult result) {
        LinkedHashGraph graph = new LinkedHashGraph();
        while (result.hasNext()) {
            graph.add(result.next());
        }
        result.close();
        return graph;
    }

    protected ProjectedGraphIterator(IEntityManagerInternal manager, IGraph resultGraph, int maxResults, ResultInfo resultInfo) {
        this.resourceIt = new LinkedHashSet(resultGraph.filter(null, (IReference)RDF.PROPERTY_TYPE, (Object)RESULTS.TYPE_RESULT, new IReference[0]).subjects()).iterator();
        resultGraph.remove(null, (IReference)RDF.PROPERTY_TYPE, (Object)RESULTS.TYPE_RESULT, new IReference[0]);
        this.resultGraph = resultGraph;
        this.manager = manager;
        this.maxResults = maxResults;
        this.resultInfo = resultInfo;
    }

    public ProjectedGraphIterator(IEntityManagerInternal manager, IGraphResult result, int maxResults, ResultInfo resultInfo) {
        this(manager, ProjectedGraphIterator.asGraph(result), maxResults, resultInfo);
    }

    protected Object convert(IReference resource) {
        return this.manager.toInstance(resource, this.resultInfo != null ? this.resultInfo.types.get(0) : null, this.resultGraph);
    }

    public List<String> getBindingNames() {
        return Arrays.asList("entity");
    }

    public boolean hasNext() {
        if (this.maxResults > 0 && this.position >= this.maxResults) {
            this.close();
            return false;
        }
        return this.resourceIt.hasNext();
    }

    public Object next() {
        try {
            ++this.position;
            Object object = this.convert(this.resourceIt.next());
            return object;
        }
        finally {
            if (this.maxResults > 0 && this.position >= this.maxResults) {
                this.close();
            }
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Removal of results is not permitted.");
    }
}

