/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.query;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.composition.mappers.RoleMapper;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IBooleanResult;
import net.enilink.komma.core.IGraphResult;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReferenceable;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.ITupleResult;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.LockModeType;
import net.enilink.komma.core.NoResultException;
import net.enilink.komma.core.NonUniqueResultException;
import net.enilink.komma.core.URI;
import net.enilink.komma.dm.IDataManagerQuery;
import net.enilink.komma.em.internal.IEntityManagerInternal;
import net.enilink.komma.em.internal.query.BooleanIterator;
import net.enilink.komma.em.internal.query.GraphIterator;
import net.enilink.komma.em.internal.query.ProjectedGraphIterator;
import net.enilink.komma.em.internal.query.ProjectedTupleIterator;
import net.enilink.komma.em.internal.query.QueryBase;
import net.enilink.komma.em.internal.query.ResultInfo;
import net.enilink.komma.em.internal.query.TupleArrayIterator;
import net.enilink.komma.em.internal.query.TupleBindingsIterator;

public class Query<R>
extends QueryBase<IQuery<R>>
implements IQuery<R> {
    protected IEntityManagerInternal manager;
    private WeakHashMap<IExtendedIterator<?>, Object> opened = new WeakHashMap(4);
    protected IDataManagerQuery<?> query;
    @Inject
    RoleMapper<URI> roleMapper;

    public Query(IEntityManagerInternal manager, IDataManagerQuery<?> query) {
        this.manager = manager;
        this.query = query;
    }

    public void close() {
        for (IExtendedIterator<?> c : this.opened.keySet()) {
            c.close();
        }
    }

    public IExtendedIterator<R> evaluate() {
        return this.evaluateQuery(null, this.resultInfos);
    }

    public <T> IExtendedIterator<T> evaluate(Class<T> resultType, Class<?> ... resultTypes) {
        Map<String, ResultInfo> resultInfos;
        if (IBindings.class.isAssignableFrom(resultType) || resultType.isArray()) {
            return this.evaluateQuery(resultType, this.resultInfos);
        }
        ResultInfo resultInfo = new ResultInfo(false, new ArrayList());
        resultInfo.types.add(resultType);
        for (Class<?> type : resultTypes) {
            resultInfo.types.add(type);
        }
        if (this.resultInfos == null) {
            resultInfos = Collections.singletonMap(null, resultInfo);
        } else {
            resultInfos = new HashMap<String, ResultInfo>(this.resultInfos);
            resultInfos.put(null, resultInfo);
        }
        return this.evaluateQuery(resultType, resultInfos);
    }

    private <T> IExtendedIterator<T> evaluateQuery(Class<T> resultType, Map<String, ResultInfo> resultInfos) {
        Object iter;
        int max;
        IExtendedIterator result = this.query.evaluate();
        int n = max = this.maxResults <= 0 ? 0 : this.maxResults + this.firstResult;
        if (result instanceof ITupleResult) {
            List names = ((ITupleResult)result).getBindingNames();
            if (resultType != null && IBindings.class.isAssignableFrom(resultType) || resultType == null && names.size() > 1) {
                iter = new TupleBindingsIterator(this.manager, (ITupleResult<IBindings<IValue>>)((ITupleResult)result), max, resultInfos);
            } else if (resultType != null && resultType.isArray()) {
                iter = new TupleArrayIterator(this.manager, (ITupleResult<IBindings<IValue>>)((ITupleResult)result), max, resultInfos);
            } else {
                ResultInfo info = null;
                if (resultInfos != null) {
                    if (names.size() == 1) {
                        info = resultInfos.get(names.get(0));
                    }
                    if (info == null) {
                        info = resultInfos.get(null);
                    }
                }
                iter = new ProjectedTupleIterator(this.manager, (ITupleResult<IBindings<IValue>>)((ITupleResult)result), max, info);
            }
        } else if (result instanceof IGraphResult) {
            ResultInfo resultInfo;
            if (resultType == null && resultInfos != null && (resultInfo = resultInfos.get(null)) != null && resultInfo.types.size() > 0) {
                resultType = resultInfo.types.get(0);
            }
            iter = resultType == null || IStatement.class.equals(resultType) ? new GraphIterator(this.manager, (IGraphResult)result, max, resultInfos == null || !resultInfos.get(null).typeRestricted) : new ProjectedGraphIterator(this.manager, (IGraphResult)result, max, resultInfos != null ? resultInfos.get(null) : null);
        } else {
            iter = new BooleanIterator(((IBooleanResult)result).asBoolean());
        }
        this.opened.put((IExtendedIterator<?>)iter, Boolean.TRUE);
        if (this.firstResult > 0) {
            for (int i = 0; i < this.firstResult && iter.hasNext(); ++i) {
                iter.next();
            }
        }
        return iter;
    }

    public <T> IExtendedIterator<T> evaluateRestricted(Class<T> resultType, Class<?> ... resultTypes) {
        ResultInfo resultInfo = new ResultInfo(true, new ArrayList());
        resultInfo.types.add(resultType);
        for (Class<?> type : resultTypes) {
            resultInfo.types.add(type);
        }
        return this.evaluateQuery(resultType, Collections.singletonMap(null, resultInfo));
    }

    public boolean getBooleanResult() {
        R result = this.getSingleResult();
        return Boolean.TRUE.equals(result);
    }

    public Map<String, Object> getProperties() {
        return this.query.getProperties();
    }

    public LockModeType getLockMode() {
        return LockModeType.NONE;
    }

    public List<R> getResultList() {
        return this.evaluate().toList();
    }

    public R getSingleResult() {
        return (R)this.getSingleResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getSingleResult(Class<T> resultType) {
        try (IExtendedIterator<T> iter = resultType != null ? this.evaluate(resultType, new Class[0]) : this.evaluateQuery(null, this.resultInfos);){
            if (!iter.hasNext()) {
                throw new NoResultException("No results");
            }
            Object result = iter.next();
            if (iter.hasNext()) {
                throw new NonUniqueResultException("More than one result");
            }
            Object object = result;
            return (T)object;
        }
    }

    public Set<String> getSupportedProperties() {
        return this.query.getSupportedProperties();
    }

    private void doSetParameter(String name, IValue value) {
        this.query.setParameter(name, value);
    }

    public IQuery<R> setProperty(String propertyName, Object value) {
        this.query.setProperty(propertyName, value);
        return this;
    }

    public IQuery<R> setLockMode(LockModeType lockMode) {
        return this;
    }

    public IQuery<R> setParameter(String name, Object value) {
        if (value == null) {
            this.doSetParameter(name, null);
        } else {
            if (value instanceof IReferenceable) {
                value = ((IReferenceable)value).getReference();
            }
            this.doSetParameter(name, value instanceof IValue ? (IValue)value : this.manager.toValue(value));
        }
        return this;
    }

    public IQuery<R> setTypeParameter(String name, Class<?> concept) {
        this.doSetParameter(name, (IValue)this.roleMapper.findType(concept));
        return this;
    }

    public String toString() {
        if (this.query == null) {
            return super.toString();
        }
        return this.query.toString();
    }

    public <T> IQuery<T> bindResultType(Class<T> resultType, Class<?> ... resultTypes) {
        return (IQuery)super.doBindResultType(resultType, resultTypes);
    }

    public <T> IQuery<T> restrictResultType(Class<T> resultType, Class<?> ... resultTypes) {
        return (IQuery)super.doRestrictResultType(resultType, resultTypes);
    }
}

