/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.enilink.komma.core.IQueryBase;
import net.enilink.komma.em.internal.query.ResultInfo;

public abstract class QueryBase<Q extends IQueryBase<Q>>
implements IQueryBase<Q> {
    protected int firstResult;
    protected int maxResults;
    protected Map<String, ResultInfo> resultInfos;

    protected <NQ extends IQueryBase<NQ>> NQ doBindResultType(Class<?> resultType, Class<?> ... resultTypes) {
        ResultInfo resultInfo = new ResultInfo(false, new ArrayList(1 + resultTypes.length));
        resultInfo.types.add(resultType);
        for (Class<?> type : resultTypes) {
            resultInfo.types.add(type);
        }
        this.ensureResultInfos().put(null, resultInfo);
        return (NQ)this;
    }

    public Q bindResultType(String name, Class<?> ... resultTypes) {
        this.ensureResultInfos();
        ResultInfo resultInfo = new ResultInfo(false, Arrays.asList(resultTypes));
        this.ensureResultInfos().put(name, resultInfo);
        return (Q)this;
    }

    protected Map<String, ResultInfo> ensureResultInfos() {
        if (this.resultInfos == null) {
            this.resultInfos = new HashMap<String, ResultInfo>();
        }
        return this.resultInfos;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    protected <NQ extends IQueryBase<NQ>> NQ doRestrictResultType(Class<?> resultType, Class<?> ... resultTypes) {
        ResultInfo resultInfo = new ResultInfo(true, new ArrayList(1 + resultTypes.length));
        resultInfo.types.add(resultType);
        for (Class<?> type : resultTypes) {
            resultInfo.types.add(type);
        }
        this.ensureResultInfos().put(null, resultInfo);
        return (NQ)this;
    }

    public Q restrictResultType(String name, Class<?> ... resultTypes) {
        ResultInfo resultInfo = new ResultInfo(true, Arrays.asList(resultTypes));
        this.ensureResultInfos().put(name, resultInfo);
        return (Q)this;
    }

    public Q setFirstResult(int startPosition) {
        this.firstResult = startPosition;
        return (Q)this;
    }

    public Q setMaxResults(int maxResult) {
        this.maxResults = maxResult;
        return (Q)this;
    }

    public void initializeFrom(QueryBase<?> other) {
        this.resultInfos = other.resultInfos;
        this.firstResult = other.firstResult;
        this.maxResults = other.maxResults;
    }
}

