/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.query;

import java.util.List;
import java.util.Map;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.ITupleResult;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.internal.IEntityManagerInternal;
import net.enilink.komma.em.internal.query.ResultInfo;

public class TupleArrayIterator
extends ConvertingIterator<IBindings<IValue>, Object[]>
implements ITupleResult<Object[]> {
    private IEntityManagerInternal manager;
    private int maxResults;
    private int position;
    private ITupleResult<IBindings<IValue>> result;
    private Map<String, ResultInfo> resultInfos;

    public TupleArrayIterator(IEntityManagerInternal manager, ITupleResult<IBindings<IValue>> result, int maxResults, Map<String, ResultInfo> resultInfos) {
        super(result);
        this.result = result;
        this.manager = manager;
        this.maxResults = maxResults;
        this.resultInfos = resultInfos;
    }

    protected Object[] convert(IBindings<IValue> sol) {
        Object[] result = new Object[this.getBindingNames().size()];
        ResultInfo resultInfoForAll = this.resultInfos != null ? this.resultInfos.get(null) : null;
        int i = 0;
        for (String bindingName : this.getBindingNames()) {
            List<Class<?>> types;
            ResultInfo resultInfo;
            IValue value = (IValue)sol.get(bindingName);
            Object converted = value == null ? null : (this.resultInfos != null && ((resultInfo = this.resultInfos.get(bindingName)) != null || (resultInfo = resultInfoForAll) != null) ? (value instanceof IReference ? (!(types = resultInfo.types).isEmpty() && types.get(0) == URI.class ? ((IReference)value).getURI() : (resultInfo.typeRestricted ? this.manager.findRestricted((IReference)value, resultInfo.types) : this.manager.find((IReference)value, resultInfo.types))) : this.manager.toInstance(value, resultInfo.types.get(0), null)) : this.manager.toInstance(value, null, null));
            result[i++] = converted;
        }
        return result;
    }

    public List<String> getBindingNames() {
        return this.result.getBindingNames();
    }

    public boolean hasNext() {
        if (this.maxResults > 0 && this.position >= this.maxResults) {
            this.close();
            return false;
        }
        return super.hasNext();
    }

    public Object[] next() {
        try {
            ++this.position;
            Object[] objectArray = (Object[])super.next();
            return objectArray;
        }
        finally {
            if (this.maxResults > 0 && this.position >= this.maxResults) {
                this.close();
            }
        }
    }
}

