/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.query;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.ITupleResult;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.LinkedHashBindings;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.internal.IEntityManagerInternal;
import net.enilink.komma.em.internal.query.ResultInfo;

public class TupleBindingsIterator
extends ConvertingIterator<IBindings<IValue>, IBindings<Object>>
implements ITupleResult<IBindings<Object>> {
    private IEntityManagerInternal manager;
    private int maxResults;
    private int position;
    private ITupleResult<IBindings<IValue>> result;
    private Map<String, ResultInfo> resultInfos;

    public TupleBindingsIterator(IEntityManagerInternal manager, ITupleResult<IBindings<IValue>> result, int maxResults, Map<String, ResultInfo> resultInfos) {
        super(result);
        this.result = result;
        this.manager = manager;
        this.maxResults = maxResults;
        this.resultInfos = resultInfos;
    }

    protected IBindings<Object> convert(IBindings<IValue> sol) {
        LinkedHashBindings result = new LinkedHashBindings();
        Iterator keys = sol.getKeys().iterator();
        ResultInfo resultInfoForAll = this.resultInfos != null ? this.resultInfos.get(null) : null;
        for (IValue value : sol) {
            List<Class<?>> types;
            ResultInfo resultInfo;
            String varName = (String)keys.next();
            Object converted = value == null ? null : (this.resultInfos != null && ((resultInfo = this.resultInfos.get(varName)) != null || (resultInfo = resultInfoForAll) != null) ? (value instanceof IReference ? (!(types = resultInfo.types).isEmpty() && types.get(0) == URI.class ? ((IReference)value).getURI() : (resultInfo.typeRestricted ? this.manager.findRestricted((IReference)value, resultInfo.types) : this.manager.find((IReference)value, resultInfo.types))) : this.manager.toInstance(value, resultInfo.types.get(0), null)) : this.manager.toInstance(value, null, null));
            result.put(varName, converted);
        }
        return result;
    }

    public List<String> getBindingNames() {
        return this.result.getBindingNames();
    }

    public boolean hasNext() {
        if (this.maxResults > 0 && this.position >= this.maxResults) {
            this.close();
            return false;
        }
        return super.hasNext();
    }

    public IBindings<Object> next() {
        try {
            ++this.position;
            IBindings iBindings = (IBindings)super.next();
            return iBindings;
        }
        finally {
            if (this.maxResults > 0 && this.position >= this.maxResults) {
                this.close();
            }
        }
    }
}

