/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.util;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.IMap;
import net.enilink.commons.iterator.NiceIterator;
import net.enilink.commons.iterator.UniqueExtendedIterator;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.core.TemporalType;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.em.KommaEM;
import net.enilink.komma.em.concepts.ClassSupport;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IOntology;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.em.concepts.OntologySupport;
import net.enilink.komma.em.concepts.PropertySupport;
import net.enilink.komma.em.concepts.ResourceSupport;
import net.enilink.komma.em.util.ISparqlConstants;
import net.enilink.komma.em.util.KommaCoreModule;
import net.enilink.komma.em.util.RoleClassLoader;
import net.enilink.vocab.komma.KommaConceptsModule;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.owl.OwlModule;
import net.enilink.vocab.rdf.RDF;
import net.enilink.vocab.rdfs.RDFS;
import net.enilink.vocab.rdfs.RdfsModule;
import net.enilink.vocab.xmlschema.XMLSCHEMA;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class KommaUtil
implements ISparqlConstants {
    public static KommaModule getCoreModule() {
        KommaCoreModule module = new KommaCoreModule();
        module.includeModule((KommaModule)new OwlModule());
        module.includeModule((KommaModule)new RdfsModule());
        module.includeModule((KommaModule)new KommaConceptsModule());
        RoleClassLoader roleClassLoader = new RoleClassLoader(module);
        roleClassLoader.load();
        module.addBehaviour(ResourceSupport.class);
        module.addBehaviour(ClassSupport.class);
        module.addBehaviour(PropertySupport.class);
        module.addBehaviour(OntologySupport.class);
        module.addConcept(IClass.class);
        module.addConcept(IResource.class);
        module.addConcept(IOntology.class);
        module.addConcept(IProperty.class);
        return module;
    }

    public static IExtendedIterator<URL> getConceptLibraries(String bundleName) {
        Enumeration libraries;
        if (KommaEM.IS_OSGI_RUNNING) {
            Optional<Bundle> targetBundle = Stream.of(FrameworkUtil.getBundle(KommaUtil.class).getBundleContext().getBundles()).filter(b -> b.getSymbolicName().equals(bundleName)).findFirst();
            libraries = targetBundle.map(b -> b.findEntries("lib", "*.jar", true)).orElse(null);
        } else {
            try {
                libraries = KommaUtil.class.getClassLoader().getResources("lib/*.jar");
            }
            catch (IOException e) {
                KommaEM.INSTANCE.log(e);
                return NiceIterator.emptyIterator();
            }
        }
        if (libraries != null) {
            Set librarySet = WrappedIterator.create(libraries).toSet();
            return UniqueExtendedIterator.create(librarySet.iterator()).mapWith((IMap)new IMap<URL, URL>(){

                public URL map(URL value) {
                    try {
                        return FileLocator.resolve((URL)new URL(URIs.createURI((String)value.toString()).trimSegments(2).toString()));
                    }
                    catch (Exception e) {
                        KommaEM.INSTANCE.log(e);
                        return value;
                    }
                }
            }).andThen(librarySet.iterator());
        }
        return WrappedIterator.emptyIterator();
    }

    public static boolean isW3cNamespace(URI namespace) {
        if (namespace == null) {
            return false;
        }
        return namespace.equals((Object)OWL.NAMESPACE_URI) || namespace.equals((Object)RDFS.NAMESPACE_URI) || namespace.equals((Object)RDF.NAMESPACE_URI) || namespace.equals((Object)XMLSCHEMA.NAMESPACE_URI);
    }

    public static Collection<IResource> getInstances(IEntityManager manager, Collection<? extends IReference> classes) {
        StringBuilder sb = new StringBuilder("SELECT DISTINCT ?r WHERE {");
        int i = 0;
        Iterator<? extends IReference> iterator = classes.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            sb.append("{ ?r a ?c").append(i++).append(" }");
            if (!iterator.hasNext()) continue;
            sb.append(" UNION ");
        }
        sb.append("}");
        IQuery query = manager.createQuery(sb.toString());
        i = 0;
        for (IReference iReference : classes) {
            query.setParameter("c" + i++, (Object)iReference);
        }
        return query.getResultList();
    }

    public static Object convertToType(IEntityManager manager, Object value, URI typeName) {
        if (value instanceof ILiteral) {
            value = ((ILiteral)value).getLabel();
        }
        if (RDFS.TYPE_LITERAL.equals((Object)typeName)) {
            typeName = XMLSCHEMA.TYPE_STRING;
        }
        return manager.toInstance((IValue)manager.createLiteral(String.valueOf(value), typeName, null));
    }

    public static ILiteral createStringLiteral(IEntityManager manager, Object value, String languageCode) {
        if (value instanceof ILiteral) {
            value = ((ILiteral)value).getLabel();
        }
        return manager.createLiteral(String.valueOf(value), null, languageCode);
    }

    public static Object convertToRange(IEntityManager manager, Collection<? extends IReference> range, Object value) {
        URI rangeName = null;
        for (IReference iReference : range) {
            rangeName = iReference.getURI();
            if (rangeName == null) continue;
            return KommaUtil.convertToType(manager, value, rangeName);
        }
        return value;
    }

    public static void removeSuperClasses(Set<IClass> classes) {
        for (IClass typeClass : classes.toArray(new IClass[classes.size()])) {
            Iterator<IClass> it = classes.iterator();
            while (it.hasNext()) {
                IClass otherClass = it.next();
                if (typeClass == otherClass || !typeClass.getRdfsSubClassOf().contains(otherClass)) continue;
                it.remove();
            }
        }
    }

    public static void unfoldSubClasses(Set<IClass> classes) {
        for (IClass typeClass : classes.toArray(new IClass[classes.size()])) {
            IExtendedIterator<IClass> leafSubClasses = typeClass.getNamedLeafSubClasses(true);
            if (!leafSubClasses.hasNext()) continue;
            classes.remove(typeClass);
            classes.addAll(leafSubClasses.toSet());
        }
    }

    public static Collection<String> getDefaultLanguages() {
        return Arrays.asList("en", "de", "es");
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Calendar value, TemporalType temporalType) {
        assert (value instanceof GregorianCalendar) : value;
        GregorianCalendar cal = (GregorianCalendar)value;
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xcal = factory.newXMLGregorianCalendar(cal);
            switch (temporalType) {
                case DATE: {
                    xcal.setHour(Integer.MIN_VALUE);
                    xcal.setMinute(Integer.MIN_VALUE);
                    xcal.setSecond(Integer.MIN_VALUE);
                    xcal.setMillisecond(Integer.MIN_VALUE);
                    break;
                }
                case TIME: {
                    xcal.setYear(Integer.MIN_VALUE);
                    xcal.setMonth(Integer.MIN_VALUE);
                    xcal.setDay(Integer.MIN_VALUE);
                    break;
                }
            }
            return xcal;
        }
        catch (DatatypeConfigurationException e) {
            throw new KommaException((Throwable)e);
        }
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Date value, TemporalType temporalType) {
        try {
            XMLGregorianCalendar xcal;
            int z = Integer.MIN_VALUE;
            DatatypeFactory factory = DatatypeFactory.newInstance();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(value);
            switch (temporalType) {
                case DATE: {
                    int y = calendar.get(1);
                    int M = calendar.get(2) + 1;
                    int d = calendar.get(5);
                    xcal = factory.newXMLGregorianCalendarDate(y, M, d, z);
                    break;
                }
                case TIME: {
                    int h = calendar.get(10);
                    int m = calendar.get(12);
                    int s = calendar.get(13);
                    int i = (int)(value.getTime() % 1000L);
                    xcal = factory.newXMLGregorianCalendarTime(h, m, s, i, z);
                    break;
                }
                case TIMESTAMP: {
                    int y = calendar.get(1);
                    int M = calendar.get(2) + 1;
                    int d = calendar.get(5);
                    int h = calendar.get(10);
                    int m = calendar.get(12);
                    int s = calendar.get(13);
                    int i = (int)(value.getTime() % 1000L);
                    xcal = factory.newXMLGregorianCalendar(y, M, d, h, m, s, i, z);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return xcal;
        }
        catch (DatatypeConfigurationException e) {
            throw new KommaException((Throwable)e);
        }
    }
}

