/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.enilink.komma.parser.sparql.Sparql11Parser;
import net.enilink.komma.parser.sparql.SparqlParser;
import net.enilink.komma.parser.sparql.tree.AbstractGraphNode;
import net.enilink.komma.parser.sparql.tree.BNode;
import net.enilink.komma.parser.sparql.tree.ConstructQuery;
import net.enilink.komma.parser.sparql.tree.Graph;
import net.enilink.komma.parser.sparql.tree.GraphNode;
import net.enilink.komma.parser.sparql.tree.GraphPattern;
import net.enilink.komma.parser.sparql.tree.IriRef;
import net.enilink.komma.parser.sparql.tree.OptionalGraph;
import net.enilink.komma.parser.sparql.tree.OrderModifier;
import net.enilink.komma.parser.sparql.tree.PrefixDecl;
import net.enilink.komma.parser.sparql.tree.PropertyList;
import net.enilink.komma.parser.sparql.tree.PropertyPattern;
import net.enilink.komma.parser.sparql.tree.Query;
import net.enilink.komma.parser.sparql.tree.QueryWithSolutionModifier;
import net.enilink.komma.parser.sparql.tree.SelectQuery;
import net.enilink.komma.parser.sparql.tree.Variable;
import net.enilink.komma.parser.sparql.tree.visitor.ToStringVisitor;
import net.enilink.komma.parser.sparql.tree.visitor.TreeWalker;
import net.enilink.komma.parser.sparql.tree.visitor.Visitable;
import net.enilink.komma.parser.sparql.tree.visitor.Visitor;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.Var;

public class SparqlBuilder {
    private static final IriRef RESULT_NODE = new IriRef("komma:Result");
    private static final PropertyPattern PATTERN_TYPE_RESULT_NODE = new PropertyPattern((GraphNode)new IriRef(SparqlParser.RDF_TYPE), (GraphNode)RESULT_NODE);
    protected Query query;
    protected List<GraphNode> resultNodes;
    protected Set<String> usedVarNames;
    protected SparqlParser parser;
    protected ToStringVisitor toStringVisitor;

    public SparqlBuilder(String sparql) {
        this.query = this.parseQuery(sparql);
    }

    protected Object parse(Rule rule, String sparql) {
        ParsingResult result = new ReportingParseRunner(rule).run(sparql);
        if (result.hasErrors()) {
            throw new IllegalArgumentException(ErrorUtils.printParseErrors((List)result.parseErrors));
        }
        return result.resultValue;
    }

    protected SparqlParser getParser() {
        if (this.parser == null) {
            this.parser = (SparqlParser)Parboiled.createParser(Sparql11Parser.class, (Object[])new Object[0]);
        }
        return this.parser;
    }

    protected Query parseQuery(String sparql) {
        return (Query)this.parse(this.getParser().Query(), sparql);
    }

    protected void toConstructQuery() {
        ArrayList<GraphNode> template = new ArrayList<GraphNode>();
        if (this.query instanceof SelectQuery) {
            template.addAll(((SelectQuery)this.query).getProjection());
        }
        if (template.isEmpty()) {
            for (String varName : this.getUsedVarNames()) {
                template.add((GraphNode)new Variable(varName));
            }
        }
        this.prepareTemplate(template);
        Collection<Object> modifiers = Collections.emptyList();
        if (this.query instanceof QueryWithSolutionModifier && ((QueryWithSolutionModifier)this.query).getOrderModifier() != null) {
            modifiers = Collections.singleton(((QueryWithSolutionModifier)this.query).getOrderModifier());
        }
        ConstructQuery constructQuery = new ConstructQuery(template, this.query.getDataset(), this.query.getGraph(), modifiers);
        constructQuery.setPrologue(this.query.getPrologue());
        this.query = constructQuery;
    }

    protected void prepareTemplate(List<GraphNode> template) {
        Iterator<GraphNode> it = template.iterator();
        while (it.hasNext()) {
            GraphNode node = it.next();
            if (!(node instanceof Variable)) {
                it.remove();
                continue;
            }
            PropertyList propertyList = new PropertyList();
            propertyList.add((Object)PATTERN_TYPE_RESULT_NODE.copy());
            ((AbstractGraphNode)node).setPropertyList(propertyList);
        }
    }

    protected void addPropertyToTemplate(String property, GraphNode object) {
        for (GraphNode resultNode : this.resultNodes) {
            resultNode.getPropertyList().add((Object)new PropertyPattern((GraphNode)new IriRef(property), object.copy(false)));
            resultNode.getPropertyList().add((Object)new PropertyPattern((GraphNode)new IriRef(property), RESULT_NODE.copy(false)));
        }
        if (!object.getPropertyList().isEmpty()) {
            ((ConstructQuery)this.query).getTemplate().add(object.copy(true));
        }
    }

    public SparqlBuilder optional(String property, String param, String sparql) {
        return this.optional(property, param, null, sparql);
    }

    public SparqlBuilder optional(String property, String variable, String param, String sparql) {
        return this.optional(property, variable, param, this.parseQuery(sparql));
    }

    public SparqlBuilder optional(String property, String variable, String param, SparqlBuilder other) {
        return this.optional(property, variable, param, other.query);
    }

    protected Set<String> getUsedVarNames() {
        if (this.usedVarNames == null) {
            this.usedVarNames = new LinkedHashSet<String>();
            this.usedVarNames.addAll(new VarRenamer().process(this.query, null, this.usedVarNames));
        }
        return this.usedVarNames;
    }

    protected SparqlBuilder optional(String property, String variable, String param, Query other) {
        if (!(this.query instanceof ConstructQuery)) {
            this.toConstructQuery();
        }
        if (this.resultNodes == null) {
            this.resultNodes = new ArrayList<GraphNode>();
            block0: for (GraphNode node : ((ConstructQuery)this.query).getTemplate()) {
                for (Object pattern : node.getPropertyList()) {
                    if (!RESULT_NODE.equals((Object)pattern.getObject())) continue;
                    this.resultNodes.add(node);
                    continue block0;
                }
            }
        }
        VarRenamer otherVarRenamer = new VarRenamer();
        HashMap<String, String> nodeNameMap = null;
        if (param != null && !this.resultNodes.isEmpty()) {
            nodeNameMap = new HashMap<String, String>();
            nodeNameMap.put(param, ((Variable)this.resultNodes.get(0)).getName());
        }
        Collection<String> otherVarNames = otherVarRenamer.process(other, nodeNameMap, this.getUsedVarNames());
        this.getUsedVarNames().addAll(otherVarNames);
        if (property != null) {
            if (variable != null) {
                this.addPropertyToTemplate(property, (GraphNode)new Variable(otherVarRenamer.mapVarName(variable)));
                if (other instanceof ConstructQuery) {
                    for (GraphNode node : ((ConstructQuery)other).getTemplate()) {
                        node = node.copy(true);
                        node.getPropertyList().remove((Object)PATTERN_TYPE_RESULT_NODE);
                        ((ConstructQuery)this.query).getTemplate().add(node);
                    }
                }
            } else if (other instanceof ConstructQuery) {
                if (((ConstructQuery)other).getTemplate().isEmpty()) {
                    for (String varName : otherVarNames) {
                        this.addPropertyToTemplate(property, (GraphNode)new Variable(varName));
                    }
                } else {
                    for (GraphNode node : ((ConstructQuery)other).getTemplate()) {
                        this.addPropertyToTemplate(property, node);
                    }
                }
            } else if (((SelectQuery)other).getProjection().isEmpty()) {
                for (String varName : otherVarNames) {
                    this.addPropertyToTemplate(property, (GraphNode)new Variable(varName));
                }
            } else {
                for (GraphNode node : ((SelectQuery)other).getProjection()) {
                    this.addPropertyToTemplate(property, node);
                }
            }
        } else if (other instanceof ConstructQuery) {
            ((ConstructQuery)this.query).getTemplate().addAll(((ConstructQuery)other).getTemplate());
        }
        this.query.getPrologue().getPrefixDecls().addAll(other.getPrologue().getPrefixDecls());
        this.removeDuplicates(this.query.getPrologue().getPrefixDecls());
        this.query.getDataset().add(other.getDataset());
        OrderModifier orderModifier = ((ConstructQuery)this.query).getOrderModifier();
        if (other instanceof QueryWithSolutionModifier && ((QueryWithSolutionModifier)other).getOrderModifier() != null) {
            if (orderModifier == null) {
                orderModifier = ((QueryWithSolutionModifier)other).getOrderModifier();
            } else {
                ArrayList conditions = new ArrayList(orderModifier.getOrderConditions());
                conditions.addAll(((QueryWithSolutionModifier)other).getOrderModifier().getOrderConditions());
                orderModifier = new OrderModifier(conditions);
            }
        }
        OptionalGraph optionalGraph = other.getGraph() instanceof OptionalGraph ? (OptionalGraph)other.getGraph() : new OptionalGraph(other.getGraph());
        ConstructQuery combinedQuery = new ConstructQuery(((ConstructQuery)this.query).getTemplate(), this.query.getDataset(), (Graph)new GraphPattern(new ArrayList<Graph>(Arrays.asList(this.query.getGraph(), optionalGraph)), Collections.emptyList()), orderModifier == null ? Collections.emptyList() : Collections.singleton(orderModifier));
        combinedQuery.setPrologue(this.query.getPrologue());
        this.query = combinedQuery;
        return this;
    }

    public SparqlBuilder fetchTypes() {
        if (!(this.query instanceof ConstructQuery)) {
            this.toConstructQuery();
        }
        final HashMap nodesWithoutType = new HashMap();
        TreeWalker<GraphNode> nodeFinder = new TreeWalker<GraphNode>(){

            public Boolean propertyList(PropertyList propertyList, GraphNode subject) {
                nodesWithoutType.put(subject, null);
                for (PropertyPattern pattern : propertyList) {
                    if (pattern.getPredicate() instanceof IriRef && ((IriRef)pattern.getPredicate()).getIri().equals(SparqlParser.RDF_TYPE)) {
                        if (RESULT_NODE.equals((Object)pattern.getObject())) continue;
                        nodesWithoutType.remove(subject);
                    }
                    nodesWithoutType.put(pattern.getObject(), null);
                    pattern.getObject().accept((Visitor)this, (Object)pattern.getObject());
                }
                return true;
            }
        };
        for (GraphNode node : ((ConstructQuery)this.query).getTemplate()) {
            node.accept((Visitor)nodeFinder, (Object)node);
        }
        TreeWalker<GraphNode> patternFinder = new TreeWalker<GraphNode>(){
            Stack<GraphPattern> patterns = new Stack();
            Map<GraphPattern, PatternInfo> patternInfos = new HashMap<GraphPattern, PatternInfo>();
            int depth;
            int optionals;

            public Boolean bNode(BNode bNode, GraphNode data) {
                return super.bNode(bNode, (Object)bNode);
            }

            public Boolean iriRef(IriRef iriRef, GraphNode data) {
                return super.iriRef(iriRef, (Object)iriRef);
            }

            public Boolean variable(Variable variable, GraphNode data) {
                return super.variable(variable, (Object)variable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean optionalGraph(OptionalGraph optionalGraph, GraphNode data) {
                try {
                    ++this.optionals;
                    Boolean bl = super.optionalGraph(optionalGraph, (Object)data);
                    return bl;
                }
                finally {
                    --this.optionals;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean graphPattern(GraphPattern graphPattern, GraphNode data) {
                try {
                    ++this.depth;
                    this.patterns.push(graphPattern);
                    this.patternInfos.put(graphPattern, new PatternInfo(this.depth, this.optionals));
                    Boolean bl = super.graphPattern(graphPattern, (Object)data);
                    return bl;
                }
                finally {
                    this.patterns.pop();
                    --this.depth;
                }
            }

            public Boolean propertyList(PropertyList propertyList, GraphNode subject) {
                if (nodesWithoutType.containsKey(subject)) {
                    GraphPattern other = (GraphPattern)nodesWithoutType.get(subject);
                    if (other != null) {
                        PatternInfo info = this.patternInfos.get(other);
                        if (info.optionals > this.optionals || info.depth > this.depth) {
                            nodesWithoutType.put(subject, this.patterns.peek());
                        }
                    } else {
                        nodesWithoutType.put(subject, this.patterns.peek());
                    }
                }
                for (PropertyPattern pattern : propertyList) {
                    pattern.getObject().accept((Visitor)this, (Object)pattern.getObject());
                }
                return true;
            }

            class PatternInfo {
                int depth;
                int optionals;

                PatternInfo(int depth, int optionals) {
                    this.depth = depth;
                    this.optionals = optionals;
                }
            }
        };
        this.query.getGraph().accept((Visitor)patternFinder, null);
        int i = 1;
        for (Map.Entry entry : nodesWithoutType.entrySet()) {
            String typeVar;
            if (((GraphNode)entry.getKey()).equals(RESULT_NODE)) continue;
            GraphNode copy = ((GraphNode)entry.getKey()).copy(false);
            String nodeName = this.toString((Visitable)copy);
            do {
                typeVar = "preloadedType_" + i++;
            } while (this.getUsedVarNames().contains(typeVar));
            this.getUsedVarNames().add(typeVar);
            this.parse(this.parser.PropertyListNotEmpty(new Var((Object)copy)), "a ?" + typeVar);
            ((ConstructQuery)this.query).getTemplate().add(copy);
            ((GraphPattern)entry.getValue()).getPatterns().add((Graph)this.parse(this.parser.OptionalGraphPattern(), "OPTIONAL {" + nodeName + " a ?" + typeVar + " . FILTER isIRI(?" + typeVar + ")}}"));
        }
        return this;
    }

    protected void removeDuplicates(List<PrefixDecl> prefixDecls) {
        HashSet<String> prefixes = new HashSet<String>();
        Iterator<PrefixDecl> it = prefixDecls.iterator();
        while (it.hasNext()) {
            PrefixDecl prefixDecl = it.next();
            if (prefixes.add(prefixDecl.getPrefix() + ":<" + prefixDecl.getIri().getIri() + ">")) continue;
            it.remove();
        }
    }

    protected String toString(Visitable value) {
        return ((StringBuilder)value.accept((Visitor)new ToStringVisitor(), (Object)new StringBuilder())).toString();
    }

    public String toString() {
        if (this.query == null) {
            return "";
        }
        return this.toString((Visitable)this.query);
    }

    static class VarRenamer
    extends TreeWalker<Object> {
        private List<Variable> queryVars = new ArrayList<Variable>();
        private Set<String> queryVarNames = new HashSet<String>();
        private Map<String, String> queryVarNameMap = new LinkedHashMap<String, String>();

        VarRenamer() {
        }

        public Collection<String> process(Query query, Map<String, String> varNameMap, Set<String> usedVarNames) {
            query.accept((Visitor)this, null);
            if (varNameMap != null) {
                this.queryVarNameMap.putAll(varNameMap);
            }
            for (Variable variable : this.queryVars) {
                String varName = variable.getName();
                String newVarName = this.mapVarName(varName);
                if (newVarName == null) {
                    int i = 1;
                    newVarName = varName;
                    if (usedVarNames.contains(newVarName)) {
                        while (usedVarNames.contains(newVarName) || this.queryVarNames.contains(newVarName)) {
                            newVarName = varName + i++;
                        }
                    }
                    this.queryVarNameMap.put(varName, newVarName);
                }
                if (varName.equals(newVarName)) continue;
                variable.setName(newVarName);
            }
            return this.queryVarNameMap.values();
        }

        public String mapVarName(String varName) {
            return this.queryVarNameMap.get(varName);
        }

        public Boolean variable(Variable variable, Object value) {
            this.queryVars.add(variable);
            this.queryVarNames.add(variable.getName());
            return (Boolean)variable.getPropertyList().accept((Visitor)this, value);
        }
    }
}

