/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.rdf4j;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.dm.IDataManagerQuery;
import net.enilink.komma.internal.rdf4j.result.RDF4JBooleanResult;
import net.enilink.komma.internal.rdf4j.result.RDF4JGraphResult;
import net.enilink.komma.internal.rdf4j.result.RDF4JResult;
import net.enilink.komma.internal.rdf4j.result.RDF4JTupleResult;
import net.enilink.komma.rdf4j.RDF4JValueConverter;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.TupleQuery;

public class RDF4JQuery<R>
implements IDataManagerQuery<R> {
    protected static Set<String> supportedProperties = new HashSet<String>(Arrays.asList("net.enilink.komma.query.timeout"));
    protected Map<String, Object> properties;
    @Inject
    Injector injector;
    protected Query query;
    @Inject
    RDF4JValueConverter valueConverter;

    public RDF4JQuery(Query query) {
        this.query = query;
    }

    public IExtendedIterator<R> evaluate() {
        try {
            RDF4JResult convertedResult = this.query instanceof TupleQuery ? new RDF4JTupleResult(((TupleQuery)this.query).evaluate()) : (this.query instanceof GraphQuery ? new RDF4JGraphResult((CloseableIteration<Statement, ? extends Exception>)((GraphQuery)this.query).evaluate()) : new RDF4JBooleanResult(((BooleanQuery)this.query).evaluate()));
            this.injector.injectMembers((Object)convertedResult);
            return convertedResult;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getSupportedProperties() {
        return supportedProperties;
    }

    public IDataManagerQuery<R> setParameter(String name, IValue value) {
        Value boundValue = this.valueConverter.toRdf4j(value);
        if (boundValue == null) {
            this.query.removeBinding(name);
        } else {
            this.query.setBinding(name, boundValue);
        }
        return this;
    }

    protected Map<String, Object> ensureProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public IDataManagerQuery<R> setProperty(String propertyName, Object value) {
        switch (propertyName) {
            case "net.enilink.komma.query.timeout": {
                if (value instanceof Number) {
                    long timeout = ((Number)value).longValue();
                    this.query.setMaxExecutionTime(timeout <= 0L ? 0 : (int)(timeout / 1000L));
                    this.ensureProperties().put(propertyName, value);
                    break;
                }
                throw new IllegalArgumentException("Illegal argument '" + value + "' for property " + "net.enilink.komma.query.timeout");
            }
        }
        return this;
    }
}

