/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.rdf4j;

import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IReferenceable;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;

public class RDF4JReference
implements IReference {
    private Resource resource;
    private URI uri;

    public RDF4JReference(Resource resource) {
        this.resource = resource;
        if (resource instanceof IRI) {
            this.uri = URIs.createURI((String)((IRI)resource).stringValue());
        }
    }

    public boolean equals(Object obj) {
        if (this.uri != null) {
            return this.uri.equals(obj);
        }
        if (obj instanceof IReferenceable) {
            obj = ((IReferenceable)obj).getReference();
        }
        return obj instanceof RDF4JReference && this.resource.equals(((RDF4JReference)obj).resource);
    }

    public Resource getRDF4JResource() {
        return this.resource;
    }

    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        if (this.uri != null) {
            return this.uri.hashCode();
        }
        return this.resource.hashCode();
    }

    public String toString() {
        return this.resource.toString();
    }
}

