/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.rdf4j;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.enilink.commons.iterator.Filter;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.core.INamespace;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IStatementPattern;
import net.enilink.komma.core.ITransaction;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.InferencingCapability;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Namespace;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.IDataManagerQuery;
import net.enilink.komma.dm.IDataManagerUpdate;
import net.enilink.komma.dm.change.IDataChangeSupport;
import net.enilink.komma.internal.rdf4j.RDF4JQuery;
import net.enilink.komma.internal.rdf4j.RDF4JReference;
import net.enilink.komma.internal.rdf4j.RDF4JTransaction;
import net.enilink.komma.internal.rdf4j.RDF4JUpdate;
import net.enilink.komma.internal.rdf4j.RDF4JUpdateRemote;
import net.enilink.komma.internal.rdf4j.result.RDF4JGraphResult;
import net.enilink.komma.internal.rdf4j.result.RDF4JResult;
import net.enilink.komma.rdf4j.RDF4JValueConverter;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;

public class RDF4JRepositoryDataManager
implements IDataManager {
    protected static final IReference[] NULL_CTX = new IReference[]{null};
    protected IDataChangeSupport changeSupport;
    protected RepositoryConnection connection;
    @Inject(optional=true)
    protected volatile InferencingCapability inferencing;
    @Inject
    protected Injector injector;
    @Inject
    protected Repository repository;
    protected RDF4JTransaction transaction;
    @Inject
    protected RDF4JValueConverter valueConverter;

    @Inject
    public RDF4JRepositoryDataManager(Repository repository, IDataChangeSupport changeSupport) {
        try {
            this.connection = repository.getConnection();
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
        this.changeSupport = changeSupport;
        this.transaction = new RDF4JTransaction(this, changeSupport);
    }

    protected IReference[] addNullContext(boolean includeInferred, IReference[] contexts) {
        if (includeInferred && this.getInferencing().inDefaultGraph()) {
            for (IReference ctx : contexts) {
                if (ctx != null) continue;
                return contexts;
            }
            contexts = Arrays.copyOf(contexts, contexts.length + 1);
            contexts[contexts.length - 1] = null;
        }
        return contexts;
    }

    public IDataManager add(Iterable<? extends IStatement> statements, IReference[] readContexts, IReference ... addContexts) {
        if (addContexts.length == 0) {
            addContexts = NULL_CTX;
        }
        IRI[] readCtx = this.valueConverter.toRdf4jIRI(readContexts);
        IRI[] addCtx = this.valueConverter.toRdf4jIRI(addContexts);
        try {
            Iterator<? extends IStatement> it = statements.iterator();
            RepositoryConnection conn = this.getConnection();
            boolean trackChanges = this.changeSupport.isEnabled((IDataManager)this);
            while (it.hasNext()) {
                IStatement stmt = it.next();
                Resource subject = this.valueConverter.toRdf4j(stmt.getSubject());
                IRI predicate = (IRI)this.valueConverter.toRdf4j(stmt.getPredicate());
                Value object = this.valueConverter.toRdf4j((IValue)stmt.getObject());
                if (trackChanges && !conn.hasStatement(subject, predicate, object, false, (Resource[])readCtx)) {
                    for (IReference ctx : addContexts) {
                        this.changeSupport.add((IDataManager)this, (IStatement)new net.enilink.komma.core.Statement(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), ctx, stmt.isInferred()));
                    }
                }
                if (stmt.isInferred()) continue;
                conn.add(subject, predicate, object, (Resource[])addCtx);
            }
            if (!this.getTransaction().isActive()) {
                this.clearNodeMappings();
                if (this.changeSupport.isEnabled((IDataManager)this)) {
                    this.changeSupport.commit((IDataManager)this);
                }
            }
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
        return this;
    }

    public IDataManager add(Iterable<? extends IStatement> statements, IReference ... addContexts) {
        return this.add(statements, addContexts, addContexts);
    }

    public IDataManager clearNamespaces() {
        try {
            if (this.changeSupport.isEnabled((IDataManager)this)) {
                for (INamespace namespace : this.getNamespaces()) {
                    this.changeSupport.removeNamespace((IDataManager)this, namespace.getPrefix(), namespace.getURI());
                }
                this.changeSupport.commit((IDataManager)this);
            }
            this.getConnection().clearNamespaces();
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
        return this;
    }

    public void close() {
        if (this.connection == null) {
            return;
        }
        this.changeSupport.close((IDataManager)this);
        try {
            this.connection.close();
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
        finally {
            this.connection = null;
        }
    }

    protected Query prepareRdf4jQuery(String query, String baseURI, boolean includeInferred) throws MalformedQueryException, RepositoryException {
        return this.getConnection().prepareQuery(QueryLanguage.SPARQL, query, baseURI);
    }

    protected String ensureBindingsInGraph(String query, IReference[] contexts) {
        if (contexts.length == 0) {
            return query;
        }
        boolean allNull = true;
        for (int i = 0; allNull && i < contexts.length; allNull &= contexts[i] == null, ++i) {
        }
        if (allNull) {
            return query;
        }
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        String delim = " ,)(;.{}";
        int i = 0;
        int qlen = query.length();
        int open = 0;
        int closed = 0;
        while (i < qlen) {
            char ch;
            if ((ch = query.charAt(i++)) == '{') {
                if (variables.size() > 0) break;
                ++open;
            } else if (ch == '}') {
                ++closed;
            } else if (ch == '?' || ch == '$') {
                int j;
                for (j = i; j < qlen && delim.indexOf(query.charAt(j)) < 0; ++j) {
                }
                if (j != i) {
                    String varName = query.substring(i - 1, j).trim();
                    variables.add(varName);
                }
            }
            if (open <= 0 || open != closed) continue;
            break;
        }
        int lastBrace = query.lastIndexOf(125);
        StringBuilder sb = new StringBuilder(query.substring(0, lastBrace));
        int n = 0;
        int g = 0;
        if (!variables.isEmpty()) {
            sb.append("\nfilter (");
            Iterator varIt = variables.iterator();
            while (varIt.hasNext()) {
                String var = (String)varIt.next();
                sb.append("\n(!bound(").append(var).append(") || isLiteral(").append(var).append(") || exists { graph ?__g").append(g++).append(" {\n");
                sb.append("\t{ ").append(var).append(" ?__p").append(n++).append(" ?__o").append(n++).append(" } UNION ");
                sb.append("{ ?__s").append(n++).append(" ?__p").append(n++).append(" ").append(var).append(" } UNION ");
                sb.append("{ ?__s").append(n++).append(" ").append(var).append(" ?__o").append(n++).append(" }\n");
                sb.append("} })\n");
                if (!varIt.hasNext()) continue;
                sb.append(" && ");
            }
            sb.append(")");
        }
        sb.append(query.substring(lastBrace));
        return sb.toString();
    }

    protected void setDataset(Operation operation, IReference[] readContexts, IReference ... modifyContexts) {
        if (readContexts.length > 0 || modifyContexts.length > 0) {
            operation.setDataset(this.valueConverter.createDataset(readContexts, modifyContexts));
        }
    }

    public <R> IDataManagerQuery<R> createQuery(String query, String baseURI, boolean includeInferred, IReference ... contexts) {
        contexts = this.addNullContext(includeInferred, contexts);
        try {
            Query rdf4jQuery = this.prepareRdf4jQuery(query, baseURI, includeInferred);
            this.setDataset((Operation)rdf4jQuery, contexts, new IReference[0]);
            rdf4jQuery.setIncludeInferred(includeInferred);
            RDF4JQuery result = new RDF4JQuery(rdf4jQuery);
            this.injector.injectMembers(result);
            return result;
        }
        catch (RepositoryException e) {
            throw new KommaException((Throwable)e);
        }
        catch (MalformedQueryException e) {
            throw new KommaException("Invalid query format", (Throwable)e);
        }
    }

    public IDataManagerUpdate createUpdate(String update, String baseURI, boolean includeInferred, IReference ... contexts) {
        return this.createUpdate(update, baseURI, includeInferred, contexts, contexts);
    }

    public IDataManagerUpdate createUpdate(String update, String baseURI, boolean includeInferred, IReference[] readContexts, IReference ... modifyContexts) {
        readContexts = this.addNullContext(includeInferred, readContexts);
        if (this.changeSupport.isEnabled((IDataManager)this)) {
            RDF4JUpdate result = new RDF4JUpdate(this, update, baseURI, includeInferred, readContexts, modifyContexts);
            this.injector.injectMembers((Object)result);
            return result;
        }
        try {
            Update updateOp = this.getConnection().prepareUpdate(QueryLanguage.SPARQL, update);
            this.setDataset((Operation)updateOp, readContexts, modifyContexts);
            updateOp.setIncludeInferred(includeInferred);
            RDF4JUpdateRemote result = new RDF4JUpdateRemote(updateOp);
            this.injector.injectMembers((Object)result);
            return result;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    protected RepositoryConnection getConnection() {
        return this.connection;
    }

    public InferencingCapability getInferencing() {
        if (this.inferencing == null) {
            this.inferencing = new InferencingCapability(){

                public boolean doesOWL() {
                    return false;
                }

                public boolean doesRDFS() {
                    return true;
                }

                public boolean inDefaultGraph() {
                    return true;
                }
            };
        }
        return this.inferencing;
    }

    public URI getNamespace(String prefix) {
        try {
            String namespaceURI = this.getConnection().getNamespace(prefix);
            if (namespaceURI != null) {
                return URIs.createURI((String)namespaceURI);
            }
            return null;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    public IExtendedIterator<INamespace> getNamespaces() {
        RDF4JResult<org.eclipse.rdf4j.model.Namespace, INamespace> result = null;
        try {
            result = new RDF4JResult<org.eclipse.rdf4j.model.Namespace, INamespace>((CloseableIteration)this.getConnection().getNamespaces()){

                @Override
                protected INamespace convert(org.eclipse.rdf4j.model.Namespace element) throws Exception {
                    try {
                        return new Namespace(element.getPrefix(), URIs.createURI((String)element.getName()));
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
            };
            return result.filterDrop((Filter)new Filter<INamespace>(){

                public boolean accept(INamespace ns) {
                    return ns == null;
                }
            });
        }
        catch (Exception e) {
            if (null != result) {
                result.close();
            }
            throw new KommaException((Throwable)e);
        }
    }

    public ITransaction getTransaction() {
        return this.transaction;
    }

    public boolean hasMatch(IReference subject, IReference predicate, IValue object, boolean includeInferred, IReference ... contexts) {
        contexts = this.addNullContext(includeInferred, contexts);
        try {
            return this.getConnection().hasStatement(this.valueConverter.toRdf4j(subject), (IRI)this.valueConverter.toRdf4j(predicate), this.valueConverter.toRdf4j(object), includeInferred, (Resource[])this.valueConverter.toRdf4jIRI(contexts));
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    public boolean isOpen() {
        return this.connection != null;
    }

    public IExtendedIterator<IStatement> match(IReference subject, IReference predicate, IValue object, boolean includeInferred, IReference ... contexts) {
        contexts = this.addNullContext(includeInferred, contexts);
        try {
            RDF4JGraphResult result = new RDF4JGraphResult((CloseableIteration<Statement, ? extends Exception>)this.getConnection().getStatements(this.valueConverter.toRdf4j(subject), (IRI)this.valueConverter.toRdf4j(predicate), this.valueConverter.toRdf4j(object), includeInferred, (Resource[])this.valueConverter.toRdf4jIRI(contexts)));
            this.injector.injectMembers((Object)result);
            return result;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    public IReference blankNode() {
        return new RDF4JReference((Resource)this.getConnection().getValueFactory().createBNode());
    }

    public IReference blankNode(String id) {
        if (id == null) {
            return this.blankNode();
        }
        if (id.startsWith("_:")) {
            id = id.substring(2);
        }
        return new RDF4JReference((Resource)this.getConnection().getValueFactory().createBNode(id));
    }

    public IDataManager remove(Iterable<? extends IStatementPattern> statements, IReference ... contexts) {
        if (contexts.length == 0) {
            contexts = NULL_CTX;
        }
        IRI[] removeContexts = this.valueConverter.toRdf4jIRI(contexts);
        try {
            RepositoryConnection conn = this.getConnection();
            boolean trackChanges = this.changeSupport.isEnabled((IDataManager)this);
            for (IStatementPattern iStatementPattern : statements) {
                if (iStatementPattern instanceof IStatement && ((IStatement)iStatementPattern).isInferred()) {
                    if (!trackChanges) continue;
                    for (IReference ctx : contexts) {
                        this.changeSupport.remove((IDataManager)this, (IStatement)new net.enilink.komma.core.Statement(iStatementPattern.getSubject(), iStatementPattern.getPredicate(), iStatementPattern.getObject(), ctx, true));
                    }
                    continue;
                }
                Resource subject = this.valueConverter.toRdf4j(iStatementPattern.getSubject());
                IRI predicate = (IRI)this.valueConverter.toRdf4j(iStatementPattern.getPredicate());
                Value object = this.valueConverter.toRdf4j((IValue)iStatementPattern.getObject());
                if (trackChanges) {
                    for (IStatement existing : this.match(iStatementPattern.getSubject(), iStatementPattern.getPredicate(), (IValue)iStatementPattern.getObject(), false, contexts)) {
                        IReference[] changeContexts;
                        IReference[] iReferenceArray;
                        if (existing.getContext() != null) {
                            IReference[] iReferenceArray2 = new IReference[1];
                            iReferenceArray = iReferenceArray2;
                            iReferenceArray2[0] = existing.getContext();
                        } else {
                            iReferenceArray = contexts;
                        }
                        for (IReference ctx : changeContexts = iReferenceArray) {
                            this.changeSupport.remove((IDataManager)this, (IStatement)new net.enilink.komma.core.Statement(existing.getSubject(), existing.getPredicate(), existing.getObject(), ctx, existing.isInferred()));
                        }
                    }
                }
                conn.remove(subject, predicate, object, (Resource[])removeContexts);
            }
            if (this.changeSupport.isEnabled((IDataManager)this) && !this.getTransaction().isActive()) {
                this.changeSupport.commit((IDataManager)this);
            }
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
        return this;
    }

    public IDataManager removeNamespace(String prefix) {
        try {
            String namespace;
            if (this.changeSupport.isEnabled((IDataManager)this) && (namespace = this.getConnection().getNamespace(prefix)) != null) {
                this.changeSupport.removeNamespace((IDataManager)this, prefix, URIs.createURI((String)namespace));
            }
            this.getConnection().removeNamespace(prefix);
            if (this.changeSupport.isEnabled((IDataManager)this)) {
                this.changeSupport.commit((IDataManager)this);
            }
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
        return this;
    }

    public IDataManager setNamespace(String prefix, URI uri) {
        try {
            if (this.changeSupport.isEnabled((IDataManager)this)) {
                URI existing = this.getNamespace(prefix);
                this.changeSupport.setNamespace((IDataManager)this, prefix, existing, uri);
            }
            this.getConnection().setNamespace(prefix, uri.toString());
            if (this.changeSupport.isEnabled((IDataManager)this)) {
                this.changeSupport.commit((IDataManager)this);
            }
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
        return this;
    }

    void clearNodeMappings() {
        this.valueConverter.reset();
    }
}

