/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.rdf4j;

import net.enilink.komma.core.ITransaction;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.RollbackException;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.change.IDataChangeSupport;
import net.enilink.komma.internal.rdf4j.RDF4JRepositoryDataManager;
import org.eclipse.rdf4j.repository.RepositoryException;

public class RDF4JTransaction
implements ITransaction {
    private RDF4JRepositoryDataManager dm;
    private IDataChangeSupport changeSupport;
    private boolean rollbackOnly = false;

    public RDF4JTransaction(RDF4JRepositoryDataManager dm, IDataChangeSupport changeSupport) {
        this.dm = dm;
        this.changeSupport = changeSupport;
    }

    public void begin() {
        try {
            if (this.isActive()) {
                throw new IllegalStateException("Transaction already started");
            }
            this.dm.getConnection().begin();
        }
        catch (RepositoryException e) {
            throw new KommaException((Throwable)e);
        }
    }

    public void commit() {
        try {
            if (!this.isActive()) {
                throw new IllegalStateException("Transaction has not been started");
            }
            this.dm.getConnection().commit();
            this.dm.clearNodeMappings();
            this.rollbackOnly = false;
            if (this.changeSupport.isEnabled((IDataManager)this.dm)) {
                this.changeSupport.commit((IDataManager)this.dm);
            }
        }
        catch (RepositoryException e) {
            throw new RollbackException((Throwable)e);
        }
    }

    public void rollback() {
        try {
            if (!this.isActive()) {
                throw new IllegalStateException("Transaction has not been started");
            }
            this.dm.getConnection().rollback();
            this.rollbackOnly = false;
            if (this.changeSupport.isEnabled((IDataManager)this.dm)) {
                this.changeSupport.rollback((IDataManager)this.dm);
            }
        }
        catch (RepositoryException e) {
            throw new KommaException((Throwable)e);
        }
    }

    public void setRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction has not been started");
        }
        this.rollbackOnly = true;
    }

    public boolean getRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction has not been started");
        }
        return this.rollbackOnly;
    }

    public boolean isActive() {
        try {
            return this.dm.getConnection().isActive();
        }
        catch (RepositoryException e) {
            throw new KommaException((Throwable)e);
        }
    }
}

