/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.rdf4j;

import com.google.inject.Inject;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.dm.IDataManagerUpdate;
import net.enilink.komma.rdf4j.RDF4JValueConverter;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;

public class RDF4JUpdateRemote
implements IDataManagerUpdate {
    protected Update update;
    @Inject
    RDF4JValueConverter valueConverter;

    public RDF4JUpdateRemote(Update update) {
        this.update = update;
    }

    public void execute() {
        try {
            this.update.execute();
        }
        catch (UpdateExecutionException e) {
            throw new KommaException((Throwable)e);
        }
    }

    public IDataManagerUpdate setParameter(String name, IValue value) {
        Value boundValue = this.valueConverter.toRdf4j(value);
        if (boundValue == null) {
            this.update.removeBinding(name);
        } else {
            this.update.setBinding(name, boundValue);
        }
        return this;
    }
}

