/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.enilink.composition.BehaviourFactory;
import net.enilink.composition.ClassDefiner;
import net.enilink.composition.exceptions.CompositionException;
import net.enilink.composition.helpers.ClassComposer;
import net.enilink.composition.mappers.RoleMapper;

@Singleton
public class ClassResolver<T> {
    public static final String PKG_PREFIX = "object.proxies.";
    private static final String CLASS_PREFIX = "_EntityProxy";
    private ClassDefiner definer;
    private RoleMapper<T> mapper;
    private ConcurrentMap<Collection<T>, Class<?>> multiples = new ConcurrentHashMap();
    private Injector injector;
    @Inject
    Set<BehaviourFactory> behaviourFactories;

    @Inject
    public ClassResolver(RoleMapper<T> mapper, ClassDefiner cp, Injector injector) {
        this.mapper = mapper;
        this.definer = cp;
        this.injector = injector;
    }

    @Inject
    public void setBehaviourFactories(Set<BehaviourFactory> behaviourFactories) {
        this.behaviourFactories = behaviourFactories;
    }

    public Class<?> resolveComposite(T resource, Collection<T> types) {
        ArrayList roles = new ArrayList();
        this.mapper.findIndividualRoles(resource, roles);
        this.mapper.findRoles(types, (Collection<Class<?>>)roles);
        return this.getCompositeClass(roles);
    }

    public Class<?> resolveComposite(Collection<T> types) {
        Class<?> proxy = (Class<?>)this.multiples.get(types);
        if (proxy != null) {
            return proxy;
        }
        ArrayList roles = new ArrayList();
        this.mapper.findRoles(types, (Collection<Class<?>>)roles);
        proxy = this.getCompositeClass(roles);
        this.multiples.putIfAbsent(types, proxy);
        return proxy;
    }

    private Class<?> getCompositeClass(Collection<Class<?>> roles) {
        try {
            String className = this.getJavaClassName(roles);
            return this.getCompositeClass(className, roles);
        }
        catch (Exception e) {
            ArrayList<String> roleNames = new ArrayList<String>();
            for (Class<?> f : roles) {
                roleNames.add(f.getSimpleName());
            }
            throw new CompositionException(e.toString() + " for entity with roles: " + roleNames, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getCompositeClass(String className, Collection<Class<?>> roles) throws Exception {
        try {
            return Class.forName(className, true, this.definer);
        }
        catch (ClassNotFoundException e) {
            ClassDefiner classDefiner = this.definer;
            synchronized (classDefiner) {
                try {
                    return Class.forName(className, true, this.definer);
                }
                catch (ClassNotFoundException e1) {
                    return this.composeBehaviours(className, roles);
                }
            }
        }
    }

    private Class<?> composeBehaviours(String className, Collection<Class<?>> roles) throws Exception {
        List<Class<?>> types = new ArrayList(roles.size());
        types.addAll(roles);
        types = this.removeSuperClasses(types);
        ClassComposer cc = new ClassComposer(className, types.size());
        this.injector.injectMembers(cc);
        LinkedHashSet behaviours = new LinkedHashSet(types.size());
        for (Class<?> role : types) {
            if (role.isInterface()) {
                cc.addInterface(role);
                continue;
            }
            behaviours.add(role);
        }
        cc.addAllBehaviours(this.findImplementations(behaviours));
        cc.addAllBehaviours(this.findImplementations(cc.getInterfaces()));
        return cc.compose();
    }

    public Collection<Class<?>> findImplementations(Collection<Class<?>> classes) {
        try {
            Set<Class<?>> faces = new HashSet();
            for (Class<?> c : classes) {
                faces.add(c);
                faces = this.findImplementedClasses(c, faces);
            }
            ArrayList behaviours = new ArrayList();
            for (Class clazz : faces) {
                for (BehaviourFactory factory : this.behaviourFactories) {
                    behaviours.addAll(factory.implement(clazz));
                }
            }
            return behaviours;
        }
        catch (CompositionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompositionException(e);
        }
    }

    protected Set<Class<?>> findImplementedClasses(Class<?> role, Set<Class<?>> implementations) {
        Class<?> superclass;
        for (Class<?> face : role.getInterfaces()) {
            if (!implementations.add(face)) continue;
            this.findImplementedClasses(face, implementations);
        }
        if (!role.isInterface() && (superclass = role.getSuperclass()) != null && !Object.class.equals(superclass)) {
            this.findImplementedClasses(superclass, implementations);
        }
        return implementations;
    }

    private List<Class<?>> removeSuperClasses(List<Class<?>> classes) {
        block0: for (int i = classes.size() - 1; i >= 0; --i) {
            Class<?> c = classes.get(i);
            for (int j = classes.size() - 1; j >= 0; --j) {
                Class<?> d = classes.get(j);
                if (i == j || !c.isAssignableFrom(d) || c.isInterface() != d.isInterface()) continue;
                classes.remove(i);
                continue block0;
            }
        }
        return classes;
    }

    private String getJavaClassName(Collection<Class<?>> javaClasses) {
        String phex = this.packagesToHexString(javaClasses);
        String chex = this.classesToHexString(javaClasses);
        return "object.proxies._" + phex + "." + CLASS_PREFIX + chex;
    }

    private String packagesToHexString(Collection<Class<?>> javaClasses) {
        TreeSet<String> names = new TreeSet<String>();
        for (Class<?> clazz : javaClasses) {
            if (clazz.getPackage() == null) continue;
            names.add(clazz.getPackage().getName());
        }
        return this.toHexString(names);
    }

    private String classesToHexString(Collection<Class<?>> javaClasses) {
        TreeSet<String> names = new TreeSet<String>();
        for (Class<?> clazz : javaClasses) {
            names.add(clazz.getName());
        }
        return this.toHexString(names);
    }

    private String toHexString(TreeSet<String> names) {
        long hashCode = 0L;
        for (String name : names) {
            hashCode = 31L * hashCode + (long)name.hashCode();
        }
        return Long.toHexString(hashCode);
    }
}

