/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import net.enilink.composition.BehaviourFactory;
import net.enilink.composition.ClassDefiner;
import net.enilink.composition.asm.BehaviourClassProcessor;
import net.enilink.composition.asm.BehaviourMethodProcessor;
import net.enilink.composition.asm.DefaultBehaviourFactory;
import net.enilink.composition.asm.processors.BehaviourConstructorGenerator;
import net.enilink.composition.asm.processors.BehaviourInterfaceImplementor;
import net.enilink.composition.asm.processors.MethodDelegationGenerator;
import net.enilink.composition.mappers.DefaultRoleMapper;
import net.enilink.composition.mappers.RoleMapper;
import net.enilink.composition.mappers.TypeFactory;

public class CompositionModule<T>
extends AbstractModule {
    private Multibinder<BehaviourFactory> behaviourFactoryBinder;
    private Multibinder<BehaviourClassProcessor> classProcessorBinder;
    private Multibinder<BehaviourMethodProcessor> methodProcessorBinder;

    protected void bindClassDefiner() {
        this.bind(ClassDefiner.class).in(Singleton.class);
    }

    protected void configure() {
        this.initBindings();
    }

    protected Multibinder<BehaviourClassProcessor> getBehaviourClassProcessorBinder() {
        if (this.classProcessorBinder == null) {
            this.classProcessorBinder = Multibinder.newSetBinder((Binder)this.binder(), BehaviourClassProcessor.class);
        }
        return this.classProcessorBinder;
    }

    protected Multibinder<BehaviourFactory> getBehaviourFactoryBinder() {
        if (this.behaviourFactoryBinder == null) {
            this.behaviourFactoryBinder = Multibinder.newSetBinder((Binder)this.binder(), BehaviourFactory.class);
        }
        return this.behaviourFactoryBinder;
    }

    protected Multibinder<BehaviourMethodProcessor> getBehaviourMethodProcessorBinder() {
        if (this.methodProcessorBinder == null) {
            this.methodProcessorBinder = Multibinder.newSetBinder((Binder)this.binder(), BehaviourMethodProcessor.class);
        }
        return this.methodProcessorBinder;
    }

    protected void initBindings() {
        this.getBehaviourClassProcessorBinder().addBinding().to(BehaviourInterfaceImplementor.class);
        this.getBehaviourClassProcessorBinder().addBinding().to(BehaviourConstructorGenerator.class);
        this.getBehaviourMethodProcessorBinder().addBinding().to(MethodDelegationGenerator.class);
        this.getBehaviourFactoryBinder().addBinding().to(DefaultBehaviourFactory.class);
        this.bindClassDefiner();
    }

    protected RoleMapper<T> createRoleMapper(TypeFactory<T> typeFactory) {
        return new DefaultRoleMapper<T>(typeFactory);
    }

    protected void initRoleMapper(RoleMapper<T> roleMapper, TypeFactory<T> typeFactory) {
    }

    @Provides
    @Singleton
    protected RoleMapper<T> provideRoleMapper(TypeFactory<T> typeFactory) {
        RoleMapper<T> roleMapper = this.createRoleMapper(typeFactory);
        this.initRoleMapper(roleMapper, typeFactory);
        return roleMapper;
    }
}

