/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.enilink.composition.ClassResolver;
import net.enilink.composition.ObjectFactory;
import net.enilink.composition.exceptions.CompositionException;
import net.enilink.composition.mappers.RoleMapper;

public class DefaultObjectFactory<T>
implements ObjectFactory<T> {
    private RoleMapper<T> mapper;
    private ClassResolver<T> resolver;
    @Inject
    private Injector injector;

    @Inject
    public DefaultObjectFactory(RoleMapper<T> mapper, ClassResolver<T> resolver) {
        this.mapper = mapper;
        this.resolver = resolver;
    }

    protected Object createInstance(Class<?> proxy) {
        try {
            return this.injector.getInstance(proxy);
        }
        catch (Exception e) {
            throw new CompositionException(e);
        }
    }

    @Override
    public Object createObject() {
        return this.createInstance(this.resolver.resolveComposite(Collections.emptyList()));
    }

    @Override
    public <C> C createObject(Class<C> type) {
        Set<T> types = Collections.singleton(this.getType(type));
        return type.cast(this.createObject((Collection<T>)types));
    }

    @Override
    public <C> C createObject(Class<C> type, Class<?> ... types) {
        HashSet<T> typeList = new HashSet<T>(1 + types.length);
        typeList.add(this.getType(type));
        for (Class<?> typeClass : types) {
            typeList.add(this.getType(typeClass));
        }
        return type.cast(this.createObject((Collection<T>)typeList));
    }

    @Override
    public Object createObject(Collection<T> types) {
        Class<?> proxy = this.resolver.resolveComposite(types);
        return this.createInstance(proxy);
    }

    @Override
    public Object createObject(T ... types) {
        assert (types != null && types.length > 0);
        List<T> list = Arrays.asList(types);
        return this.createObject((Collection<T>)list);
    }

    protected T getType(Class<?> concept) {
        return this.mapper.findType(concept);
    }

    public boolean isNamedConcept(Class<?> type) {
        return this.mapper.findType(type) != null;
    }
}

