/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.asm;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.enilink.composition.ClassDefiner;
import net.enilink.composition.asm.AsmUtils;
import net.enilink.composition.asm.ExtendedMethod;
import net.enilink.composition.asm.meta.ClassInfo;
import net.enilink.composition.asm.util.MethodNodeGenerator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ExtendedClassNode
extends ClassNode {
    public static final String INJECTOR_FIELD = "_$injector";
    private MethodNodeGenerator clinitGen;
    private final List<MethodNode> constructors = new ArrayList<MethodNode>();
    private final Map<Object, ExtendedMethod> extendedMethods = new HashMap<Object, ExtendedMethod>();
    private Map<String, FieldNode> fieldIndex;
    private final Class<?> parentClass;
    private final Type parentType;
    private Type type;

    public ExtendedClassNode(Type type, Class<?> parentClass, ClassInfo parentClassInfo) {
        super(327680);
        String[] interfaces = new String[parentClass.getInterfaces().length];
        int i = 0;
        for (Class<?> face : parentClass.getInterfaces()) {
            interfaces[i++] = Type.getInternalName(face);
        }
        Class superClass = parentClass.isInterface() ? Object.class : parentClass;
        this.visit(49, 1, type.getInternalName(), null, Type.getInternalName(superClass), interfaces);
        if (parentClassInfo != null) {
            parentClassInfo.copyAnnotations((ClassVisitor)this);
        }
        this.type = type;
        this.parentClass = parentClass;
        this.parentType = Type.getType(parentClass);
    }

    public ExtendedMethod addExtendedMethod(java.lang.reflect.Method method, ClassDefiner definer) throws Exception {
        Object key = this.getKey(method);
        ExtendedMethod extendedMethod = this.extendedMethods.get(key);
        if (extendedMethod == null) {
            extendedMethod = new ExtendedMethod(this, method);
            MethodNode faceNode = AsmUtils.getClassInfo(method.getDeclaringClass().getName(), definer).getMethod(Method.getMethod((java.lang.reflect.Method)method));
            faceNode.accept((MethodVisitor)extendedMethod);
            this.methods.add(extendedMethod);
            this.extendedMethods.put(key, extendedMethod);
            extendedMethod.access &= 0xFFFFFBFF;
        }
        return extendedMethod;
    }

    public void addField(FieldNode field) {
        if (this.fieldIndex == null) {
            this.fieldIndex = new HashMap<String, FieldNode>();
        }
        this.fieldIndex.put(field.name, field);
        this.fields.add(field);
    }

    public void addInjectorField() {
        FieldNode injectorField = new FieldNode(2, INJECTOR_FIELD, Type.getDescriptor(Injector.class), null, null);
        injectorField.visitAnnotation(Type.getDescriptor(Inject.class), true);
        this.fields.add(injectorField);
    }

    public void addInterface(String internalName) {
        if (!this.interfaces.contains(internalName)) {
            this.interfaces.add(internalName);
        }
    }

    public void endClass() {
        if (this.clinitGen != null) {
            this.clinitGen.returnValue();
            this.clinitGen.endMethod();
        }
    }

    public MethodNodeGenerator getClassInitGen() {
        if (this.clinitGen == null) {
            MethodNode clinit = new MethodNode(8, "<clinit>", "()V", null, null);
            this.methods.add(clinit);
            this.clinitGen = new MethodNodeGenerator(clinit);
        }
        return this.clinitGen;
    }

    public List<MethodNode> getConstructors() {
        return this.constructors;
    }

    public ExtendedMethod getExtendedMethod(java.lang.reflect.Method method) {
        return this.extendedMethods.get(this.getKey(method));
    }

    public ExtendedMethod getExtendedMethod(java.lang.reflect.Method method, ClassDefiner definer) throws Exception {
        return this.extendedMethods.get(this.getKey(method));
    }

    public Collection<ExtendedMethod> getExtendedMethods() {
        return this.extendedMethods.values();
    }

    public FieldNode getField(String name) {
        if (this.fieldIndex == null) {
            return null;
        }
        return this.fieldIndex.get(name);
    }

    private Object getKey(java.lang.reflect.Method method) {
        return Arrays.asList(method.getReturnType(), method.getName(), Arrays.asList(method.getParameterTypes()));
    }

    public Class<?> getParentClass() {
        return this.parentClass;
    }

    public Type getParentType() {
        return this.parentType;
    }

    public Type getType() {
        return this.type;
    }
}

