/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.mappers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.enilink.composition.exceptions.ConfigException;
import net.enilink.composition.mappers.DefaultRoleMapper;
import net.enilink.composition.mappers.RoleMapper;
import net.enilink.composition.mappers.TypeFactory;

public class ComposedRoleMapper<T>
implements Cloneable,
RoleMapper<T> {
    private RoleMapper<T> primary;
    private List<RoleMapper<T>> roleMappers;
    private TypeFactory<T> typeFactory;

    public ComposedRoleMapper(TypeFactory<T> typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public void addAnnotation(Class<?> annotation) {
        this.getPrimary().addAnnotation(annotation);
    }

    @Override
    public void addAnnotation(Class<?> annotation, T uri) {
        this.getPrimary().addAnnotation(annotation, uri);
    }

    @Override
    public void addAnnotation(Method annotation, T uri) {
        this.getPrimary().addAnnotation(annotation, uri);
    }

    @Override
    public void addAnnotation(Method annotation) {
        this.getPrimary().addAnnotation(annotation);
    }

    @Override
    public void addBehaviour(Class<?> role) throws ConfigException {
        this.getPrimary().addBehaviour(role);
    }

    @Override
    public void addBehaviour(Class<?> role, T type) throws ConfigException {
        this.getPrimary().addBehaviour(role, type);
    }

    @Override
    public void addConcept(Class<?> role) throws ConfigException {
        this.getPrimary().addConcept(role);
    }

    @Override
    public void addConcept(Class<?> role, T type) throws ConfigException {
        this.getPrimary().addConcept(role, type);
    }

    public boolean addRoleMapper(RoleMapper<T> roleMapper) {
        if (this.roleMappers == null) {
            this.roleMappers = new ArrayList<RoleMapper<T>>();
        }
        if (!this.roleMappers.contains(roleMapper)) {
            return this.roleMappers.add(roleMapper);
        }
        return false;
    }

    @Override
    public ComposedRoleMapper<T> clone() {
        try {
            ComposedRoleMapper cloned = (ComposedRoleMapper)super.clone();
            RoleMapper<T> roleMapper = cloned.primary = this.primary == null ? null : this.primary.clone();
            if (this.roleMappers != null) {
                cloned.roleMappers = new ArrayList<RoleMapper<T>>(this.roleMappers);
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public T findAnnotation(Method m) {
        for (RoleMapper delegate : this.iterator()) {
            Object annotation = delegate.findAnnotation(m);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public Collection<Class<?>> findIndividualRoles(T instance, Collection<Class<?>> classes) {
        for (RoleMapper<T> delegate : this.iterator()) {
            delegate.findIndividualRoles(instance, classes);
        }
        return classes;
    }

    @Override
    public Class<?> findInterfaceConcept(T uri) {
        for (RoleMapper<T> delegate : this.iterator()) {
            Class<?> concept = delegate.findInterfaceConcept(uri);
            if (concept == null) continue;
            return concept;
        }
        return null;
    }

    @Override
    public Collection<Class<?>> findRoles(Collection<T> types, Collection<Class<?>> roles) {
        for (RoleMapper<Collection<T>> delegate : this.iterator()) {
            delegate.findRoles(types, roles);
        }
        return roles;
    }

    @Override
    public Collection<Class<?>> findRoles(T type, Collection<Class<?>> roles) {
        for (RoleMapper<T> delegate : this.iterator()) {
            delegate.findRoles(type, roles);
        }
        return roles;
    }

    @Override
    public Collection<T> findSubTypes(Class<?> role, Collection<T> rdfTypes) {
        for (RoleMapper<T> delegate : this.iterator()) {
            delegate.findSubTypes(role, rdfTypes);
        }
        return rdfTypes;
    }

    @Override
    public T findType(Class<?> concept) {
        for (RoleMapper delegate : this.iterator()) {
            Object type = delegate.findType(concept);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private RoleMapper<T> getPrimary() {
        if (this.primary == null) {
            this.primary = new DefaultRoleMapper<T>(this.typeFactory);
            if (this.roleMappers == null) {
                this.roleMappers = new ArrayList<RoleMapper<T>>();
            }
            this.roleMappers.add(0, this.primary);
        }
        return this.primary;
    }

    public Collection<RoleMapper<T>> getRoleMappers() {
        return this.roleMappers == null ? Collections.emptyList() : this.roleMappers;
    }

    @Override
    public boolean isIndividualRolesPresent(T instance) {
        for (RoleMapper<T> delegate : this.iterator()) {
            if (!delegate.isIndividualRolesPresent(instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRecordedConcept(T type) {
        for (RoleMapper<T> delegate : this.iterator()) {
            if (!delegate.isRecordedConcept(type)) continue;
            return true;
        }
        return false;
    }

    private UniqueTransitiveIterator iterator() {
        return new UniqueTransitiveIterator();
    }

    public boolean removeRoleMapper(RoleMapper<T> roleMapper) {
        return this.roleMappers.remove(roleMapper);
    }

    class UniqueTransitiveIterator
    implements Iterator<RoleMapper<T>>,
    Iterable<RoleMapper<T>> {
        protected Queue<Iterator<RoleMapper<T>>> mapperQueue = new LinkedList();
        protected RoleMapper<T> next;
        protected Set<RoleMapper<T>> seen = new HashSet();

        public UniqueTransitiveIterator() {
            this.mapperQueue.add(ComposedRoleMapper.this.getRoleMappers().iterator());
        }

        @Override
        public boolean hasNext() {
            Iterator it;
            if (this.next != null) {
                return true;
            }
            while ((it = this.mapperQueue.peek()) != null) {
                while (it.hasNext()) {
                    RoleMapper candidat = it.next();
                    if (this.seen.contains(candidat)) continue;
                    this.next = candidat;
                    if (this.next instanceof ComposedRoleMapper) {
                        this.mapperQueue.add(((ComposedRoleMapper)this.next).getRoleMappers().iterator());
                    }
                    return true;
                }
                this.mapperQueue.remove();
            }
            return false;
        }

        @Override
        public Iterator<RoleMapper<T>> iterator() {
            return this;
        }

        @Override
        public RoleMapper<T> next() {
            try {
                this.seen.add(this.next);
                RoleMapper roleMapper = this.next;
                return roleMapper;
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This is a read-only iterator.");
        }
    }
}

