/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.mappers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.exceptions.ConfigException;
import net.enilink.composition.mappers.HierarchicalRoleMapper;
import net.enilink.composition.mappers.RoleMapper;
import net.enilink.composition.mappers.RoleMatcher;
import net.enilink.composition.mappers.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoleMapper<T>
implements Cloneable,
RoleMapper<T> {
    private static Logger logger = LoggerFactory.getLogger(DefaultRoleMapper.class);
    private Map<Method, T> annotations = new HashMap<Method, T>();
    private Map<Class<?>, Class<?>> complements = new ConcurrentHashMap();
    private Map<T, List<Class<?>>> instances = new ConcurrentHashMap(256);
    private Map<Class<?>, List<Class<?>>> intersections = new ConcurrentHashMap();
    private RoleMatcher matches = new RoleMatcher();
    private HierarchicalRoleMapper<T> roleMapper = new HierarchicalRoleMapper();
    private TypeFactory<T> typeFactory;

    public DefaultRoleMapper(TypeFactory<T> typeFactory) {
        this.typeFactory = typeFactory;
        this.roleMapper.setTypeFactory(typeFactory);
    }

    @Override
    public void addAnnotation(Class<?> annotation) {
        for (Method m : annotation.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Iri.class)) {
                String msg = "@" + Iri.class.getSimpleName() + " annotation required in " + m.toGenericString();
                throw new IllegalArgumentException(msg);
            }
            String uri = m.getAnnotation(Iri.class).value();
            this.addAnnotation(m, this.typeFactory.createType(uri));
        }
    }

    @Override
    public void addAnnotation(Class<?> annotation, T uri) {
        if (annotation.getDeclaredMethods().length != 1) {
            throw new IllegalArgumentException("Must specify annotation method if multiple methods exist: " + annotation);
        }
        this.addAnnotation(annotation.getDeclaredMethods()[0], uri);
    }

    @Override
    public void addAnnotation(Method annotation) {
        if (!annotation.isAnnotationPresent(Iri.class)) {
            throw new IllegalArgumentException("@" + Iri.class.getSimpleName() + " annotation required in " + annotation.toGenericString());
        }
        String uri = annotation.getAnnotation(Iri.class).value();
        this.addAnnotation(annotation, this.typeFactory.createType(uri));
    }

    @Override
    public void addAnnotation(Method annotation, T uri) {
        this.annotations.put(annotation, uri);
        if (annotation.isAnnotationPresent(Iri.class)) {
            String Iri2 = annotation.getAnnotation(Iri.class).value();
            if (!uri.toString().equals(Iri2)) {
                this.addAnnotation(annotation);
            }
        }
    }

    @Override
    public void addBehaviour(Class<?> role) throws ConfigException {
        this.assertBehaviour(role);
        if (this.recordRole(role, role, null, false)) {
            return;
        }
        boolean hasType = false;
        for (Class<?> face : role.getInterfaces()) {
            boolean recorded = this.recordRole(role, face, null, false);
            if (recorded && hasType) {
                throw new ConfigException(role.getSimpleName() + " can only implement one concept");
            }
            hasType |= recorded;
        }
        if (!hasType) {
            throw new ConfigException(role.getSimpleName() + " must implement a concept or mapped explicitly");
        }
    }

    @Override
    public void addBehaviour(Class<?> role, T type) throws ConfigException {
        this.assertBehaviour(role);
        this.recordRole(role, null, type, false);
    }

    @Override
    public void addConcept(Class<?> role) throws ConfigException {
        this.recordRole(role, role, null, true);
    }

    @Override
    public void addConcept(Class<?> role, T type) throws ConfigException {
        this.recordRole(role, role, type, false);
    }

    private void addInterfaces(Set<Class<?>> set, Class<?> ... list) {
        for (Class<?> c : list) {
            if (c == null || !set.add(c)) continue;
            this.addInterfaces(set, c.getSuperclass());
            this.addInterfaces(set, c.getInterfaces());
        }
    }

    private void addIntersectionsAndComplements(Collection<Class<?>> roles) {
        Object of;
        for (Map.Entry<Class<?>, List<Class<?>>> e : this.intersections.entrySet()) {
            Class<?> clazz = e.getKey();
            List<Class<?>> of2 = e.getValue();
            if (roles.contains(clazz) || !this.intersects(roles, of2)) continue;
            roles.add(clazz);
        }
        boolean complementAdded = false;
        for (Map.Entry<Class<?>, Class<?>> entry : this.complements.entrySet()) {
            Class<?> comp = entry.getKey();
            of = entry.getValue();
            if (roles.contains(comp) || this.contains(roles, (Class<?>)of)) continue;
            complementAdded = true;
            roles.add(comp);
        }
        if (complementAdded) {
            for (Map.Entry<Class<?>, Object> entry : this.intersections.entrySet()) {
                Class<?> inter = entry.getKey();
                of = (List)entry.getValue();
                if (roles.contains(inter) || !this.intersects(roles, (List<Class<?>>)of)) continue;
                roles.add(inter);
            }
        }
    }

    private void assertBehaviour(Class<?> role) throws ConfigException {
        if (role.isInterface()) {
            throw new ConfigException(role.getSimpleName() + " is an interface and not a behaviour");
        }
    }

    @Override
    public DefaultRoleMapper<T> clone() {
        try {
            DefaultRoleMapper cloned = (DefaultRoleMapper)super.clone();
            cloned.roleMapper = this.roleMapper.clone();
            cloned.matches = this.matches.clone();
            cloned.annotations = new HashMap<Method, T>(this.annotations);
            cloned.complements = new ConcurrentHashMap(this.complements);
            cloned.intersections = this.clone(this.intersections);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private <K, V> Map<K, List<V>> clone(Map<K, List<V>> map) {
        ConcurrentHashMap<K, List<V>> cloned = new ConcurrentHashMap<K, List<V>>(map);
        for (Map.Entry entry : cloned.entrySet()) {
            entry.setValue(new CopyOnWriteArrayList((Collection)entry.getValue()));
        }
        return cloned;
    }

    private boolean contains(Collection<Class<?>> roles, Class<?> of) {
        for (Class<?> type : roles) {
            if (!of.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private void findAdditionalRoles(Collection<Class<?>> classes) {
        if (this.complements.isEmpty()) {
            return;
        }
        this.addIntersectionsAndComplements(classes);
    }

    private Collection<Class<?>> findAllRoles(T type) {
        HashSet set = new HashSet();
        for (Class<?> role : this.findRoles(type, new HashSet())) {
            if (!set.add(role)) continue;
            this.addInterfaces(set, role.getSuperclass());
            this.addInterfaces(set, role.getInterfaces());
        }
        return set;
    }

    @Override
    public T findAnnotation(Method ann) {
        return this.annotations.get(ann);
    }

    private T findDefaultType(Class<?> role, AnnotatedElement element) {
        String value;
        if (element.isAnnotationPresent(Iri.class) && (value = element.getAnnotation(Iri.class).value()) != null) {
            return this.typeFactory.createType(value);
        }
        return null;
    }

    @Override
    public Collection<Class<?>> findIndividualRoles(T instance, Collection<Class<?>> classes) {
        List<Class<?>> list = this.instances.get(instance);
        if (list != null) {
            classes.addAll(list);
        }
        this.matches.findRoles(this.typeFactory.toString(instance), classes);
        return classes;
    }

    @Override
    public Class<?> findInterfaceConcept(T uri) {
        Class<?> concept = null;
        Class<?> mapped = null;
        Collection<Class<?>> rs = this.findAllRoles(uri);
        for (Class<?> r : rs) {
            T type = this.findType(r);
            if (!r.isInterface() || type == null) continue;
            concept = r;
            if (!uri.equals(type)) continue;
            mapped = r;
            break;
        }
        if (mapped != null) {
            return mapped;
        }
        if (concept != null) {
            return concept;
        }
        return null;
    }

    @Override
    public Collection<Class<?>> findRoles(Collection<T> types, Collection<Class<?>> roles) {
        this.roleMapper.findRoles(types, roles);
        for (T type : types) {
            this.matches.findRoles(this.typeFactory.toString(type), roles);
        }
        this.findAdditionalRoles(roles);
        return roles;
    }

    @Override
    public Collection<Class<?>> findRoles(T type, Collection<Class<?>> roles) {
        this.roleMapper.findRoles(type, roles);
        this.matches.findRoles(this.typeFactory.toString(type), roles);
        this.findAdditionalRoles(roles);
        return roles;
    }

    @Override
    public Collection<T> findSubTypes(Class<?> role, Collection<T> rdfTypes) {
        return this.roleMapper.findSubTypes(role, rdfTypes);
    }

    @Override
    public T findType(Class<?> concept) {
        return this.roleMapper.findType(concept);
    }

    private boolean intersects(Collection<Class<?>> roles, List<Class<?>> ofs) {
        for (Class<?> of : ofs) {
            if (this.contains(roles, of)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isIndividualRolesPresent(T instance) {
        return !this.matches.isEmpty() || !this.instances.isEmpty() && this.instances.containsKey(instance);
    }

    @Override
    public boolean isRecordedConcept(T type) {
        if (this.roleMapper.isTypeRecorded(type)) {
            for (Class<?> role : this.findAllRoles(type)) {
                if (this.findType(role) == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean recordAnonymous(Class<?> role, Class<?> elm) throws ConfigException {
        boolean recorded = false;
        for (Annotation ann : elm.getAnnotations()) {
            for (Method m : ann.annotationType().getDeclaredMethods()) {
                try {
                    T name = this.findAnnotation(m);
                    if (name == null && m.isAnnotationPresent(Iri.class)) {
                        this.addAnnotation(m);
                        name = this.findAnnotation(m);
                    }
                    if (name == null) continue;
                    Object value = m.invoke((Object)ann, new Object[0]);
                    recorded |= this.recordAnonymous(role, name, value);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return recorded;
    }

    private boolean recordAnonymous(Class<?> role, T name, Object value) throws ConfigException {
        boolean recorded = false;
        try {
            int n;
            int n2;
            String[] values;
            String nameStr = this.typeFactory.toString(name);
            if ("http://www.openrdf.org/rdf/2011/messaging#matching".equals(nameStr)) {
                String[] objectArray = values = (String[])value;
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    String pattern = objectArray[n];
                    this.matches.addRoles(pattern, role);
                    recorded = true;
                }
            }
            if ("http://www.w3.org/2002/07/owl#oneOf".equals(nameStr)) {
                String[] stringArray = values = (String[])value;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String instance = stringArray[n];
                    T uri = this.typeFactory.createType(instance);
                    List<Class<?>> list = this.instances.get(uri);
                    if (list == null) {
                        list = new CopyOnWriteArrayList();
                        this.instances.put(uri, list);
                    }
                    list.add(role);
                    recorded = true;
                }
            }
            if ("http://www.w3.org/2002/07/owl#complementOf".equals(nameStr)) {
                if (value instanceof Class) {
                    Class concept = (Class)value;
                    this.recordRole(concept, concept, null, true);
                    this.complements.put(role, concept);
                    recorded = true;
                } else {
                    for (Class clazz : this.findRoles(this.typeFactory.createType((String)value), new HashSet())) {
                        this.complements.put(role, clazz);
                        recorded = true;
                    }
                }
            }
            if ("http://www.w3.org/2002/07/owl#intersectionOf".equals(nameStr)) {
                ArrayList ofs = new ArrayList();
                Object[] objectArray = (Object[])value;
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    Object v = objectArray[n];
                    if (v instanceof Class) {
                        Class<?> concept = (Class<?>)v;
                        this.recordRole(concept, concept, null, true);
                        ofs.add(concept);
                        continue;
                    }
                    ofs.addAll(this.findRoles(this.typeFactory.createType((String)v), new HashSet()));
                }
                this.intersections.put(role, ofs);
                recorded = true;
            }
            if ("http://www.w3.org/2002/07/owl#unionOf".equals(nameStr)) {
                for (Object v : (Object[])value) {
                    if (v instanceof Class) {
                        Class concept = (Class)v;
                        this.recordRole(concept, concept, null, true);
                        recorded |= this.recordRole(role, concept, null, true);
                        continue;
                    }
                    for (Class<?> concept : this.findRoles(this.typeFactory.createType((String)v), new HashSet())) {
                        if (role.equals(concept)) continue;
                        recorded |= this.recordRole(role, concept, null, true);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return recorded;
    }

    private boolean recordRole(Class<?> role, Class<?> element, T rdfType, boolean base) throws ConfigException {
        Object defType = element == null ? null : (Object)this.findDefaultType(role, element);
        boolean hasType = false;
        if (rdfType != null) {
            if (role.isInterface()) {
                this.roleMapper.recordConcept(role, rdfType);
            } else {
                this.roleMapper.recordBehaviour(role, rdfType);
            }
            hasType = true;
        } else if (defType != null) {
            if (role.isInterface()) {
                this.roleMapper.recordConcept(role, defType);
            } else {
                this.roleMapper.recordBehaviour(role, defType);
            }
            hasType = true;
        } else if (element != null) {
            hasType = this.recordAnonymous(role, element);
        }
        if (!hasType && element != null) {
            for (Class<?> face : element.getInterfaces()) {
                hasType |= this.recordRole(role, face, null, false);
            }
        }
        if (!hasType && base) {
            throw new ConfigException(role.getSimpleName() + " does not have an RDF type mapping");
        }
        return hasType;
    }
}

