/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.mappers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DirectMapper<T>
implements Cloneable {
    private Map<Class<?>, Set<T>> directTypes = new HashMap(256);
    private Map<T, Set<Class<?>>> directRoles = new HashMap(256);

    public DirectMapper<T> clone() {
        try {
            DirectMapper cloned = (DirectMapper)super.clone();
            cloned.directTypes = this.clone(this.directTypes);
            cloned.directRoles = this.clone(this.directRoles);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <K, V> Map<K, Set<V>> clone(Map<K, Set<V>> map) {
        HashMap<K, Set<V>> cloned = new HashMap<K, Set<V>>(map);
        for (Map.Entry entry : cloned.entrySet()) {
            entry.setValue(new HashSet((Collection)entry.getValue()));
        }
        return cloned;
    }

    public Set<Class<?>> getDirectRoles(T type) {
        return this.directRoles.get(type);
    }

    public Set<T> getDirectTypes(Class<?> role) {
        return this.directTypes.get(role);
    }

    public void recordRole(Class<?> role, T type) {
        Set<T> roleTypes = this.directTypes.get(role);
        if (roleTypes == null) {
            roleTypes = new HashSet<T>();
            this.directTypes.put(role, roleTypes);
        }
        if (type != null) {
            roleTypes.add(type);
        }
        if (type != null) {
            Set<Class<?>> typeRoles = this.directRoles.get(type);
            if (typeRoles == null) {
                typeRoles = new HashSet();
                this.directRoles.put(type, typeRoles);
            }
            if (role != null) {
                typeRoles.add(role);
            }
        }
    }
}

