/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.mappers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.enilink.composition.exceptions.CompositionException;
import net.enilink.composition.mappers.DirectMapper;
import net.enilink.composition.mappers.SimpleRoleMapper;
import net.enilink.composition.mappers.TypeFactory;
import net.enilink.composition.mappers.TypeMapper;

public class HierarchicalRoleMapper<T>
implements Cloneable {
    private DirectMapper<T> directMapper = new DirectMapper();
    private TypeMapper<T> typeMapper = new TypeMapper();
    private SimpleRoleMapper<T> simpleRoleMapper = new SimpleRoleMapper();
    private Map<Class<?>, Set<Class<?>>> subClasses = new HashMap(256);

    public HierarchicalRoleMapper<T> clone() {
        try {
            HierarchicalRoleMapper cloned = (HierarchicalRoleMapper)super.clone();
            cloned.directMapper = this.directMapper.clone();
            cloned.typeMapper = this.typeMapper.clone();
            cloned.simpleRoleMapper = this.simpleRoleMapper.clone();
            cloned.subClasses = this.clone(this.subClasses);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <K, V> Map<K, Set<V>> clone(Map<K, Set<V>> map) {
        HashMap<K, Set<V>> cloned = new HashMap<K, Set<V>>(map);
        for (Map.Entry entry : cloned.entrySet()) {
            entry.setValue(new HashSet((Collection)entry.getValue()));
        }
        return cloned;
    }

    public void setTypeFactory(TypeFactory<T> typeFactory) {
        this.simpleRoleMapper.setTypeFactory(typeFactory);
    }

    public Collection<Class<?>> findAllRoles() {
        return this.simpleRoleMapper.findAllRoles();
    }

    public void findRoles(T type, Collection<Class<?>> roles) {
        this.simpleRoleMapper.findRoles(type, roles);
    }

    public void findRoles(Collection<T> types, Collection<Class<?>> classes) {
        this.simpleRoleMapper.findRoles(types, classes);
    }

    public boolean isTypeRecorded(T type) {
        return this.simpleRoleMapper.isTypeRecorded(type);
    }

    public T findType(Class<?> role) {
        return this.typeMapper.findType(role);
    }

    public Collection<T> findSubTypes(Class<?> role, Collection<T> rdfTypes) {
        T type = this.findType(role);
        if (type == null) {
            throw new CompositionException("Concept not registered: " + role.getSimpleName());
        }
        rdfTypes.add(type);
        Set<Class<?>> subset = this.subClasses.get(role);
        if (subset == null) {
            return rdfTypes;
        }
        for (Class<?> c : subset) {
            this.findSubTypes(c, rdfTypes);
        }
        return rdfTypes;
    }

    public synchronized void recordConcept(Class<?> role, T type) {
        this.recordClassHierarchy(role);
        this.typeMapper.recordRole(role, type);
        if (!this.recordRole(role, type)) {
            Set<Class<?>> superRoles = this.getSuperRoles(role);
            Set<Class<?>> newRoles = new HashSet(superRoles.size() + 1);
            newRoles.addAll(superRoles);
            newRoles.add(role);
            newRoles = this.simpleRoleMapper.recordRoles(newRoles, type);
            for (Class<?> r : this.directMapper.getDirectRoles(type)) {
                this.addRolesInSubclasses(r, newRoles);
            }
        }
    }

    public synchronized void recordBehaviour(Class<?> role, T type) {
        if (!this.recordRole(role, type)) {
            Set<Class<?>> newRoles = new HashSet();
            newRoles.add(role);
            newRoles = this.simpleRoleMapper.recordRoles(newRoles, type);
            for (Class<?> r : this.directMapper.getDirectRoles(type)) {
                this.addRolesInSubclasses(r, newRoles);
            }
        }
    }

    private boolean recordRole(Class<?> role, T type) {
        assert (type != null);
        this.directMapper.recordRole(role, type);
        if (this.simpleRoleMapper.getBaseType().equals(type)) {
            this.recordClassHierarchy(role);
            this.simpleRoleMapper.recordBaseRole(role);
            return true;
        }
        return false;
    }

    private void recordClassHierarchy(Class<?> concept) {
        for (Class<?> face : concept.getInterfaces()) {
            Set<Class<?>> set = this.subClasses.get(face);
            if (set == null) {
                set = new HashSet();
                this.subClasses.put(face, set);
            }
            if (!set.add(concept)) continue;
            this.recordClassHierarchy(face);
        }
        Class<?> superClass = concept.getSuperclass();
        if (superClass != null) {
            Set<Class<?>> set = this.subClasses.get(superClass);
            if (set == null) {
                set = new HashSet();
                this.subClasses.put(superClass, set);
            }
            if (set.add(concept)) {
                this.recordClassHierarchy(superClass);
            }
        }
    }

    private Set<Class<?>> getSuperRoles(Class<?> role) {
        HashSet superRoles = new HashSet();
        for (Class<?> sup : role.getInterfaces()) {
            this.addRelatedRoles(this.getSuperRoles(sup), sup, superRoles);
        }
        Class<?> sup = role.getSuperclass();
        if (sup != null) {
            this.addRelatedRoles(this.getSuperRoles(sup), sup, superRoles);
        }
        return superRoles;
    }

    private void addRolesInSubclasses(Class<?> role, Set<Class<?>> newRoles) {
        Set<Class<?>> subset = this.subClasses.get(role);
        if (subset == null) {
            return;
        }
        for (Class<?> sub : subset) {
            HashSet subRoles = new HashSet();
            this.addRelatedRoles(newRoles, sub, subRoles);
            this.addRolesInSubclasses(sub, subRoles);
        }
    }

    private void addRelatedRoles(Set<Class<?>> existing, Class<?> role, Set<Class<?>> roles) {
        roles.addAll(existing);
        Set<T> set = this.directMapper.getDirectTypes(role);
        if (set != null) {
            HashSet rolesForType = new HashSet();
            for (T uri : set) {
                this.simpleRoleMapper.recordRoles(existing, uri);
                this.simpleRoleMapper.findRoles(uri, rolesForType);
                for (Class clazz : rolesForType) {
                    roles.add(clazz);
                }
                rolesForType.clear();
            }
        }
    }
}

