/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.DeploymentEvent;
import org.apache.karaf.features.DeploymentListener;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeatureState;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.DownloadManagers;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.features.internal.region.DigraphHelper;
import org.apache.karaf.features.internal.service.BundleInstallSupport;
import org.apache.karaf.features.internal.service.Deployer;
import org.apache.karaf.features.internal.service.FeatureRepoFinder;
import org.apache.karaf.features.internal.service.FeatureReq;
import org.apache.karaf.features.internal.service.FeaturesProcessor;
import org.apache.karaf.features.internal.service.FeaturesProcessorImpl;
import org.apache.karaf.features.internal.service.FeaturesServiceConfig;
import org.apache.karaf.features.internal.service.RepositoryCache;
import org.apache.karaf.features.internal.service.RepositoryCacheImpl;
import org.apache.karaf.features.internal.service.State;
import org.apache.karaf.features.internal.service.StateStorage;
import org.apache.karaf.features.internal.util.MapUtils;
import org.apache.karaf.util.ThreadUtils;
import org.apache.karaf.util.collections.CopyOnWriteArrayIdentityList;
import org.apache.karaf.util.json.JsonReader;
import org.apache.karaf.util.json.JsonWriter;
import org.eclipse.equinox.region.RegionDigraph;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.MavenResolvers;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.resolver.Resolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesServiceImpl
implements FeaturesService,
Deployer.DeployCallback {
    private static final String RESOLVE_FILE = "resolve";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesServiceImpl.class);
    private final StateStorage storage;
    private final FeatureRepoFinder featureFinder;
    private final ConfigurationAdmin configurationAdmin;
    private final Resolver resolver;
    private final BundleInstallSupport installSupport;
    private final FeaturesServiceConfig cfg;
    private RepositoryCache repositories;
    private FeaturesProcessor featuresProcessor;
    private final ThreadLocal<String> outputFile = new ThreadLocal();
    private final org.osgi.service.repository.Repository globalRepository;
    private final List<FeaturesListener> listeners = new CopyOnWriteArrayIdentityList<FeaturesListener>();
    private final List<DeploymentListener> deploymentListeners = new CopyOnWriteArrayIdentityList<DeploymentListener>();
    private DeploymentEvent lastDeploymentEvent = DeploymentEvent.DEPLOYMENT_FINISHED;
    private final Object lock = new Object();
    private final State state = new State();
    private final ExecutorService executor;
    private Map<String, Map<String, Feature>> featureCache;

    public FeaturesServiceImpl(StateStorage storage, FeatureRepoFinder featureFinder, ConfigurationAdmin configurationAdmin, Resolver resolver, BundleInstallSupport installSupport, org.osgi.service.repository.Repository globalRepository, FeaturesServiceConfig cfg) {
        this.storage = storage;
        this.featureFinder = featureFinder;
        this.configurationAdmin = configurationAdmin;
        this.resolver = resolver;
        this.installSupport = installSupport;
        this.globalRepository = globalRepository;
        this.featuresProcessor = new FeaturesProcessorImpl(cfg);
        this.repositories = new RepositoryCacheImpl(this.featuresProcessor);
        this.cfg = cfg;
        this.executor = Executors.newSingleThreadExecutor(ThreadUtils.namedThreadFactory("features"));
        this.loadState();
        this.checkResolve();
    }

    public void stop() {
        this.executor.shutdown();
    }

    private void checkResolve() {
        Map request;
        File resolveFile = this.installSupport.getDataFile(RESOLVE_FILE);
        if (resolveFile == null || !resolveFile.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(resolveFile);){
            request = (Map)JsonReader.read(fis);
        }
        catch (IOException e) {
            LOGGER.warn("Error reading resolution request", (Throwable)e);
            return;
        }
        Map<String, Set<String>> requestedFeatures = StateStorage.toStringStringSetMap((Map)request.get("features"));
        Collection opts = (Collection)request.get("options");
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        for (String opt : opts) {
            options.add(FeaturesService.Option.valueOf(opt));
        }
        try {
            Map<String, Map<String, FeatureState>> stateChanges = Collections.emptyMap();
            this.doProvisionInThread(requestedFeatures, stateChanges, this.copyState(), this.getFeaturesById(), options);
        }
        catch (Exception e) {
            LOGGER.warn("Error updating state", (Throwable)e);
        }
    }

    private void writeResolve(Map<String, Set<String>> requestedFeatures, EnumSet<FeaturesService.Option> options) throws IOException {
        File resolveFile = this.installSupport.getDataFile(RESOLVE_FILE);
        HashMap<String, Object> request = new HashMap<String, Object>();
        ArrayList<String> opts = new ArrayList<String>();
        for (FeaturesService.Option opt : options) {
            opts.add(opt.toString());
        }
        request.put("features", requestedFeatures);
        request.put("options", opts);
        try (FileOutputStream fos = new FileOutputStream(resolveFile);){
            JsonWriter.write(fos, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadState() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.storage.load(this.state);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error loading FeaturesService state", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveState() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!FeaturesService.SnapshotUpdateBehavior.Crc.getValue().equalsIgnoreCase(this.cfg.updateSnapshots)) {
                    this.state.bundleChecksums.clear();
                }
                this.storage.save(this.state);
                this.installSupport.saveDigraph();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error saving FeaturesService state", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBootDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.bootDone.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bootDone() {
        Object object = this.lock;
        synchronized (object) {
            this.state.bootDone.set(true);
            this.saveState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(FeaturesListener listener) {
        this.listeners.add(listener);
        try {
            TreeMap<String, Set<String>> installedFeatures;
            TreeSet<String> repositoriesList;
            Iterator<Object> iterator = this.lock;
            synchronized (iterator) {
                repositoriesList = new TreeSet<String>(this.state.repositories);
                installedFeatures = new TreeMap<String, Set<String>>(MapUtils.copy(this.state.installedFeatures));
            }
            for (String string : repositoriesList) {
                Repository repository = this.repositories.create(URI.create(string), false);
                listener.repositoryEvent(new RepositoryEvent(repository, RepositoryEvent.EventType.RepositoryAdded, true));
            }
            for (Map.Entry entry : installedFeatures.entrySet()) {
                for (String id : (Set)entry.getValue()) {
                    Feature feature = org.apache.karaf.features.internal.model.Feature.valueOf(id);
                    listener.featureEvent(new FeatureEvent(FeatureEvent.EventType.FeatureInstalled, feature, (String)entry.getKey(), true));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error notifying listener about the current state", (Throwable)e);
        }
    }

    @Override
    public void unregisterListener(FeaturesListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void registerListener(DeploymentListener listener) {
        this.deploymentListeners.add(listener);
        listener.deploymentEvent(this.lastDeploymentEvent);
    }

    @Override
    public void unregisterListener(DeploymentListener listener) {
        this.deploymentListeners.remove(listener);
    }

    @Override
    public void callListeners(FeatureEvent event) {
        for (FeaturesListener listener : this.listeners) {
            listener.featureEvent(event);
        }
    }

    @Override
    public void callListeners(DeploymentEvent event) {
        this.lastDeploymentEvent = event;
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.deploymentEvent(event);
            }
            catch (Exception e) {
                LOGGER.warn("DeploymentListener {} failed to process event {}", new Object[]{listener, event, e});
            }
        }
    }

    protected void callListeners(RepositoryEvent event) {
        for (FeaturesListener listener : this.listeners) {
            listener.repositoryEvent(event);
        }
    }

    @Override
    public URI getRepositoryUriFor(String name, String version) {
        return this.featureFinder.getUriFor(name, version);
    }

    @Override
    public String[] getRepositoryNames() {
        return this.featureFinder.getNames();
    }

    @Override
    public Feature[] repositoryProvidedFeatures(URI uri) throws Exception {
        Features features = JaxbUtil.unmarshal(uri.toURL().toExternalForm(), true);
        Feature[] array = new Feature[features.getFeature().size()];
        return features.getFeature().toArray(array);
    }

    @Override
    public void validateRepository(URI uri) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRepositoryUriBlacklisted(URI uri) {
        return this.featuresProcessor.isRepositoryBlacklisted(uri.toString());
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        this.addRepository(uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepository(URI uri, boolean install) throws Exception {
        Repository repository = this.repositories.create(uri, true);
        Object object = this.lock;
        synchronized (object) {
            this.repositories.addRepository(repository);
            this.featureCache = null;
            if (!this.state.repositories.add(uri.toString())) {
                return;
            }
            this.saveState();
        }
        this.callListeners(new RepositoryEvent(repository, RepositoryEvent.EventType.RepositoryAdded, false));
        if (install) {
            HashSet<String> features = new HashSet<String>();
            for (Feature feature : repository.getFeatures()) {
                features.add(feature.getId());
            }
            this.installFeatures(features, EnumSet.noneOf(FeaturesService.Option.class));
        }
    }

    @Override
    public void removeRepository(URI uri) throws Exception {
        this.removeRepository(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRepository(URI uri, boolean uninstall) throws Exception {
        HashMap<String, Set<String>> reqsToRemove;
        HashSet<String> features;
        Repository repo = this.getRepository(uri);
        if (repo == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.getFeatureCache();
            features = new HashSet<String>();
            for (Set<String> reqs : this.state.requirements.values()) {
                features.addAll(reqs);
            }
            HashSet<Repository> repos = new HashSet<Repository>();
            for (String string : this.state.repositories) {
                if (uri.toString().equals(string)) continue;
                Repository repository = this.repositories.getRepository(string);
                if (repository != null) {
                    repos.addAll(this.repositories.getRepositoryClosure(repository));
                    continue;
                }
                throw new IllegalArgumentException("Repository URI " + uri + " seems to have changed, can't remove repository");
            }
            for (Repository repository : repos) {
                for (Feature f : repository.getFeatures()) {
                    features.remove(new FeatureReq(f).toRequirement());
                }
            }
            reqsToRemove = new HashMap<String, Set<String>>();
            for (Map.Entry entry : this.state.requirements.entrySet()) {
                HashSet hashSet = new HashSet((Collection)entry.getValue());
                hashSet.retainAll(features);
                if (hashSet.isEmpty()) continue;
                reqsToRemove.put((String)entry.getKey(), hashSet);
            }
        }
        if (!features.isEmpty()) {
            if (uninstall) {
                this.removeRequirements(reqsToRemove, EnumSet.noneOf(FeaturesService.Option.class));
            } else {
                throw new IllegalStateException("The following features are required from the repository: " + String.join((CharSequence)", ", features));
            }
        }
        object = this.lock;
        synchronized (object) {
            if (!this.state.repositories.remove(uri.toString())) {
                return;
            }
            this.featureCache = null;
            this.repositories.removeRepository(uri);
            this.saveState();
        }
        this.callListeners(new RepositoryEvent(repo, RepositoryEvent.EventType.RepositoryRemoved, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRequiredFeatureIds(Repository repo) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            return Stream.of(repo.getFeatures()).filter(this::isRequired).map(Feature::getId).collect(Collectors.toSet());
        }
    }

    @Override
    public void restoreRepository(URI uri) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRepository(URI uri) throws Exception {
        this.refreshRepositories(Collections.singleton(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRepositories(Set<URI> uris) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            for (URI uri : uris) {
                this.repositories.removeRepository(uri);
            }
            this.featureCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository[] listRepositories() throws Exception {
        this.ensureCacheLoaded();
        Object object = this.lock;
        synchronized (object) {
            return this.repositories.listRepositories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository[] listRequiredRepositories() throws Exception {
        this.ensureCacheLoaded();
        Object object = this.lock;
        synchronized (object) {
            return this.repositories.listMatchingRepositories(this.state.repositories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository getRepository(String name) throws Exception {
        this.ensureCacheLoaded();
        Object object = this.lock;
        synchronized (object) {
            return this.repositories.getRepositoryByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository getRepository(URI uri) throws Exception {
        this.ensureCacheLoaded();
        Object object = this.lock;
        synchronized (object) {
            return this.repositories.getRepository(uri.toString());
        }
    }

    @Override
    public String getRepositoryName(URI uri) throws Exception {
        Repository repo = this.getRepository(uri);
        return repo != null ? repo.getName() : null;
    }

    @Override
    public Feature getFeature(String name) throws Exception {
        Feature[] features = this.getFeatures(name);
        if (features.length < 1) {
            return null;
        }
        return features[0];
    }

    @Override
    public Feature getFeature(String name, String version) throws Exception {
        Feature[] features = this.getFeatures(name, version);
        if (features.length < 1) {
            return null;
        }
        return features[0];
    }

    @Override
    public Feature[] getFeatures(String nameOrId) throws Exception {
        return this.getFeatures(FeatureReq.parseNameAndRange(nameOrId));
    }

    @Override
    public Feature[] getFeatures(String name, String version) throws Exception {
        return this.getFeatures(new FeatureReq(name, version));
    }

    private Feature[] getFeatures(FeatureReq featureReq) throws Exception {
        Map<String, Map<String, Feature>> allFeatures = this.getFeatureCache();
        return (Feature[])featureReq.getMatchingFeatures(allFeatures).toArray(Feature[]::new);
    }

    private void ensureCacheLoaded() throws Exception {
        this.getFeatureCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Map<String, Feature>> getFeatureCache() throws Exception {
        List<Repository> repos;
        TreeSet<String> uris;
        Object object = this.lock;
        synchronized (object) {
            if (this.featureCache != null) {
                return this.featureCache;
            }
            uris = new TreeSet<String>(this.state.repositories);
        }
        HashMap<String, Map<String, Feature>> map = new HashMap<String, Map<String, Feature>>();
        HashSet<String> loaded = new HashSet<String>();
        ArrayDeque<String> toLoad = new ArrayDeque<String>(uris);
        while (!toLoad.isEmpty()) {
            Repository repo;
            String uri = (String)toLoad.remove();
            Object object2 = this.lock;
            synchronized (object2) {
                repo = this.repositories.getRepository(uri);
            }
            try {
                if (repo == null) {
                    repo = this.repositories.create(URI.create(uri), false);
                    Object object3 = this.lock;
                    synchronized (object3) {
                        this.repositories.addRepository(repo);
                    }
                }
                if (!loaded.add(uri)) continue;
                for (URI u : repo.getRepositories()) {
                    toLoad.add(u.toString());
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load features repository {}", (Object)uri, (Object)exception);
            }
        }
        Object object4 = this.lock;
        synchronized (object4) {
            repos = Arrays.asList(this.repositories.listRepositories());
        }
        for (Repository repository : repos) {
            for (Feature f : repository.getFeatures()) {
                Map versionMap = map.computeIfAbsent(f.getName(), key -> new HashMap());
                versionMap.put(f.getVersion(), f);
            }
        }
        object4 = this.lock;
        synchronized (object4) {
            if (uris.equals(this.state.repositories)) {
                this.featureCache = map;
            }
        }
        return map;
    }

    protected Map<String, Feature> getFeaturesById() throws Exception {
        return this.getFeatureCache().values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toMap(Feature::getId, Function.identity()));
    }

    @Override
    public Feature[] listFeatures() throws Exception {
        Map<String, Map<String, Feature>> allFeatures = this.getFeatureCache();
        return this.flattenFeatures(allFeatures, f -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] listInstalledFeatures() throws Exception {
        Map<String, Map<String, Feature>> allFeatures = this.getFeatureCache();
        Object object = this.lock;
        synchronized (object) {
            return this.flattenFeatures(allFeatures, this::isInstalled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] listRequiredFeatures() throws Exception {
        Map<String, Map<String, Feature>> allFeatures = this.getFeatureCache();
        Object object = this.lock;
        synchronized (object) {
            return this.flattenFeatures(allFeatures, this::isRequired);
        }
    }

    private Feature[] flattenFeatures(Map<String, Map<String, Feature>> features, Predicate<Feature> pred) {
        return (Feature[])features.values().stream().map(Map::values).flatMap(Collection::stream).filter(pred).toArray(Feature[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInstalled(Feature f) {
        String id = this.normalize(f.getId());
        Object object = this.lock;
        synchronized (object) {
            Set<String> installed = this.state.installedFeatures.get("root");
            return installed != null && installed.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureState getState(String featureId) {
        String id = this.normalize(featureId);
        Object object = this.lock;
        synchronized (object) {
            Set<String> installed = this.state.installedFeatures.get("root");
            if (!installed.contains(id)) {
                return FeatureState.Uninstalled;
            }
            String stateSt = this.state.stateFeatures.get("root").get(id);
            return FeatureState.valueOf(stateSt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRequired(Feature f) {
        String id = new FeatureReq(f).toRequirement();
        Object object = this.lock;
        synchronized (object) {
            Set<String> features = this.state.requirements.get("root");
            return features != null && features.contains(id);
        }
    }

    @Override
    public void installFeature(String name) throws Exception {
        this.installFeature(name, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void installFeature(String name, String version) throws Exception {
        this.installFeature(this.getId(name, version), EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void installFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeatures(Collections.singleton(name), options);
    }

    @Override
    public void installFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeature(this.getId(name, version), options);
    }

    @Override
    public void installFeature(Feature feature, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeature(feature.getId(), options);
    }

    @Override
    public void installFeatures(Set<String> features, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeatures(features, "root", options);
    }

    @Override
    public void uninstallFeature(String name, String version) throws Exception {
        this.uninstallFeature(this.getId(name, version));
    }

    @Override
    public void uninstallFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        this.uninstallFeature(this.getId(name, version), options);
    }

    @Override
    public void uninstallFeature(String name) throws Exception {
        this.uninstallFeature(name, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void uninstallFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        this.uninstallFeatures(Collections.singleton(name), options);
    }

    @Override
    public void uninstallFeatures(Set<String> features, EnumSet<FeaturesService.Option> options) throws Exception {
        this.uninstallFeatures(features, "root", options);
    }

    private String getId(String name, String version) {
        return version != null ? name + '/' + version : name;
    }

    @Override
    public void setResolutionOutputFile(String outputFile) {
        this.outputFile.set(outputFile);
    }

    @Override
    public void installFeatures(Set<String> featuresIn, String region, EnumSet<FeaturesService.Option> options) throws Exception {
        Set<FeatureReq> toInstall = MapUtils.map(featuresIn, FeatureReq::parseNameAndRange);
        State state = this.copyState();
        Map<String, Set<String>> requires = MapUtils.copy(state.requirements);
        if (region == null || region.isEmpty()) {
            region = "root";
        }
        Set requirements = requires.computeIfAbsent(region, k -> new HashSet());
        Set<FeatureReq> existingFeatures = MapUtils.map(requirements, FeatureReq::parseRequirement);
        Set<FeatureReq> toAdd = this.computeFeaturesToAdd(options, toInstall);
        toAdd.forEach(f -> {
            if (f.isBlacklisted()) {
                this.print("Skipping blacklisted feature: " + f, options.contains((Object)FeaturesService.Option.Verbose));
            } else {
                requirements.add(f.toRequirement());
            }
        });
        List<FeatureReq> notBlacklisted = toAdd.stream().filter(fr -> !fr.isBlacklisted()).collect(Collectors.toList());
        if (notBlacklisted.size() > 0) {
            this.print("Adding features: " + this.join(notBlacklisted), options.contains((Object)FeaturesService.Option.Verbose));
        }
        if (options.contains((Object)FeaturesService.Option.Upgrade)) {
            Set<FeatureReq> toRemove = this.computeFeaturesToRemoveOnUpdate(toAdd, existingFeatures);
            toRemove.forEach(f -> requirements.remove(f.toRequirement()));
            if (!toRemove.isEmpty()) {
                this.print("Removing features: " + this.join(toRemove), options.contains((Object)FeaturesService.Option.Verbose));
            }
        }
        this.doProvisionInThread(requires, Collections.emptyMap(), state, this.getFeaturesById(), options);
    }

    private Set<FeatureReq> computeFeaturesToAdd(EnumSet<FeaturesService.Option> options, Set<FeatureReq> toInstall) throws Exception {
        Map<String, Map<String, Feature>> allFeatures = this.getFeatureCache();
        Feature[] installedFeatures = this.listInstalledFeatures();
        HashSet<FeatureReq> toAdd = new HashSet<FeatureReq>();
        for (FeatureReq featureReq : toInstall) {
            Collection matching = featureReq.getMatchingFeatures(allFeatures).collect(Collectors.toSet());
            for (Feature f : matching) {
                toAdd.add(new FeatureReq(f));
                Arrays.stream(installedFeatures).filter(fi -> this.isSameFeature(f, (Feature)fi)).forEach(this::logInstalledOrUpdated);
            }
            if (!matching.isEmpty() || options.contains((Object)FeaturesService.Option.NoFailOnFeatureNotFound)) continue;
            throw new IllegalArgumentException("No matching features for " + featureReq);
        }
        return toAdd;
    }

    private void logInstalledOrUpdated(Feature f) {
        String msg = f.getVersion().endsWith("SNAPSHOT") ? "has been upgraded" : "is already installed";
        LOGGER.info("The specified feature: '{}' version '{}' {}", new Object[]{f.getName(), f.getVersion(), msg});
    }

    private boolean isSameFeature(Feature a, Feature b) {
        return b.getName().equals(a.getName()) && b.getVersion().equals(a.getVersion());
    }

    private Set<FeatureReq> computeFeaturesToRemoveOnUpdate(Set<FeatureReq> featuresToAdd, Set<FeatureReq> existingFeatures) throws Exception {
        Set<String> namedToAdd = MapUtils.map(featuresToAdd, FeatureReq::getName);
        return MapUtils.filter(existingFeatures, f -> namedToAdd.contains(f.getName()) && !featuresToAdd.contains(f));
    }

    @Override
    public void uninstallFeatures(Set<String> featuresIn, String region, EnumSet<FeaturesService.Option> options) throws Exception {
        Set<FeatureReq> featureReqs = MapUtils.map(featuresIn, FeatureReq::parseNameAndRange);
        State state = this.copyState();
        Map<String, Set<String>> required = MapUtils.copy(state.requirements);
        if (region == null || region.isEmpty()) {
            region = "root";
        }
        Set requirements = required.computeIfAbsent(region, k -> new HashSet());
        Set<FeatureReq> existingFeatures = MapUtils.map(requirements, FeatureReq::parseRequirement);
        HashSet<FeatureReq> featuresToRemove = new HashSet<FeatureReq>();
        for (FeatureReq featureReq : featureReqs) {
            Set<FeatureReq> toRemove = featureReq.getMatchingRequirements(existingFeatures);
            if (toRemove.isEmpty()) {
                throw new IllegalArgumentException("Feature named '" + featureReq + "' is not installed");
            }
            featuresToRemove.addAll(toRemove);
        }
        this.print("Removing features: " + this.join(featuresToRemove), options.contains((Object)FeaturesService.Option.Verbose));
        featuresToRemove.forEach(f -> requirements.remove(f.toRequirement()));
        if (requirements.isEmpty()) {
            required.remove(region);
        }
        this.doProvisionInThread(required, Collections.emptyMap(), state, this.getFeaturesById(), options);
    }

    @Override
    public void updateFeaturesState(Map<String, Map<String, FeatureState>> stateChanges, EnumSet<FeaturesService.Option> options) throws Exception {
        State state = this.copyState();
        this.doProvisionInThread(MapUtils.copy(state.requirements), stateChanges, state, this.getFeaturesById(), options);
    }

    @Override
    public void addRequirements(Map<String, Set<String>> requirements, EnumSet<FeaturesService.Option> options) throws Exception {
        State state = this.copyState();
        Map<String, Set<String>> required = MapUtils.copy(state.requirements);
        MapUtils.add(required, requirements);
        this.doProvisionInThread(required, Collections.emptyMap(), state, this.getFeaturesById(), options);
    }

    @Override
    public void removeRequirements(Map<String, Set<String>> requirements, EnumSet<FeaturesService.Option> options) throws Exception {
        State state = this.copyState();
        Map<String, Set<String>> required = MapUtils.copy(state.requirements);
        MapUtils.remove(required, requirements);
        this.doProvisionInThread(required, Collections.emptyMap(), state, this.getFeaturesById(), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReposAndRequirements(Set<URI> repos, Map<String, Set<String>> requirements, EnumSet<FeaturesService.Option> options) throws Exception {
        State stateCopy;
        Object object = this.lock;
        synchronized (object) {
            Set<String> reps = MapUtils.map(repos, URI::toString);
            Set<String> toRemove = MapUtils.diff(this.state.repositories, reps);
            Set<String> toAdd = MapUtils.diff(reps, this.state.repositories);
            this.state.repositories.removeAll(toRemove);
            this.state.repositories.addAll(toAdd);
            this.featureCache = null;
            for (String uri : toRemove) {
                this.repositories.removeRepository(URI.create(uri));
            }
            for (String uri : toAdd) {
                this.repositories.addRepository(this.createRepository(URI.create(uri)));
            }
            this.saveState();
            stateCopy = this.state.copy();
        }
        this.doProvisionInThread(requirements, Collections.emptyMap(), stateCopy, this.getFeaturesById(), options, false);
    }

    @Override
    public Repository createRepository(URI uri) throws Exception {
        return this.repositories.create(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Set<String>> listRequirements() {
        Object object = this.lock;
        synchronized (object) {
            return MapUtils.copy(this.state.requirements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State copyState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.copy();
        }
    }

    private String normalize(String feature) {
        int idx = feature.indexOf(47);
        if (idx < 0) {
            return feature + '/' + "0.0.0";
        }
        String name = feature.substring(0, idx);
        String version = feature.substring(idx + 1);
        return name + '/' + VersionCleaner.clean(version);
    }

    private void doProvisionInThread(Map<String, Set<String>> requirements, Map<String, Map<String, FeatureState>> stateChanges, State state, Map<String, Feature> featureById, EnumSet<FeaturesService.Option> options) throws Exception {
        this.doProvisionInThread(requirements, stateChanges, state, featureById, options, true);
    }

    private void doProvisionInThread(Map<String, Set<String>> requirements, Map<String, Map<String, FeatureState>> stateChanges, State state, Map<String, Feature> featureById, EnumSet<FeaturesService.Option> options, boolean wait) throws Exception {
        try {
            String outputFile = this.outputFile.get();
            this.outputFile.set(null);
            Future<Object> future = this.executor.submit(() -> {
                this.doProvision(requirements, stateChanges, state, featureById, options, outputFile);
                return null;
            });
            if (wait) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    private Deployer.DeploymentState getDeploymentState(State state, Map<String, Feature> featuresById) throws Exception {
        Deployer.DeploymentState dstate = new Deployer.DeploymentState();
        dstate.state = state;
        BundleInstallSupport.FrameworkInfo info = this.installSupport.getInfo();
        dstate.serviceBundle = info.ourBundle;
        dstate.configadminBundle = info.cmBundle;
        dstate.initialBundleStartLevel = info.initialBundleStartLevel;
        dstate.currentStartLevel = info.currentStartLevel;
        dstate.bundles = info.bundles;
        dstate.partitionFeatures(featuresById.values());
        RegionDigraph regionDigraph = this.installSupport.getDiGraphCopy();
        dstate.bundlesPerRegion = DigraphHelper.getBundlesPerRegion(regionDigraph);
        dstate.filtersPerRegion = DigraphHelper.getPolicies(regionDigraph);
        return dstate;
    }

    private Deployer.DeploymentRequest getDeploymentRequest(Map<String, Set<String>> requirements, Map<String, Map<String, FeatureState>> stateChanges, EnumSet<FeaturesService.Option> options, String outputFile) {
        Deployer.DeploymentRequest request = Deployer.DeploymentRequest.defaultDeploymentRequest();
        request.bundleUpdateRange = this.cfg.bundleUpdateRange;
        request.featureResolutionRange = this.cfg.featureResolutionRange;
        request.serviceRequirements = FeaturesService.ServiceRequirementsBehavior.fromString(this.cfg.serviceRequirements);
        request.updateSnaphots = FeaturesService.SnapshotUpdateBehavior.fromString(this.cfg.updateSnapshots);
        request.globalRepository = this.globalRepository;
        request.requirements = requirements;
        request.stateChanges = stateChanges;
        request.options = options;
        request.outputFile = outputFile;
        return request;
    }

    private void doProvision(Map<String, Set<String>> requirements, Map<String, Map<String, FeatureState>> stateChanges, State state, Map<String, Feature> featuresById, EnumSet<FeaturesService.Option> options, String outputFile) throws Exception {
        try (DownloadManager manager = this.createDownloadManager();){
            HashSet<String> prereqs = new HashSet<String>();
            while (true) {
                try {
                    Deployer.DeploymentState dstate = this.getDeploymentState(state, featuresById);
                    Deployer.DeploymentRequest request = this.getDeploymentRequest(requirements, stateChanges, options, outputFile);
                    new Deployer(manager, this.resolver, this).deploy(dstate, request);
                }
                catch (Deployer.PartialDeploymentException e) {
                    if (!prereqs.containsAll(e.getMissing())) {
                        prereqs.addAll(e.getMissing());
                        state = this.copyState();
                        continue;
                    }
                    throw new Exception("Deployment aborted due to loop in missing prerequisites: " + e.getMissing());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw t;
                }
                break;
            }
        }
    }

    protected DownloadManager createDownloadManager() throws IOException {
        Dictionary<String, String> props = this.getMavenConfig();
        MavenResolver resolver = MavenResolvers.createMavenResolver(props, (String)"org.ops4j.pax.url.mvn");
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(this.cfg.downloadThreads, ThreadUtils.namedThreadFactory("downloader"));
        executor.setMaximumPoolSize(this.cfg.downloadThreads);
        return DownloadManagers.createDownloadManager(resolver, executor, this.cfg.scheduleDelay, this.cfg.scheduleMaxRun);
    }

    private Dictionary<String, String> getMavenConfig() throws IOException {
        Dictionary cfg;
        Configuration config;
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (this.configurationAdmin != null && (config = this.configurationAdmin.getConfiguration("org.ops4j.pax.url.mvn", null)) != null && (cfg = config.getProperties()) != null) {
            Enumeration e = cfg.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object val = cfg.get(key);
                if (key == null) continue;
                props.put(key, val.toString());
            }
        }
        return props;
    }

    @Override
    public void print(String message, boolean verbose) {
        LOGGER.info(message);
        if (verbose) {
            System.out.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveState(State state) {
        Object object = this.lock;
        synchronized (object) {
            state.repositories.clear();
            state.repositories.addAll(this.state.repositories);
            state.bootDone.set(this.state.bootDone.get());
            this.state.replace(state);
            this.saveState();
        }
    }

    @Override
    public void persistResolveRequest(Deployer.DeploymentRequest request) throws IOException {
        this.writeResolve(request.requirements, request.options);
    }

    @Override
    public void refreshPackages(Collection<Bundle> bundles) throws InterruptedException {
        this.installSupport.refreshPackages(bundles);
    }

    @Override
    public Bundle installBundle(String region, String uri, InputStream is) throws BundleException {
        return this.installSupport.installBundle(region, uri, is);
    }

    @Override
    public void updateBundle(Bundle bundle, String uri, InputStream is) throws BundleException {
        this.installSupport.updateBundle(bundle, uri, is);
    }

    @Override
    public void uninstall(Bundle bundle) throws BundleException {
        this.installSupport.uninstall(bundle);
    }

    @Override
    public void startBundle(Bundle bundle) throws BundleException {
        this.installSupport.startBundle(bundle);
    }

    @Override
    public void stopBundle(Bundle bundle, int options) throws BundleException {
        this.installSupport.stopBundle(bundle, options);
    }

    @Override
    public void setBundleStartLevel(Bundle bundle, int startLevel) {
        this.installSupport.setBundleStartLevel(bundle, startLevel);
    }

    @Override
    public void resolveBundles(Set<Bundle> bundles, Map<Resource, List<Wire>> wiring, Map<Resource, Bundle> resToBnd) {
        this.installSupport.resolveBundles(bundles, wiring, resToBnd);
    }

    @Override
    public void replaceDigraph(Map<String, Map<String, Map<String, Set<String>>>> policies, Map<String, Set<Long>> bundles) throws BundleException, InvalidSyntaxException {
        this.installSupport.replaceDigraph(policies, bundles);
    }

    @Override
    public void installConfigs(Feature feature) throws IOException, InvalidSyntaxException {
        this.installSupport.installConfigs(feature);
    }

    @Override
    public void deleteConfigs(Feature feature) throws IOException, InvalidSyntaxException {
        this.installSupport.deleteConfigs(feature);
    }

    @Override
    public void installLibraries(Feature feature) throws IOException {
        this.installSupport.installLibraries(feature);
    }

    @Override
    public void bundleBlacklisted(BundleInfo bundleInfo) {
    }

    private String join(Collection<FeatureReq> reqs) {
        return reqs.stream().map(FeatureReq::toString).collect(Collectors.joining(","));
    }

    @Override
    public String getFeatureXml(Feature feature) {
        try {
            StringWriter sw = new StringWriter();
            Features r = new Features();
            r.getFeature().add((org.apache.karaf.features.internal.model.Feature)feature);
            JaxbUtil.marshal(r, sw);
            String[] strs = sw.toString().split("\n");
            StringJoiner joiner = new StringJoiner("\n");
            for (int i = 2; i < strs.length - 1; ++i) {
                joiner.add(strs[i]);
            }
            return joiner.toString();
        }
        catch (JAXBException e) {
            return null;
        }
    }

    @Override
    public void refreshFeatures(EnumSet<FeaturesService.Option> options) throws Exception {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (Repository r : this.repositories.listRepositories()) {
            uris.add(r.getURI());
        }
        this.refreshRepositories(uris);
        this.featuresProcessor = new FeaturesProcessorImpl(this.cfg);
        this.repositories = new RepositoryCacheImpl(this.featuresProcessor);
        State state = this.copyState();
        this.doProvisionInThread(state.requirements, Collections.emptyMap(), state, this.getFeaturesById(), options);
    }
}

