/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import ch.qos.logback.classic.Level;
import java.security.AccessController;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.logback.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.spi.support.FormattingTriple;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerConsumer;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.spi.MDCAdapter;

public class PaxLoggerImpl
implements PaxLogger {
    static String FQCN = PaxLoggerImpl.class.getName();
    private final ch.qos.logback.classic.Logger m_delegate;
    private final String m_fqcn;
    private final Bundle m_bundle;
    private final PaxLoggingServiceImpl m_service;
    private boolean m_printfFormatting;

    PaxLoggerImpl(Bundle bundle, ch.qos.logback.classic.Logger delegate, String fqcn, PaxLoggingServiceImpl service, boolean printfFormatting) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
        this.m_printfFormatting = printfFormatting;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isTraceEnabled(PaxMarker marker) {
        return this.m_delegate.isTraceEnabled(marker.slf4jMarker());
    }

    public boolean isDebugEnabled(PaxMarker marker) {
        return this.m_delegate.isDebugEnabled(marker.slf4jMarker());
    }

    public boolean isInfoEnabled(PaxMarker marker) {
        return this.m_delegate.isInfoEnabled(marker.slf4jMarker());
    }

    public boolean isWarnEnabled(PaxMarker marker) {
        return this.m_delegate.isWarnEnabled(marker.slf4jMarker());
    }

    public boolean isErrorEnabled(PaxMarker marker) {
        return this.m_delegate.isErrorEnabled(marker.slf4jMarker());
    }

    public boolean isFatalEnabled(PaxMarker marker) {
        return this.m_delegate.isErrorEnabled(marker.slf4jMarker());
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.doLog(null, 0, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        if (this.isTraceEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void trace(PaxMarker marker, String message) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 0, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void trace(PaxMarker marker, String format, Object arg) {
        if (this.isTraceEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.slf4jMarker(), 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.slf4jMarker(), 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void trace(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void trace(PaxMarker marker, String format, Object ... arguments) {
        if (this.isTraceEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.slf4jMarker(), 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.slf4jMarker(), 0, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void trace(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isTraceEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.doLog(null, 10, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        if (this.isDebugEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void debug(PaxMarker marker, String message) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 10, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void debug(PaxMarker marker, String format, Object arg) {
        if (this.isDebugEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.slf4jMarker(), 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.slf4jMarker(), 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void debug(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void debug(PaxMarker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.slf4jMarker(), 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.slf4jMarker(), 10, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void debug(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isDebugEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.doLog(null, 20, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        if (this.isInfoEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void info(PaxMarker marker, String message) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 20, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void info(PaxMarker marker, String format, Object arg) {
        if (this.isInfoEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.slf4jMarker(), 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.slf4jMarker(), 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void info(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void info(PaxMarker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.slf4jMarker(), 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.slf4jMarker(), 20, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void info(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isInfoEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.doLog(null, 30, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        if (this.isWarnEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void warn(PaxMarker marker, String message) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 30, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void warn(PaxMarker marker, String format, Object arg) {
        if (this.isWarnEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.slf4jMarker(), 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.slf4jMarker(), 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void warn(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void warn(PaxMarker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.slf4jMarker(), 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.slf4jMarker(), 30, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void warn(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isWarnEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.doLog(null, 40, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        if (this.isErrorEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void error(PaxMarker marker, String message) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void error(PaxMarker marker, String format, Object arg) {
        if (this.isErrorEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void error(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void error(PaxMarker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void error(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isErrorEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void fatal(String message) {
        if (this.isFatalEnabled()) {
            this.doLog(null, 40, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void fatal(String format, Object arg) {
        if (this.isFatalEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void fatal(String format, Object arg1, Object arg2) {
        if (this.isFatalEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void fatal(String format, Object ... arguments) {
        if (this.isFatalEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void fatal(LoggerConsumer<E> consumer) throws E {
        if (this.isFatalEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void fatal(PaxMarker marker, String message) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void fatal(PaxMarker marker, String format, Object arg) {
        if (this.isFatalEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void fatal(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isFatalEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void fatal(PaxMarker marker, String format, Object ... arguments) {
        if (this.isFatalEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void fatal(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isFatalEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void audit(String message) {
        this.doLog(null, 40, this.m_fqcn, message, null, null, new Object[0]);
    }

    public void audit(String format, Object arg) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
            this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arg);
            this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public void audit(String format, Object arg1, Object arg2) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
            this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
            this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public void audit(String format, Object ... arguments) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
            this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
            this.doLog(null, 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public <E extends Exception> void audit(LoggerConsumer<E> consumer) throws E {
        consumer.accept((Logger)this);
    }

    public void audit(PaxMarker marker, String message) {
        this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, message, null, null, new Object[0]);
    }

    public void audit(PaxMarker marker, String format, Object arg) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
            this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arg);
            this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public void audit(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
            this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
            this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public void audit(PaxMarker marker, String format, Object ... arguments) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
            this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
            this.doLog(marker.slf4jMarker(), 40, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public <E extends Exception> void audit(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        consumer.accept((Logger)this);
    }

    public void fqtrace(String fqcn, String message) {
        if (this.isTraceEnabled()) {
            this.doLog(null, 0, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqdebug(String fqcn, String message) {
        if (this.isDebugEnabled()) {
            this.doLog(null, 10, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqinfo(String fqcn, String message) {
        if (this.isInfoEnabled()) {
            this.doLog(null, 20, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqwarn(String fqcn, String message) {
        if (this.isWarnEnabled()) {
            this.doLog(null, 30, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqerror(String fqcn, String message) {
        if (this.isErrorEnabled()) {
            this.doLog(null, 40, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqfatal(String fqcn, String message) {
        if (this.isFatalEnabled()) {
            this.doLog(null, 40, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqtrace(String fqcn, PaxMarker marker, String message) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 0, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqdebug(String fqcn, PaxMarker marker, String message) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 10, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqinfo(String fqcn, PaxMarker marker, String message) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 20, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqwarn(String fqcn, PaxMarker marker, String message) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 30, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqerror(String fqcn, PaxMarker marker, String message) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqfatal(String fqcn, PaxMarker marker, String message) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqtrace(String fqcn, String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.doLog(null, 0, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqdebug(String fqcn, String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.doLog(null, 10, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqinfo(String fqcn, String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.doLog(null, 20, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqwarn(String fqcn, String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.doLog(null, 30, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqerror(String fqcn, String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.doLog(null, 40, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqfatal(String fqcn, String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.doLog(null, 40, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqtrace(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 0, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqdebug(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 10, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqinfo(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 20, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqwarn(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 30, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqerror(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqfatal(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, fqcn, message, null, null, new Object[0]);
        }
    }

    public int getPaxLogLevel() {
        switch (this.m_delegate.getEffectiveLevel().toInt()) {
            case -2147483648: {
                return 6;
            }
            case 5000: {
                return 0;
            }
            case 10000: {
                return 1;
            }
            case 20000: {
                return 2;
            }
            case 30000: {
                return 3;
            }
            case 40000: {
                return 4;
            }
        }
        return 7;
    }

    public LogLevel getLogLevel() {
        Level level = this.m_delegate.getEffectiveLevel();
        if (level == null || level == Level.ALL) {
            return LogLevel.AUDIT;
        }
        if (Level.TRACE.isGreaterOrEqual(level)) {
            return LogLevel.TRACE;
        }
        if (Level.DEBUG.isGreaterOrEqual(level)) {
            return LogLevel.DEBUG;
        }
        if (Level.INFO.isGreaterOrEqual(level)) {
            return LogLevel.INFO;
        }
        if (Level.WARN.isGreaterOrEqual(level)) {
            return LogLevel.WARN;
        }
        return LogLevel.ERROR;
    }

    private LogLevel getLogLevel(int levelFromLocationAwareLogger) {
        switch (levelFromLocationAwareLogger) {
            case 0: {
                return LogLevel.TRACE;
            }
            case 10: {
                return LogLevel.DEBUG;
            }
            case 20: {
                return LogLevel.INFO;
            }
            case 30: {
                return LogLevel.WARN;
            }
            case 40: {
                return LogLevel.ERROR;
            }
        }
        return LogLevel.AUDIT;
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }

    private void doLog(Marker marker, int level, String fqcn, String message, Throwable t, ServiceReference<?> ref, Object ... args) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                this.doLog0(marker, level, fqcn, message, t, ref, args);
                return null;
            });
        } else {
            this.doLog0(marker, level, fqcn, message, t, ref, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog0(Marker marker, int level, String fqcn, String message, Throwable t, ServiceReference<?> ref, Object ... args) {
        this.setDelegateContext();
        try {
            this.m_delegate.log(marker, fqcn, level, message, args, t);
        }
        finally {
            this.clearDelegateContext();
        }
        LogLevel l = this.getLogLevel(level);
        this.m_service.handleEvents(this.getName(), this.m_bundle, ref, l, message, t);
    }

    private void setDelegateContext() {
        MDCAdapter adapter = MDC.getMDCAdapter();
        if (this.m_bundle != null && adapter != null) {
            adapter.put("bundle.id", String.valueOf(this.m_bundle.getBundleId()));
            adapter.put("bundle.name", this.m_bundle.getSymbolicName());
            adapter.put("bundle.version", this.m_bundle.getVersion().toString());
        }
        if (adapter != null) {
            adapter.remove(".log4j2_message");
        }
        this.m_service.lock(false);
    }

    private void clearDelegateContext() {
        this.m_service.unlock(false);
        MDCAdapter adapter = MDC.getMDCAdapter();
        if (this.m_bundle != null && adapter != null) {
            adapter.remove("bundle.id");
            adapter.remove("bundle.name");
            adapter.remove("bundle.version");
        }
    }
}

