/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.util;

import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LoggerFactory;
import org.slf4j.Logger;

public class Log {
    protected Optional<org.osgi.service.log.Logger> osgiLogger;
    protected Optional<Logger> slf4jLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log(Class<?> clazz) {
        block6: {
            this.osgiLogger = Optional.empty();
            this.slf4jLogger = Optional.empty();
            try {
                BundleContext context;
                ServiceReference factoryRef;
                Bundle bundle = FrameworkUtil.getBundle(clazz);
                if (bundle == null || (factoryRef = (context = bundle.getBundleContext()).getServiceReference(LoggerFactory.class)) == null) break block6;
                try {
                    this.osgiLogger = Optional.ofNullable(((LoggerFactory)context.getService(factoryRef)).getLogger(clazz));
                }
                finally {
                    context.ungetService(factoryRef);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!this.osgiLogger.isPresent()) {
            this.slf4jLogger = Optional.of(org.slf4j.LoggerFactory.getLogger(clazz));
        }
    }

    public void log(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                this.osgiLogger.ifPresent(l -> l.debug(status.getMessage()));
                this.slf4jLogger.ifPresent(l -> l.debug(status.getMessage()));
                break;
            }
            case 1: {
                this.osgiLogger.ifPresent(l -> l.info(status.getMessage()));
                this.slf4jLogger.ifPresent(l -> l.info(status.getMessage()));
                break;
            }
            case 2: {
                this.osgiLogger.ifPresent(l -> l.warn(status.getMessage()));
                this.slf4jLogger.ifPresent(l -> l.info(status.getMessage()));
                break;
            }
            case 4: {
                this.osgiLogger.ifPresent(l -> l.error(status.getMessage()));
                this.slf4jLogger.ifPresent(l -> l.info(status.getMessage()));
                break;
            }
            case 8: {
                this.osgiLogger.ifPresent(l -> l.warn(status.getMessage()));
                this.slf4jLogger.ifPresent(l -> l.info(status.getMessage()));
            }
        }
    }

    public void trace(String message) {
        this.osgiLogger.ifPresent(l -> l.trace(message));
        this.slf4jLogger.ifPresent(l -> l.trace(message));
    }
}

