/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.util.extensions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import net.enilink.commons.util.CommonsUtilPlugin;
import net.enilink.commons.util.extensions.RegistryFactoryHelper;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;

public abstract class RegistryReader
implements IRegistryChangeListener {
    protected static final String TAG_DESCRIPTION = "description";
    private boolean isInitialized;
    private final String extensionPointId;
    private final String pluginId;
    private final IExtensionRegistry registry;

    protected RegistryReader(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        this.registry = registry;
        this.pluginId = pluginId;
        this.extensionPointId = extensionPoint;
    }

    protected RegistryReader(String pluginId, String extensionPoint) {
        this.registry = RegistryFactoryHelper.getRegistry();
        this.pluginId = pluginId;
        this.extensionPointId = extensionPoint;
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected static void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getNamespaceIdentifier() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        CommonsUtilPlugin.logErrorMessage(buf.toString());
    }

    protected static void logMissingAttribute(IConfigurationElement element, String attributeName) {
        RegistryReader.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected static void logMissingElement(IConfigurationElement element, String elementName) {
        RegistryReader.logError(element, "Required sub element '" + elementName + "' not defined");
    }

    protected static void logUnknownElement(IConfigurationElement element) {
        RegistryReader.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        IExtension[] sortedExtension = new IExtension[extensions.length];
        System.arraycopy(extensions, 0, sortedExtension, 0, extensions.length);
        Comparator<Object> comparer = new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                String s1 = ((IExtension)a).getNamespaceIdentifier();
                String s2 = ((IExtension)b).getNamespaceIdentifier();
                return s1.compareToIgnoreCase(s2);
            }
        };
        Collections.sort(Arrays.asList(sortedExtension), comparer);
        return sortedExtension;
    }

    protected boolean readElement(IConfigurationElement element) {
        return false;
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        return add && this.readElement(element);
    }

    protected void readElementChildren(IConfigurationElement element, boolean add) {
        this.readElements(element.getChildren(), add);
    }

    protected void readElements(IConfigurationElement[] elements, boolean add) {
        for (int i = 0; i < elements.length; ++i) {
            if (this.readElement(elements[i], add)) continue;
            RegistryReader.logUnknownElement(elements[i]);
        }
    }

    protected void readExtension(IExtension extension, boolean add) {
        this.readElements(extension.getConfigurationElements(), add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRegistry() {
        if (this.isInitialized) {
            return;
        }
        RegistryReader registryReader = this;
        synchronized (registryReader) {
            if (!this.isInitialized) {
                IExtensionPoint point = this.registry.getExtensionPoint(this.pluginId, this.extensionPointId);
                if (point == null) {
                    return;
                }
                IExtension[] extensions = point.getExtensions();
                extensions = this.orderExtensions(extensions);
                for (int i = 0; i < extensions.length; ++i) {
                    this.readExtension(extensions[i], true);
                }
                this.isInitialized = true;
            }
        }
    }

    public void registerListener() {
        this.registry.addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void unregisterListener() {
        this.registry.removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        String qualifiedExtensionPointId = this.pluginId + "." + this.extensionPointId;
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        for (int i = 0; i < deltas.length; ++i) {
            IExtensionDelta delta = deltas[i];
            if (!delta.getExtensionPoint().getUniqueIdentifier().equals(qualifiedExtensionPointId)) continue;
            boolean add = delta.getKind() == 1;
            this.readExtension(delta.getExtension(), add);
        }
    }
}

