/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.util.internal.extensions;

public final class DebugHelper {
    private static final String OPTION_DEBUG = "net.enilink.commons.extensions.debug";
    public static boolean DEBUG = "true".equals(System.getProperty("net.enilink.commons.extensions.debug"));

    public static void log(String message) {
        DebugHelper.log(message, 0);
    }

    public static void log(String message, int indent) {
        System.out.println(DebugHelper.createMessage(message, indent));
    }

    public static void logError(String message) {
        DebugHelper.logError(message, 0);
    }

    public static void logError(String message, int indent) {
        System.err.println(DebugHelper.createMessage(message, indent));
    }

    public static void logError(Throwable e) {
        e.printStackTrace(System.err);
        System.err.println();
    }

    private static String createMessage(String message, int indent) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            s.append("\t");
        }
        s.append("[");
        s.append("net.enilink.commons.util");
        s.append("] ");
        if (message != null) {
            s.append(message);
        }
        return s.toString();
    }
}

