/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.util.internal.extensions;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.enilink.commons.util.internal.extensions.DebugHelper;

public class Utils {
    private static final String NONOSGIREGISTRY_PROPERTIES = "nonosgiregistry.properties";

    public static Map<String, URL> getManifestsMap(ClassLoader cl) {
        Enumeration<URL> urls = Utils.getManifests(cl);
        if (urls == null || !urls.hasMoreElements()) {
            return Collections.emptyMap();
        }
        String baseDir = null;
        HashMap<String, URL> manifests = new HashMap<String, URL>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url == null) continue;
            baseDir = Utils.getBaseDir(url, "META-INF/MANIFEST.MF");
            manifests.put(baseDir, url);
        }
        return manifests;
    }

    public static String getBaseDir(URL url, String resourcePath) {
        String path = url.getPath();
        return path.substring(0, path.length() - resourcePath.length());
    }

    public static Enumeration<URL> getManifests(ClassLoader cl) {
        return Utils.getResources(cl, "META-INF/MANIFEST.MF");
    }

    public static Enumeration<URL> getPluginXMLs(ClassLoader cl) {
        return Utils.getResources(cl, "plugin.xml");
    }

    private static Enumeration<URL> getResources(ClassLoader cl, String resourcePath) {
        try {
            return cl == null ? ClassLoader.getSystemResources(resourcePath) : cl.getResources(resourcePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() < 1;
    }

    public static Properties load(ClassLoader cl) {
        Enumeration<URL> nonosgiregistryProperties;
        Properties nonosgiregistryProps;
        block5: {
            nonosgiregistryProps = new Properties();
            nonosgiregistryProperties = null;
            try {
                nonosgiregistryProperties = cl == null ? ClassLoader.getSystemResources(NONOSGIREGISTRY_PROPERTIES) : cl.getResources(NONOSGIREGISTRY_PROPERTIES);
            }
            catch (IOException e) {
                if (!DebugHelper.DEBUG) break block5;
                DebugHelper.logError(e);
            }
        }
        while (nonosgiregistryProperties.hasMoreElements()) {
            URL url = nonosgiregistryProperties.nextElement();
            if (url == null) continue;
            try {
                nonosgiregistryProps.load(url.openStream());
            }
            catch (IOException e) {
                if (!DebugHelper.DEBUG) continue;
                DebugHelper.logError(e);
            }
        }
        return nonosgiregistryProps;
    }
}

