/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.dm.change;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.change.DataChangeTracker;
import net.enilink.komma.dm.change.IDataChange;
import net.enilink.komma.dm.change.IDataChangeStack;

public class DataChangeStack
extends DataChangeTracker
implements IDataChangeStack {
    private boolean trackChanges = true;
    private int saveLocation = 0;
    private int undoLimit = 0;
    private Stack<List<IDataChange>> undoStack = new Stack();
    private Stack<List<IDataChange>> redoStack = new Stack();

    @Override
    public void flush() {
        this.redoStack.clear();
        this.undoStack.clear();
        this.saveLocation = 0;
    }

    @Override
    public int getUndoLimit() {
        return this.undoLimit;
    }

    @Override
    protected void handleChanges(List<IDataChange> committed) {
        if (this.trackChanges) {
            this.pushChanges(committed);
        }
        super.handleChanges(committed);
    }

    @Override
    public boolean isDirty() {
        return this.undoStack.size() != this.saveLocation;
    }

    @Override
    public void markSaveLocation() {
        this.saveLocation = this.undoStack.size();
    }

    public void pushChanges(List<IDataChange> changes) {
        if (this.getUndoLimit() > 0) {
            while (this.undoStack.size() >= this.getUndoLimit()) {
                this.undoStack.remove(0);
                if (this.saveLocation <= -1) continue;
                --this.saveLocation;
            }
        }
        if (this.saveLocation > this.undoStack.size()) {
            this.saveLocation = -1;
        }
        this.undoStack.push(changes);
    }

    private void redo(List<IDataChange> changes, IDataManager dm) {
        for (IDataChange change : changes) {
            change.redo(dm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo(IDataManager dm) {
        try {
            this.trackChanges = false;
            Map map = this.activeDataManagers;
            synchronized (map) {
                List activeChanges;
                boolean active = dm.getTransaction().isActive();
                if (!active) {
                    dm.getTransaction().begin();
                }
                if (!this.redoStack.isEmpty()) {
                    this.redo(this.redoStack.pop(), dm);
                }
                if ((activeChanges = (List)this.activeDataManagers.get(dm)) != null) {
                    this.redo(activeChanges, dm);
                }
                if (!active) {
                    dm.getTransaction().commit();
                }
            }
        }
        finally {
            this.trackChanges = true;
        }
    }

    @Override
    public void setUndoLimit(int undoLimit) {
        this.undoLimit = undoLimit;
    }

    private void undo(List<IDataChange> changes, IDataManager dm) {
        for (int i = changes.size() - 1; i >= 0; --i) {
            IDataChange change = changes.get(i);
            change.undo(dm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo(IDataManager dm) {
        try {
            this.trackChanges = false;
            Map map = this.activeDataManagers;
            synchronized (map) {
                List activeChanges;
                boolean active = dm.getTransaction().isActive();
                if (!active) {
                    dm.getTransaction().begin();
                }
                if ((activeChanges = (List)this.activeDataManagers.get(dm)) != null) {
                    this.undo(activeChanges, dm);
                }
                if (!this.undoStack.isEmpty()) {
                    List<IDataChange> changes = this.undoStack.pop();
                    this.undo(changes, dm);
                    this.redoStack.add(changes);
                }
                if (!active) {
                    dm.getTransaction().commit();
                }
            }
        }
        finally {
            this.trackChanges = true;
        }
    }
}

