/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.dm.change;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.URI;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.change.IDataChange;
import net.enilink.komma.dm.change.IDataChangeListener;
import net.enilink.komma.dm.change.IDataChangeSupport;
import net.enilink.komma.dm.change.IDataChangeTracker;
import net.enilink.komma.dm.internal.change.AddChange;
import net.enilink.komma.dm.internal.change.NamespaceChange;
import net.enilink.komma.dm.internal.change.RemoveChange;

public class DataChangeTracker
implements IDataChangeSupport,
IDataChangeTracker {
    protected Map<IDataManager, List<IDataChange>> activeDataManagers = new HashMap<IDataManager, List<IDataChange>>();
    protected WeakHashMap<IDataManager, Object> disabledDataManagers = new WeakHashMap();
    private CopyOnWriteArraySet<IDataChangeListener> listeners = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<IDataChangeListener> internalListeners = new CopyOnWriteArraySet();
    private ThreadLocal<Boolean> disabled = new ThreadLocal();

    @Override
    public void add(IDataManager dm, IStatement stmt) {
        this.addChange(dm, new AddChange(stmt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChange(IDataManager dm, IDataChange change) {
        Map<IDataManager, List<IDataChange>> map = this.activeDataManagers;
        synchronized (map) {
            this.ensureList(this.activeDataManagers, dm).add(change);
        }
    }

    @Override
    public void addChangeListener(IDataChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void addInternalChangeListener(IDataChangeListener changeListener) {
        this.internalListeners.add(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(IDataManager dm) {
        Map<IDataManager, List<IDataChange>> map = this.activeDataManagers;
        synchronized (map) {
            this.activeDataManagers.remove(dm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(IDataManager dm) {
        ArrayList<IDataChange> committed = null;
        Map<IDataManager, List<IDataChange>> map = this.activeDataManagers;
        synchronized (map) {
            List<IDataChange> changes = this.activeDataManagers.get(dm);
            if (changes != null && !changes.isEmpty()) {
                committed = new ArrayList<IDataChange>(changes);
                changes.clear();
            }
        }
        if (committed != null) {
            this.handleChanges(committed);
        }
    }

    @Override
    public void dataChanged(List<IDataChange> changes) {
        this.handleChanges(changes);
    }

    private <K, T> List<T> ensureList(Map<K, List<T>> map, K key) {
        List<T> list = map.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(key, list);
        }
        return list;
    }

    protected void handleChanges(List<IDataChange> committed) {
        this.notifyListeners(committed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled(IDataManager dm) {
        if (this.disabled.get() != null) {
            return false;
        }
        WeakHashMap<IDataManager, Object> weakHashMap = this.disabledDataManagers;
        synchronized (weakHashMap) {
            return this.disabledDataManagers.get(dm) == null;
        }
    }

    protected void notifyListeners(List<IDataChange> changes) {
        for (IDataChangeListener internalChangeListener : this.internalListeners) {
            internalChangeListener.dataChanged(changes);
        }
        for (IDataChangeListener changeListener : this.listeners) {
            changeListener.dataChanged(changes);
        }
    }

    @Override
    public void remove(IDataManager dm, IStatement stmt) {
        this.addChange(dm, new RemoveChange(stmt));
    }

    @Override
    public void removeChangeListener(IDataChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void removeInternalChangeListener(IDataChangeListener changeListener) {
        this.internalListeners.remove(changeListener);
    }

    @Override
    public void removeNamespace(IDataManager dm, String prefix, URI namespace) {
        NamespaceChange change = new NamespaceChange(prefix, namespace, null);
        this.addChange(dm, change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(IDataManager dm) {
        Map<IDataManager, List<IDataChange>> map = this.activeDataManagers;
        synchronized (map) {
            List<IDataChange> changes = this.activeDataManagers.get(dm);
            if (changes != null) {
                changes.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(IDataManager dm, boolean enabled) {
        if (dm == null) {
            if (enabled) {
                this.disabled.remove();
            } else {
                this.disabled.set(true);
            }
        } else {
            WeakHashMap<IDataManager, Object> weakHashMap = this.disabledDataManagers;
            synchronized (weakHashMap) {
                if (enabled) {
                    this.disabledDataManagers.remove(dm);
                } else {
                    this.disabledDataManagers.put(dm, true);
                }
            }
        }
    }

    @Override
    public void setNamespace(IDataManager dm, String prefix, URI oldNS, URI newNS) {
        NamespaceChange change = new NamespaceChange(prefix, oldNS, newNS);
        this.addChange(dm, change);
    }
}

