/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import java.math.BigDecimal;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class BigDecimalConverter
implements IConverter<BigDecimal> {
    @Inject
    private ILiteralFactory lf;

    @Override
    public String getJavaClassName() {
        return BigDecimal.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSCHEMA.TYPE_DECIMAL;
    }

    @Override
    public void setDatatype(URI dt) {
        if (!dt.equals((Object)this.getDatatype())) {
            throw new IllegalArgumentException(dt.toString());
        }
    }

    @Override
    public BigDecimal deserialize(String label) {
        return new BigDecimal(label);
    }

    @Override
    public ILiteral serialize(BigDecimal object) {
        return this.lf.createLiteral(object.toString(), this.getDatatype(), null);
    }
}

