/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import java.math.BigInteger;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class BigIntegerConverter
implements IConverter<BigInteger> {
    @Inject
    private ILiteralFactory lf;

    @Override
    public String getJavaClassName() {
        return BigInteger.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSCHEMA.TYPE_INTEGER;
    }

    @Override
    public void setDatatype(URI dt) {
        if (!dt.equals((Object)this.getDatatype())) {
            throw new IllegalArgumentException(dt.toString());
        }
    }

    @Override
    public BigInteger deserialize(String label) {
        return new BigInteger(label);
    }

    @Override
    public ILiteral serialize(BigInteger object) {
        return this.lf.createLiteral(object.toString(), this.getDatatype(), null);
    }
}

