/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class ByteConverter
implements IConverter<Byte> {
    @Inject
    private ILiteralFactory lf;

    @Override
    public String getJavaClassName() {
        return Byte.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSCHEMA.TYPE_BYTE;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)this.getDatatype())) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Byte deserialize(String label) {
        return Byte.valueOf(label);
    }

    @Override
    public ILiteral serialize(Byte object) {
        return this.lf.createLiteral(object.toString(), this.getDatatype(), null);
    }
}

